/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.sql.impl.connector.file.FileTable;
import com.hazelcast.jet.sql.impl.connector.file.ProcessorMetaSupplierProvider;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class FileTableTest {
    private Object[] keys() {
        return new Object[]{new Object[]{"schema1", "name1", "field1", FileFormat.json(), "schema1", "name1", "field1", FileFormat.json(), true}, new Object[]{"schema1", "name1", "field1", FileFormat.json(), "schema2", "name1", "field1", FileFormat.json(), false}, new Object[]{"schema1", "name1", "field1", FileFormat.json(), "schema1", "name2", "field1", FileFormat.json(), false}, new Object[]{"schema1", "name1", "field1", FileFormat.json(), "schema1", "name1", "field2", FileFormat.json(), false}, new Object[]{"schema1", "name1", "field1", FileFormat.json(), "schema1", "name1", "field1", FileFormat.avro(), false}};
    }

    @Test
    @Parameters(method="keys")
    public void test_objectKeyEquality(String schema1, String name1, String field1, FileFormat<?> format1, String schema2, String name2, String field2, FileFormat<?> format2, boolean expected) {
        FileTable.FilePlanObjectKey k1 = new FileTable.FilePlanObjectKey(schema1, name1, List.of(new TableField(field1, QueryDataType.INT, false)), new ProcessorMetaSupplierProvider(Map.of("key", "value"), format1));
        FileTable.FilePlanObjectKey k2 = new FileTable.FilePlanObjectKey(schema2, name2, Collections.singletonList(new TableField(field2, QueryDataType.INT, false)), new ProcessorMetaSupplierProvider(Collections.singletonMap("key", "value"), format2));
        Assertions.assertThat((boolean)k1.equals((Object)k2)).isEqualTo(expected);
        Assertions.assertThat((k1.hashCode() == k2.hashCode() ? 1 : 0) != 0).isEqualTo(expected);
    }
}

