/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlPlanCacheTest
extends SqlTestSupport {
    @BeforeClass
    public static void setUpClass() {
        SqlPlanCacheTest.initialize((int)2, null);
        Arrays.stream(SqlPlanCacheTest.instances()).forEach(instance -> SqlPlanCacheTest.sqlServiceImpl(instance).getInternalService().getStateRegistryUpdater().setStateCheckFrequency(Long.MAX_VALUE));
    }

    @Test
    public void test_distributedInvalidation() {
        TestBatchSqlConnector.create(SqlPlanCacheTest.instance().getSql(), "t", 1);
        SqlPlanCacheTest.instances()[0].getSql().execute("SELECT * FROM t", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instances()[0]).size()).isEqualTo(1);
        SqlPlanCacheTest.instances()[1].getSql().execute("SELECT * FROM t", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instances()[1]).size()).isEqualTo(1);
        SqlPlanCacheTest.instances()[0].getSql().execute("DROP MAPPING t", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instances()[0]).size()).isEqualTo(0);
        SqlPlanCacheTest.assertTrueEventually(() -> Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instances()[1]).size()).isEqualTo(0));
    }
}

