/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.config.IndexType;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.internal.tpcengine.util.OS;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.SimpleTestInClusterSupport;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.file.FileSqlConnector;
import com.hazelcast.jet.sql.impl.connector.kafka.KafkaSqlConnector;
import com.hazelcast.jet.sql.impl.connector.map.IMapSqlConnector;
import com.hazelcast.jet.sql.impl.schema.TypeUtils;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.SqlInternalService;
import com.hazelcast.sql.impl.SqlServiceImpl;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.plan.cache.PlanCache;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.Accessors;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public abstract class SqlTestSupport
extends SimpleTestInClusterSupport {
    private static final ILogger SUPPORT_LOGGER = Logger.getLogger(SqlTestSupport.class);

    @After
    public void tearDown() {
        if (SqlTestSupport.instances() == null) {
            return;
        }
        for (HazelcastInstance instance : SqlTestSupport.instances()) {
            PlanCache planCache = SqlTestSupport.planCache(instance);
            SUPPORT_LOGGER.info("Removing " + planCache.size() + " cached plans in SqlTestSupport.@After");
            planCache.clear();
        }
    }

    public static <K, V> void assertMapEventually(String mapName, String sql, Map<K, V> expected) {
        SqlTestSupport.assertMapEventually(mapName, sql, Collections.emptyList(), expected);
    }

    public static <K, V> void assertMapEventually(String mapName, String sql, List<Object> arguments, Map<K, V> expected) {
        SqlStatement statement = new SqlStatement(sql);
        statement.setParameters(arguments);
        SqlResult result = SqlTestSupport.instance().getSql().execute(statement);
        if (result != null) {
            result.close();
        }
        IMap map = SqlTestSupport.instance().getMap(mapName);
        SqlTestSupport.assertTrueEventually(() -> SqlTestSupport.lambda$assertMapEventually$0((Map)map, expected), (long)10L);
    }

    public static void assertRowsEventuallyInAnyOrder(String sql, Collection<Row> expectedRows) {
        SqlTestSupport.assertRowsEventuallyInAnyOrder(sql, Collections.emptyList(), expectedRows);
    }

    public static void assertRowsEventuallyInAnyOrder(String sql, List<Object> arguments, Collection<Row> expectedRows) {
        SqlTestSupport.assertRowsEventuallyInAnyOrder(sql, arguments, expectedRows, 50L);
    }

    public static void assertRowsAnyOrder(String sql, Row ... rows) {
        SqlTestSupport.assertRowsAnyOrder(sql, List.of(rows));
    }

    public static void assertRowsAnyOrder(String sql, List<Object> arguments, Row ... rows) {
        SqlTestSupport.assertRowsAnyOrder(sql, arguments, List.of(rows));
    }

    public static void assertRowsEventuallyInAnyOrder(String sql, List<Object> arguments, Collection<Row> expectedRows, long timeoutForNextMs) {
        SqlTestSupport.assertRowsEventuallyInAnyOrder(SqlTestSupport.instance(), sql, arguments, expectedRows, timeoutForNextMs);
    }

    public static void assertRowsEventuallyInAnyOrder(HazelcastInstance instance, String sql, Collection<Row> expectedRows) {
        SqlTestSupport.assertRowsEventuallyInAnyOrder(instance, sql, Collections.emptyList(), expectedRows, 50L);
    }

    public static void assertRowsEventuallyInAnyOrder(HazelcastInstance instance, String sql, List<Object> arguments, Collection<Row> expectedRows, long timeoutForNextMs) {
        SqlService sqlService = instance.getSql();
        CompletableFuture future = new CompletableFuture();
        ArrayDeque rows = new ArrayDeque();
        Thread thread = new Thread(() -> {
            SqlStatement statement = new SqlStatement(sql);
            arguments.forEach(arg_0 -> ((SqlStatement)statement).addParameter(arg_0));
            try (SqlResult result = sqlService.execute(statement);){
                ResultIterator iterator = (ResultIterator)result.iterator();
                for (int i = 0; i < expectedRows.size() && (iterator.hasNext() || iterator.hasNext(timeoutForNextMs, TimeUnit.MILLISECONDS) == ResultIterator.HasNextResult.YES); ++i) {
                    rows.add(new Row((SqlRow)iterator.next()));
                }
                future.complete(null);
            }
            catch (Throwable e) {
                e.printStackTrace();
                future.completeExceptionally(e);
            }
        });
        thread.start();
        try {
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                thread.interrupt();
                thread.join();
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow((Throwable)e);
        }
        ArrayList actualRows = new ArrayList(rows);
        Assertions.assertThat(actualRows).containsExactlyInAnyOrderElementsOf(expectedRows);
    }

    public static void assertTipOfStream(String sql, Collection<Row> expectedRows) {
        assert (!expectedRows.isEmpty()) : "no point in asserting a zero-length tip of a stream";
        SqlService sqlService = SqlTestSupport.instance().getSql();
        CompletableFuture future = new CompletableFuture();
        ArrayDeque rows = new ArrayDeque();
        Thread thread = new Thread(() -> {
            SqlStatement statement = new SqlStatement(sql);
            try (SqlResult result = sqlService.execute(statement);){
                Iterator iterator = result.iterator();
                for (int i = 0; i < expectedRows.size() && iterator.hasNext(); ++i) {
                    rows.add(new Row((SqlRow)iterator.next()));
                }
                future.complete(null);
            }
            catch (Throwable e) {
                e.printStackTrace();
                future.completeExceptionally(e);
            }
        });
        thread.start();
        try {
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                thread.interrupt();
                thread.join();
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow((Throwable)e);
        }
        ArrayList actualRows = new ArrayList(rows);
        Assertions.assertThat(actualRows).containsExactlyElementsOf(expectedRows);
    }

    public static void assertEmptyResultStream(String sql) {
        Future future;
        try (SqlResult result = SqlTestSupport.instance().getSql().execute(sql, new Object[0]);){
            future = SqlTestSupport.spawn(() -> result.iterator().hasNext());
            SqlTestSupport.assertTrueAllTheTime(() -> Assert.assertFalse((boolean)future.isDone()), (long)2L);
        }
        SqlTestSupport.assertTrueEventually(() -> Assert.assertTrue((boolean)future.isDone()));
    }

    public static void assertRowsAnyOrder(String sql, Collection<Row> expectedRows) {
        SqlTestSupport.assertRowsAnyOrder(sql, Collections.emptyList(), expectedRows);
    }

    public static void assertRowsAnyOrder(HazelcastInstance instance, String sql, Collection<Row> expectedRows) {
        SqlTestSupport.assertRowsAnyOrder(instance, sql, Collections.emptyList(), expectedRows);
    }

    public static void assertDoesNotContainRow(HazelcastInstance instance, String sql, Collection<Row> expectedRows) {
        SqlStatement statement = new SqlStatement(sql);
        SqlService sqlService = instance.getSql();
        List<Row> actualRows = SqlTestSupport.allRows(statement, sqlService);
        Assertions.assertThat(actualRows).doesNotContainAnyElementsOf(expectedRows);
    }

    public static void assertRowsAnyOrder(String sql, List<Object> arguments, Collection<Row> expectedRows) {
        SqlTestSupport.assertRowsAnyOrder(SqlTestSupport.instance(), sql, arguments, expectedRows);
    }

    public static void assertRowsAnyOrder(HazelcastInstance instance, String sql, List<Object> arguments, Collection<Row> expectedRows) {
        SqlStatement statement = new SqlStatement(sql);
        arguments.forEach(arg_0 -> ((SqlStatement)statement).addParameter(arg_0));
        SqlService sqlService = instance.getSql();
        List<Row> actualRows = SqlTestSupport.allRows(statement, sqlService);
        Assertions.assertThat(actualRows).containsExactlyInAnyOrderElementsOf(expectedRows);
    }

    @Nonnull
    protected static List<Row> allRows(SqlStatement statement, SqlService sqlService) {
        ArrayList<Row> actualRows = new ArrayList<Row>();
        try (SqlResult result = sqlService.execute(statement);){
            result.iterator().forEachRemaining(row -> actualRows.add(new Row((SqlRow)row)));
        }
        return actualRows;
    }

    @Nonnull
    protected static List<Row> allRows(String statement, SqlService sqlService) {
        try (SqlResult result = sqlService.execute(statement, new Object[0]);){
            List<Row> list = SqlTestSupport.allRows(result);
            return list;
        }
    }

    @Nonnull
    protected static List<Row> allRows(SqlResult result) {
        ArrayList<Row> actualRows = new ArrayList<Row>();
        result.iterator().forEachRemaining(row -> actualRows.add(new Row((SqlRow)row)));
        return actualRows;
    }

    public static void assertRowsOrdered(String sql, List<Row> expectedRows) {
        SqlTestSupport.assertRowsOrdered(SqlTestSupport.instance(), sql, expectedRows);
    }

    public static void assertRowsOrdered(HazelcastInstance instance, String sql, List<Row> expectedRows) {
        SqlService sqlService = instance.getSql();
        ArrayList actualRows = new ArrayList();
        try (SqlResult result = sqlService.execute(sql, new Object[0]);){
            result.iterator().forEachRemaining(row -> actualRows.add(new Row((SqlRow)row)));
        }
        Assertions.assertThat(actualRows).containsExactlyElementsOf(expectedRows);
    }

    public static void checkEquals(Object first, Object second, boolean expected) {
        if (expected) {
            Assert.assertEquals((Object)first, (Object)second);
            Assert.assertEquals((long)first.hashCode(), (long)second.hashCode());
        } else {
            Assert.assertNotEquals((Object)first, (Object)second);
        }
    }

    public static <T> T serializeAndCheck(Object original, int expectedClassId) {
        Assert.assertTrue((boolean)(original instanceof IdentifiedDataSerializable));
        IdentifiedDataSerializable original0 = (IdentifiedDataSerializable)original;
        Assert.assertEquals((long)JetSqlSerializerHook.F_ID, (long)original0.getFactoryId());
        Assert.assertEquals((long)expectedClassId, (long)original0.getClassId());
        return SqlTestSupport.serialize(original);
    }

    public static <T> T serialize(Object original) {
        InternalSerializationService ss = SqlTestSupport.serializationService();
        return (T)ss.toObject((Object)ss.toData(original));
    }

    public static InternalSerializationService serializationService() {
        return new DefaultSerializationServiceBuilder().build();
    }

    public static void createMapping(String name, Class<?> keyClass, Class<?> valueClass) {
        SqlTestSupport.createMapping(SqlTestSupport.instance(), name, keyClass, valueClass);
    }

    public static void createMapping(HazelcastInstance instance, String name, Class<?> keyClass, Class<?> valueClass) {
        try (SqlResult result = instance.getSql().execute("CREATE OR REPLACE MAPPING " + name + " TYPE IMap\nOPTIONS (\n'keyFormat'='java'\n, 'keyJavaClass'='" + keyClass.getName() + "'\n, 'valueFormat'='java'\n, 'valueJavaClass'='" + valueClass.getName() + "'\n)", new Object[0]);){
            Assertions.assertThat((long)result.updateCount()).isEqualTo(0L);
        }
    }

    public static void createMapping(String name, int keyFactoryId, int keyClassId, int keyVersion, int valueFactoryId, int valueClassId, int valueVersion) {
        SqlTestSupport.createMapping(SqlTestSupport.instance(), name, keyFactoryId, keyClassId, keyVersion, valueFactoryId, valueClassId, valueVersion);
    }

    public static void createMapping(HazelcastInstance instance, String name, int keyFactoryId, int keyClassId, int keyVersion, int valueFactoryId, int valueClassId, int valueVersion) {
        try (SqlResult result = instance.getSql().execute("CREATE OR REPLACE MAPPING " + name + " TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='" + keyFactoryId + "', 'keyPortableClassId'='" + keyClassId + "', 'keyPortableClassVersion'='" + keyVersion + "', 'valueFormat'='portable', 'valuePortableFactoryId'='" + valueFactoryId + "', 'valuePortableClassId'='" + valueClassId + "', 'valuePortableClassVersion'='" + valueVersion + "')", new Object[0]);){
            Assertions.assertThat((long)result.updateCount()).isEqualTo(0L);
        }
    }

    public static void createMapping(String name, Class<?> keyClass, int valueFactoryId, int valueClassId, int valueVersion) {
        SqlTestSupport.createMapping(SqlTestSupport.instance(), name, keyClass, valueFactoryId, valueClassId, valueVersion);
    }

    public static void createMapping(HazelcastInstance instance, String name, Class<?> keyClass, int valueFactoryId, int valueClassId, int valueVersion) {
        try (SqlResult result = instance.getSql().execute("CREATE OR REPLACE MAPPING " + name + " TYPE IMap OPTIONS ('keyFormat'='java', 'keyJavaClass'='" + keyClass.getName() + "', 'valueFormat'='portable', 'valuePortableFactoryId'='" + valueFactoryId + "', 'valuePortableClassId'='" + valueClassId + "', 'valuePortableClassVersion'='" + valueVersion + "')", new Object[0]);){
            Assertions.assertThat((long)result.updateCount()).isEqualTo(0L);
        }
    }

    public static void createMapping(String name, String keyFormat, String valueFormat) {
        SqlTestSupport.createMapping(SqlTestSupport.instance(), name, keyFormat, valueFormat);
    }

    public static void createMapping(HazelcastInstance instance, String name, String keyFormat, String valueFormat) {
        String sql = "CREATE OR REPLACE MAPPING " + name + " TYPE IMap\nOPTIONS (\n'keyFormat'='" + keyFormat + "'\n, 'valueFormat'='" + valueFormat + "'\n)";
        try (SqlResult result = instance.getSql().execute(sql, new Object[0]);){
            Assertions.assertThat((long)result.updateCount()).isEqualTo(0L);
        }
    }

    public static void createIndex(String name, String mapName, IndexType type, String ... attributes) {
        SqlTestSupport.createIndex(SqlTestSupport.instance(), name, mapName, type, attributes);
    }

    public static void createIndex(HazelcastInstance instance, String name, String mapName, IndexType type, String ... attributes) {
        SqlService sqlService = instance.getSql();
        StringBuilder sb = new StringBuilder("CREATE INDEX IF NOT EXISTS ");
        sb.append(name);
        sb.append(" ON ");
        sb.append(mapName);
        sb.append(" ( ");
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes.length - i - 1 == 0) {
                sb.append(attributes[i]);
                continue;
            }
            sb.append(attributes[i]).append(", ");
        }
        sb.append(" ) ");
        sb.append(" TYPE ");
        sb.append(type.name());
        sqlService.execute(sb.toString(), new Object[0]);
    }

    public static void createDataConnection(HazelcastInstance instance, String name, String type, boolean shared, Map<String, String> options) {
        StringBuilder queryBuilder = new StringBuilder().append("CREATE OR REPLACE DATA CONNECTION ").append(SqlTestSupport.quoteName(name)).append(" TYPE ").append(SqlTestSupport.quoteName(type)).append(shared ? " SHARED " : " NOT SHARED ").append(" OPTIONS (\n");
        for (Map.Entry<String, String> entry : options.entrySet()) {
            queryBuilder.append("'").append(entry.getKey()).append("'").append(" = ").append("'").append(entry.getValue()).append("',");
        }
        queryBuilder.setLength(queryBuilder.length() - 1);
        queryBuilder.append(")");
        try (SqlResult result = instance.getSql().execute(queryBuilder.toString(), new Object[0]);){
            Assertions.assertThat((long)result.updateCount()).isEqualTo(0L);
        }
    }

    public static String quoteName(String name) {
        return "\"" + name.replace("\"", "\"\"") + "\"";
    }

    public static String randomName() {
        return "o_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }

    public static boolean compareRowLists(List<?> expected, List<?> actual) {
        if (expected.size() != actual.size()) {
            return false;
        }
        for (int i = 0; i < expected.size(); ++i) {
            JetSqlRow actualItem;
            JetSqlRow expectedItem;
            if (expected.get(i) instanceof JetSqlRow) {
                expectedItem = (JetSqlRow)expected.get(i);
                if (Objects.equals(expectedItem, actualItem = (JetSqlRow)actual.get(i))) continue;
                return false;
            }
            if (expected.get(i) instanceof Watermark) {
                expectedItem = (Watermark)expected.get(i);
                if (Objects.equals(expectedItem, actualItem = (Watermark)actual.get(i))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static String hadoopNonExistingPath() {
        return OS.isWindows() ? "c:\\non\\existing\\path" : "/non/existing/path";
    }

    public static SqlServiceImpl sqlServiceImpl(HazelcastInstance instance) {
        return (SqlServiceImpl)instance.getSql();
    }

    public static SqlInternalService sqlInternalService(HazelcastInstance instance) {
        return SqlTestSupport.sqlServiceImpl(instance).getInternalService();
    }

    public static PlanCache planCache(HazelcastInstance instance) {
        return SqlTestSupport.sqlServiceImpl(instance).getPlanCache();
    }

    public static MapContainer mapContainer(IMap<?, ?> map) {
        return ((MapService)((MapProxyImpl)map).getService()).getMapServiceContext().getMapContainer(map.getName());
    }

    public static NodeEngineImpl nodeEngine(HazelcastInstance instance) {
        return Accessors.getNodeEngineImpl((HazelcastInstance)instance);
    }

    public static List<Row> rows(int rowLength, Object ... values) {
        if (rowLength == 0) {
            Assertions.assertThat((Object[])values).isEmpty();
            return Collections.emptyList();
        }
        if (values.length % rowLength != 0) {
            throw new HazelcastException("Number of row value args is not divisible by row length");
        }
        ArrayList<Row> rowList = new ArrayList<Row>();
        for (int i = 0; i < values.length; i += rowLength) {
            Object[] rowValues = new Object[rowLength];
            System.arraycopy(values, i, rowValues, 0, rowLength);
            rowList.add(new Row(rowValues));
        }
        return rowList;
    }

    public static LocalTime time(long epochMillis) {
        return SqlTestSupport.timestampTz(epochMillis).toLocalTime();
    }

    public static LocalDate date(long epochMillis) {
        return SqlTestSupport.timestampTz(epochMillis).toLocalDate();
    }

    public static LocalDateTime timestamp(long epochMillis) {
        return SqlTestSupport.timestampTz(epochMillis).toLocalDateTime();
    }

    public static OffsetDateTime timestampTz(long epochMillis) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneId.systemDefault());
    }

    public static ExpressionEvalContext createExpressionEvalContext(Object ... args) {
        if (args == null) {
            args = new Object[]{};
        }
        return ExpressionEvalContext.createContext(Arrays.asList(args), (NodeEngine)(SqlTestSupport.instances() != null ? Util.getNodeEngine((HazelcastInstance)SqlTestSupport.instance()) : (NodeEngine)Mockito.mock(NodeEngineImpl.class)), (InternalSerializationService)TEST_SS, null);
    }

    public static JetSqlRow jetRow(Object ... values) {
        return new JetSqlRow((SerializationService)TEST_SS, values);
    }

    protected static Object[] row(Object ... values) {
        return values;
    }

    protected static Object[][] rows(Object[] ... rows) {
        return rows;
    }

    public static void insertLiterals(HazelcastInstance instance, String mapping, Object ... values) {
        instance.getSql().execute("INSERT INTO " + mapping + " VALUES (" + Arrays.stream(values).map(SqlTestSupport::toSQL).collect(Collectors.joining(", ")) + ")", new Object[0]);
    }

    public static void insertParams(HazelcastInstance instance, String mapping, Object ... values) {
        instance.getSql().execute("INSERT INTO " + mapping + " VALUES (" + String.join((CharSequence)", ", Collections.nCopies(values.length, "?")) + ")", values);
    }

    public static String toSQL(Object value) {
        if (value instanceof Object[]) {
            return "(" + Arrays.stream((Object[])value).map(SqlTestSupport::toSQL).collect(Collectors.joining(", ")) + ")";
        }
        return value == null || value instanceof Boolean || value instanceof Number ? String.valueOf(value) : "'" + String.valueOf(value) + "'";
    }

    private static /* synthetic */ void lambda$assertMapEventually$0(Map map, Map expected) throws Exception {
        Assertions.assertThat(new HashMap(map)).containsExactlyInAnyOrderEntriesOf(expected);
    }

    public static final class Row {
        private final Object[] values;

        public Row(SqlRow row) {
            this.values = new Object[row.getMetadata().getColumnCount()];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = row.getObject(i);
            }
        }

        public Row(Object ... values) {
            this.values = values;
        }

        public Object[] getValues() {
            return this.values;
        }

        public String toString() {
            return "Row{[" + Stream.of(this.values).map(v -> v != null ? String.valueOf(v) + "(class=" + v.getClass().getName() + ")" : null).collect(Collectors.joining(", ")) + "]}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Row row = (Row)o;
            return Arrays.equals(this.values, row.values);
        }

        public int hashCode() {
            return Arrays.hashCode(this.values);
        }
    }

    public static class Type {
        public final String name;
        public final Field[] fields;

        public Type(Mapping mapping) {
            this.name = mapping.name();
            this.fields = (Field[])mapping.fields().stream().map(Field::new).toArray(Field[]::new);
        }

        public Type(QueryDataType type) {
            this.name = type.getObjectTypeName();
            this.fields = (Field[])type.getObjectFields().stream().map(Field::new).toArray(Field[]::new);
        }

        public Type(Schema schema) {
            this.name = schema.getName();
            this.fields = schema.getType() == Schema.Type.RECORD ? (Field[])schema.getFields().stream().map(Field::new).toArray(Field[]::new) : null;
        }

        public static class Field {
            public final String name;
            public final Type type;

            public Field(MappingField field) {
                this.name = TypeUtils.FieldEnricher.plainExternalName((MappingField)field);
                this.type = new Type(field.type());
            }

            public Field(QueryDataType.QueryDataTypeField field) {
                this.name = field.getName();
                this.type = new Type(field.getType());
            }

            public Field(Schema.Field field) {
                this.name = field.name();
                this.type = new Type(field.schema());
            }
        }
    }

    private static abstract class SqlStructure<T extends SqlStructure<T>> {
        public final String name;
        public final List<String> fields = new ArrayList<String>();
        public final Map<Object, Object> options = new LinkedHashMap<Object, Object>();

        SqlStructure(String name) {
            this.name = name;
        }

        public T fields(String ... fields) {
            this.fields.addAll(List.of(fields));
            return this.me();
        }

        public T fieldsIf(boolean condition, String ... fields) {
            return condition ? this.fields(fields) : this.me();
        }

        public T options(Object ... options) {
            for (int i = 0; i < options.length / 2; ++i) {
                this.options.put(options[2 * i], options[2 * i + 1]);
            }
            return this.me();
        }

        public T optionsIf(boolean condition, Object ... options) {
            return condition ? this.options(options) : this.me();
        }

        private T me() {
            return (T)this;
        }

        public void create() {
            this.create(SqlTestSupport.instance());
        }

        public void create(HazelcastInstance instance) {
            this.create(instance, false, false);
        }

        public void createOrReplace() {
            this.createOrReplace(SqlTestSupport.instance());
        }

        public void createOrReplace(HazelcastInstance instance) {
            this.create(instance, true, false);
        }

        public void createIfNotExists() {
            this.createIfNotExists(SqlTestSupport.instance());
        }

        public void createIfNotExists(HazelcastInstance instance) {
            this.create(instance, false, true);
        }

        protected abstract void create(HazelcastInstance var1, boolean var2, boolean var3);
    }

    public static class SqlType
    extends SqlStructure<SqlType> {
        public SqlType(String name) {
            super(name);
        }

        @Override
        protected void create(HazelcastInstance instance, boolean replace, boolean ifNotExists) {
            instance.getSql().execute("CREATE " + (replace ? "OR REPLACE " : "") + "TYPE " + (ifNotExists ? "IF NOT EXISTS " : "") + this.name + (String)(this.fields.isEmpty() ? "" : " (" + String.join((CharSequence)", ", this.fields) + ")") + (String)(this.options.isEmpty() ? "" : " OPTIONS (" + this.options.entrySet().stream().map(e -> "'" + String.valueOf(e.getKey()) + "'='" + String.valueOf(e.getValue()) + "'").collect(Collectors.joining(", ")) + ")"), new Object[0]);
        }
    }

    public static class SqlMapping
    extends SqlStructure<SqlMapping> {
        private static final Map<Class<? extends SqlConnector>, String> TYPES = Map.of(FileSqlConnector.class, "File", IMapSqlConnector.class, "IMap", KafkaSqlConnector.class, "Kafka");
        public String externalName;
        public final String type;

        public SqlMapping(String name, Class<? extends SqlConnector> connector) {
            super(name);
            this.type = "TYPE " + TYPES.get(connector);
        }

        public SqlMapping(String name, String dataConnection) {
            super(name);
            this.type = "DATA CONNECTION " + dataConnection;
        }

        public SqlMapping externalName(String externalName) {
            this.externalName = externalName;
            return this;
        }

        @Override
        protected void create(HazelcastInstance instance, boolean replace, boolean ifNotExists) {
            instance.getSql().execute("CREATE " + (replace ? "OR REPLACE " : "") + "MAPPING " + (ifNotExists ? "IF NOT EXISTS " : "") + this.name + " " + (String)(this.externalName != null ? "EXTERNAL NAME " + this.externalName + " " : "") + (String)(this.fields.isEmpty() ? "" : "(" + String.join((CharSequence)", ", this.fields) + ") ") + this.type + " OPTIONS (" + this.options.entrySet().stream().map(e -> "'" + String.valueOf(e.getKey()) + "'='" + String.valueOf(e.getValue()) + "'").collect(Collectors.joining(", ")) + ")", new Object[0]);
        }

        public Type toTypeTree() {
            return new Type(SqlTestSupport.sqlServiceImpl(SqlTestSupport.instance()).getOptimizer().relationsStorage().getMapping(this.name));
        }
    }

    public static class SqlInsert {
        public final String mapping;
        public final List<String> fields = new ArrayList<String>();
        public final List<String> literals = new ArrayList<String>();
        public final List<Object> params = new ArrayList<Object>();

        public SqlInsert(String mapping) {
            this.mapping = mapping;
        }

        public SqlInsert literals(Object ... values) {
            for (int i = 0; i < values.length / 2; ++i) {
                this.fields.add((String)values[2 * i]);
                this.literals.add(SqlTestSupport.toSQL(values[2 * i + 1]));
            }
            return this;
        }

        public SqlInsert params(Object ... values) {
            for (int i = 0; i < values.length / 2; ++i) {
                this.fields.add((String)values[2 * i]);
                this.literals.add("?");
                this.params.add(values[2 * i + 1]);
            }
            return this;
        }

        public void execute() {
            this.execute(SqlTestSupport.instance());
        }

        public void execute(HazelcastInstance instance) {
            instance.getSql().execute("INSERT INTO " + this.mapping + (String)(this.fields.isEmpty() ? "" : " (" + String.join((CharSequence)", ", this.fields) + ")") + " VALUES (" + String.join((CharSequence)", ", this.literals) + ")", this.params.toArray());
        }

        public class RowValue {
            private final String field;
            private final List<String> literals = new ArrayList<String>();
            private final List<Object> params = new ArrayList<Object>();

            RowValue(String field) {
                this.field = field;
            }

            public RowValue literals(Object ... values) {
                Arrays.stream(values).map(SqlTestSupport::toSQL).forEach(this.literals::add);
                return this;
            }

            public RowValue params(Object ... values) {
                this.literals.addAll(Collections.nCopies(values.length, "?"));
                this.params.addAll(Arrays.asList(values));
                return this;
            }

            public SqlInsert end() {
                SqlInsert.this.fields.add(this.field);
                SqlInsert.this.literals.add("(" + String.join((CharSequence)", ", this.literals) + ")");
                SqlInsert.this.params.addAll(this.params);
                return SqlInsert.this;
            }
        }
    }
}

