/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlParameterTest
extends SqlTestSupport {
    private static final String MAP_NAME = "map";
    @Parameterized.Parameter
    public boolean useClient;
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private HazelcastInstance member;
    private HazelcastInstance client;

    @Parameterized.Parameters(name="useClient:{0}")
    public static Object[] parameters() {
        return new Object[]{false, true};
    }

    @Before
    public void setUp() {
        this.member = this.factory.newHazelcastInstance();
        if (this.useClient) {
            this.client = this.factory.newHazelcastClient();
        }
        SqlParameterTest.createMapping(this.member, MAP_NAME, Integer.TYPE, Integer.TYPE);
        this.member.getMap(MAP_NAME).put((Object)1, (Object)1);
    }

    @Override
    @After
    public void tearDown() {
        this.member = null;
        this.client = null;
        this.factory.shutdownAll();
    }

    @Test
    public void testParameters() {
        boolean valBoolean = true;
        byte valByte = 1;
        short valShort = 2;
        int valInt = 3;
        long valLong = 4L;
        float valFloat = 5.0f;
        double valDouble = 6.0;
        BigDecimal valDecimal = BigDecimal.valueOf(7L);
        String valString = "str";
        LocalDate valLocalDate = LocalDate.now();
        LocalTime valLocalTime = LocalTime.now();
        LocalDateTime valLocalDateTime = LocalDateTime.now();
        OffsetDateTime valOffsetDateTime = OffsetDateTime.now();
        CustomObject valObject = new CustomObject(1);
        SqlStatement statement = new SqlStatement("SELECT CAST(? as BOOLEAN), CAST(? as TINYINT), CAST(? as SMALLINT), CAST(? as INTEGER), CAST(? as BIGINT), CAST(? as REAL), CAST(? as DOUBLE), CAST(? as DECIMAL), CAST(? as VARCHAR), CAST(? as DATE), CAST(? as TIME), CAST(? as TIMESTAMP), CAST(? as TIMESTAMP WITH TIME ZONE), CAST(? as OBJECT), CAST(? as OBJECT) FROM map");
        statement.addParameter((Object)valBoolean);
        statement.addParameter((Object)valByte);
        statement.addParameter((Object)valShort);
        statement.addParameter((Object)valInt);
        statement.addParameter((Object)valLong);
        statement.addParameter((Object)Float.valueOf(valFloat));
        statement.addParameter((Object)valDouble);
        statement.addParameter((Object)valDecimal);
        statement.addParameter((Object)valString);
        statement.addParameter((Object)valLocalDate);
        statement.addParameter((Object)valLocalTime);
        statement.addParameter((Object)valLocalDateTime);
        statement.addParameter((Object)valOffsetDateTime);
        statement.addParameter((Object)valObject);
        statement.addParameter(null);
        try (SqlResult res = this.targetInstance().getSql().execute(statement);){
            for (SqlRow row : res) {
                Assert.assertEquals((Object)valBoolean, (Object)row.getObject(0));
                Assert.assertEquals((long)valByte, (long)((Byte)row.getObject(1)).byteValue());
                Assert.assertEquals((long)valShort, (long)((Short)row.getObject(2)).shortValue());
                Assert.assertEquals((long)valInt, (long)((Integer)row.getObject(3)).intValue());
                Assert.assertEquals((long)valLong, (long)((Long)row.getObject(4)));
                Assert.assertEquals((float)valFloat, (float)((Float)row.getObject(5)).floatValue(), (float)0.0f);
                Assert.assertEquals((double)valDouble, (double)((Double)row.getObject(6)), (double)0.0);
                Assert.assertEquals((Object)valDecimal, (Object)row.getObject(7));
                Assert.assertEquals((Object)valString, (Object)row.getObject(8));
                Assert.assertEquals((Object)valLocalDate, (Object)row.getObject(9));
                Assert.assertEquals((Object)valLocalTime, (Object)row.getObject(10));
                Assert.assertEquals((Object)valLocalDateTime, (Object)row.getObject(11));
                Assert.assertEquals((Object)valOffsetDateTime, (Object)row.getObject(12));
                Assert.assertEquals((Object)valObject, (Object)row.getObject(13));
                Assert.assertNull((Object)row.getObject(14));
            }
        }
    }

    @Test
    public void test_parameterNumericConversion() {
        SqlParameterTest.createMapping(this.targetInstance(), "map_short", Integer.class, Short.class);
        IMap mapShort = this.targetInstance().getMap("map_short");
        mapShort.put((Object)1, (Object)1);
        mapShort.put((Object)2, (Object)2);
        SqlParameterTest.createMapping(this.targetInstance(), "map_float", Integer.class, Float.class);
        IMap mapFloat = this.targetInstance().getMap("map_float");
        mapFloat.put((Object)1, (Object)Float.valueOf(1.6f));
        mapFloat.put((Object)2, (Object)Float.valueOf(2.6f));
        SqlParameterTest.assertRowsAnyOrder(this.targetInstance(), "select this from map_short where this>?", Collections.singletonList(1), SqlParameterTest.rows(1, (short)2));
        Assertions.assertThatThrownBy(() -> this.targetInstance().getSql().execute("select * from map_short where this>?", new Object[]{100000})).hasMessageContaining("At line 1, column 36: Failed to convert parameter at position 0 from INTEGER to SMALLINT: Numeric overflow while converting INTEGER to SMALLINT");
        SqlParameterTest.assertRowsAnyOrder(this.targetInstance(), "select this from map_short where this>?", Collections.singletonList((byte)1), SqlParameterTest.rows(1, (short)2));
        Assertions.assertThatThrownBy(() -> this.targetInstance().getSql().execute("select this from map_short where this>?", new Object[]{Float.valueOf(1.0f)})).hasMessageContaining("Parameter at position 0 must be of SMALLINT type, but REAL was found (consider adding an explicit CAST)");
        SqlParameterTest.assertRowsAnyOrder(this.targetInstance(), "select this from map_float where this>?", Collections.singletonList(2), SqlParameterTest.rows(1, Float.valueOf(2.6f)));
        SqlParameterTest.assertRowsAnyOrder(this.targetInstance(), "select this from map_float where this>?", Collections.singletonList(0x1000001), SqlParameterTest.rows(1, new Object[0]));
    }

    private HazelcastInstance targetInstance() {
        return this.useClient ? this.client : this.member;
    }

    public static class CustomObject
    implements Serializable {
        private final int id;

        public CustomObject(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomObject that = (CustomObject)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

