/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.PlanExecutor;
import com.hazelcast.partition.Partition;
import com.hazelcast.test.HazelcastSerialClassRunner;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
public class SqlClientPartitionAwareRoutingTest
extends SqlTestSupport {
    @BeforeClass
    public static void beforeClass() {
        SqlClientPartitionAwareRoutingTest.initializeWithClient((int)3, null, null);
    }

    @Before
    public void init() {
        SqlClientPartitionAwareRoutingTest.client().getSql().execute("DROP MAPPING IF EXISTS test", new Object[0]);
        SqlClientPartitionAwareRoutingTest.createMapping("test", Integer.class, String.class);
    }

    @Test
    public void test_selectRouting() {
        this.testQuery("SELECT * FROM test WHERE __key = ?", 100);
    }

    @Test
    public void test_insertRouting() {
        this.testQuery("INSERT INTO test (this, __key) VALUES ('testVal', ?)", 100);
    }

    @Test
    public void test_updateRouting() {
        this.testQuery("UPDATE test SET this = 'testVal' WHERE __key = ?", 100);
    }

    @Test
    public void test_deleteRouting() {
        this.testQuery("DELETE FROM test WHERE __key = ?", 100);
    }

    private void testQuery(String sql, int keyCount) {
        SqlClientPartitionAwareRoutingTest.assertTrueEventually(() -> {
            for (Partition partition : SqlClientPartitionAwareRoutingTest.client().getPartitionService().getPartitions()) {
                Assert.assertNotNull((Object)partition.getOwner());
            }
        });
        SqlClientPartitionAwareRoutingTest.client().getSql().execute(sql, new Object[]{0});
        long[] expectedCounts = Arrays.stream(SqlClientPartitionAwareRoutingTest.instances()).mapToLong(inst -> SqlClientPartitionAwareRoutingTest.getPlanExecutor(inst).getDirectIMapQueriesExecuted()).toArray();
        for (long i = 1L; i < (long)keyCount; ++i) {
            SqlClientPartitionAwareRoutingTest.client().getSql().execute(sql, new Object[]{i});
            int n = this.getPartitionOwnerIndex(i);
            expectedCounts[n] = expectedCounts[n] + 1L;
        }
        long[] actualCounts = Arrays.stream(SqlClientPartitionAwareRoutingTest.instances()).mapToLong(inst -> SqlClientPartitionAwareRoutingTest.getPlanExecutor(inst).getDirectIMapQueriesExecuted()).toArray();
        Assert.assertArrayEquals((long[])expectedCounts, (long[])actualCounts);
    }

    private static PlanExecutor getPlanExecutor(HazelcastInstance instance) {
        return SqlClientPartitionAwareRoutingTest.sqlServiceImpl(instance).getOptimizer().getPlanExecutor();
    }

    private int getPartitionOwnerIndex(Object key) {
        Member owner = SqlClientPartitionAwareRoutingTest.client().getPartitionService().getPartition(key).getOwner();
        for (int i = 0; i < SqlClientPartitionAwareRoutingTest.instances().length; ++i) {
            HazelcastInstance instance = SqlClientPartitionAwareRoutingTest.instances()[i];
            if (!instance.getCluster().getLocalMember().getUuid().equals(owner.getUuid())) continue;
            return i;
        }
        throw new HazelcastException("Partition Owner not found for key: " + String.valueOf(key));
    }
}

