/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.HazelcastClientInstance;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.impl.protocol.codec.SqlMappingDdlCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.partition.PartitionAware;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MCMessageTasksTest
extends SqlTestSupport {
    private static final int PORTABLE_FACTORY_ID = 1;
    private static final int PORTABLE_KEY_CLASS_ID = 2;

    @BeforeClass
    public static void setUpClass() {
        MCMessageTasksTest.initializeWithClient((int)2, (Config)MCMessageTasksTest.createConfig(MCMessageTasksTest.smallInstanceConfig()), null);
    }

    @Before
    public void setup() {
        MCMessageTasksTest.warmUpPartitions((HazelcastInstance[])MCMessageTasksTest.instances());
        MCMessageTasksTest.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{MCMessageTasksTest.client()});
    }

    protected static Config createConfig(Config baseConfig) {
        baseConfig.getMapConfig("default").setBackupCount(0);
        return baseConfig;
    }

    @Test
    public void test_sqlMappingDdl_nonExistingMap() throws Exception {
        String response = this.getMappingDdl(MCMessageTasksTest.randomMapName(), null);
        Assert.assertNull((Object)response);
    }

    @Test
    public void test_sqlMappingDdl_existingMap() throws Exception {
        String name = MCMessageTasksTest.randomMapName();
        String key = MCMessageTasksTest.generateKeyOwnedBy((HazelcastInstance)MCMessageTasksTest.instance());
        MCMessageTasksTest.instance().getMap(name).put((Object)key, (Object)"value-1");
        String response = this.getMappingDdl(name, key);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)response).startsWith((CharSequence)("CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"" + name + "\""))).containsIgnoringWhitespaces(new CharSequence[]{"'keyFormat' = 'java'"})).containsIgnoringWhitespaces(new CharSequence[]{"'valueFormat' = 'java'"});
        MCMessageTasksTest.instance().getSql().execute(response, new Object[0]).close();
        Assertions.assertThat((Iterable)MCMessageTasksTest.instance().getSql().execute("SELECT * FROM \"" + name + "\"", new Object[0])).hasSize(1);
    }

    @Test
    public void test_sqlMappingDdl_existingMapDifferentPartition() throws Exception {
        String name = MCMessageTasksTest.randomMapName();
        String key = MCMessageTasksTest.generateKeyOwnedBy((HazelcastInstance)MCMessageTasksTest.instance());
        MCMessageTasksTest.instance().getMap(name).put((Object)key, (Object)"value-1");
        String someKey = MCMessageTasksTest.generateKeyNotOwnedBy((HazelcastInstance)MCMessageTasksTest.instance());
        String response = this.getMappingDdl(name, someKey);
        Assertions.assertThat((String)response).isNull();
    }

    @Test
    public void test_sqlMappingDdl_existingMapPortableKey() throws Exception {
        String name = MCMessageTasksTest.randomMapName();
        String key = MCMessageTasksTest.generateKeyOwnedBy((HazelcastInstance)MCMessageTasksTest.instance());
        MCMessageTasksTest.instance().getMap(name).put((Object)new PortableKeyPojo(key), (Object)key);
        String response = this.getMappingDdl(name, key);
        ((AbstractStringAssert)Assertions.assertThat((String)response).startsWith((CharSequence)("CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"" + name + "\""))).containsIgnoringWhitespaces(new CharSequence[]{"'keyFormat' = 'portable'"});
        MCMessageTasksTest.instance().getSql().execute(response, new Object[0]).close();
        Assertions.assertThat((Iterable)MCMessageTasksTest.instance().getSql().execute("SELECT * FROM \"" + name + "\"", new Object[0])).hasSize(1);
    }

    @Test
    public void test_sqlMappingDdl_existingMapPortableValue() throws Exception {
        String name = MCMessageTasksTest.randomMapName();
        String key = MCMessageTasksTest.generateKeyOwnedBy((HazelcastInstance)MCMessageTasksTest.instance());
        MCMessageTasksTest.instance().getMap(name).put((Object)key, (Object)new PortableKeyPojo(key));
        String response = this.getMappingDdl(name, key);
        ((AbstractStringAssert)Assertions.assertThat((String)response).startsWith((CharSequence)("CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"" + name + "\""))).containsIgnoringWhitespaces(new CharSequence[]{"'valueFormat' = 'portable'"});
        MCMessageTasksTest.instance().getSql().execute(response, new Object[0]).close();
        Assertions.assertThat((Iterable)MCMessageTasksTest.instance().getSql().execute("SELECT * FROM \"" + name + "\"", new Object[0])).hasSize(1);
    }

    @Test
    public void test_sqlMappingDdl_emptyMap() throws Exception {
        String name = MCMessageTasksTest.randomMapName();
        MCMessageTasksTest.instance().getMap(name).clear();
        String response = this.getMappingDdl(name, null);
        Assert.assertNull((Object)response);
    }

    private HazelcastClientInstanceImpl getClientImpl() {
        return ((HazelcastClientProxy)MCMessageTasksTest.client()).client;
    }

    private String getMappingDdl(String name, String partitionKey) throws InterruptedException, ExecutionException, TimeoutException {
        ClientInvocation invocation = new ClientInvocation((HazelcastClientInstance)this.getClientImpl(), SqlMappingDdlCodec.encodeRequest((String)name), null, partitionKey != null ? MCMessageTasksTest.getPartitionId((HazelcastInstance)MCMessageTasksTest.instance(), (String)partitionKey) : -1);
        ClientDelegatingFuture future = new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.getClientImpl().getSerializationService(), SqlMappingDdlCodec::decodeResponse);
        return (String)future.get((long)ASSERT_TRUE_EVENTUALLY_TIMEOUT, TimeUnit.SECONDS);
    }

    private static class PortableKeyPojo
    implements Portable,
    PartitionAware<String> {
        private String key;

        private PortableKeyPojo(String value) {
            this.key = value;
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 2;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            writer.writeString("key_p", this.key);
        }

        public void readPortable(PortableReader reader) throws IOException {
            this.key = reader.readString("key_p");
        }

        public String getPartitionKey() {
            return this.key;
        }
    }
}

