/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.dataconnection.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.DataConnection;
import com.hazelcast.dataconnection.impl.DataConnectionServiceImpl;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.DataConnectionConsistencyChecker;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import com.hazelcast.test.AbstractHazelcastClassRunner;
import com.hazelcast.test.Accessors;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class DataConnectionConsistencyCheckerTest
extends HazelcastTestSupport {
    private DataConnectionServiceImpl linkService;
    private IMap<Object, Object> sqlCatalog;
    private DataConnectionConsistencyChecker dataConnectionConsistencyChecker;
    private String name;
    private final String type = "DUMMY";
    private HazelcastInstance[] instances;

    @Before
    public void setUp() throws Exception {
        this.instances = this.createHazelcastInstances(3);
        this.name = DataConnectionConsistencyCheckerTest.randomName();
        this.linkService = (DataConnectionServiceImpl)Accessors.getNodeEngineImpl((HazelcastInstance)this.instance()).getDataConnectionService();
        this.dataConnectionConsistencyChecker = new DataConnectionConsistencyChecker(this.instance(), (NodeEngine)Util.getNodeEngine((HazelcastInstance)this.instance()));
        if (AbstractHazelcastClassRunner.getTestMethodName().contains("NoPartitionAssignment")) {
            return;
        }
        this.sqlCatalog = this.instance().getMap("__sql.catalog");
        this.dataConnectionConsistencyChecker.init();
    }

    @After
    public void tearDown() throws Exception {
        if (this.linkService.existsSqlDataConnection(this.name)) {
            this.linkService.removeDataConnection(this.name);
        }
    }

    @Test
    public void test_missingDataConnectionWasAddedToDataConnectionService() {
        Assert.assertFalse((boolean)this.linkService.existsSqlDataConnection(this.name));
        this.sqlCatalog.put((Object)QueryUtils.wrapDataConnectionKey((String)this.name), (Object)new DataConnectionCatalogEntry(this.name, "DUMMY", false, Collections.emptyMap()));
        this.dataConnectionConsistencyChecker.check();
        Assert.assertTrue((boolean)this.linkService.existsSqlDataConnection(this.name));
        DataConnectionConfig catalogDataConnectionConfig = this.linkService.toConfig(this.name, "DUMMY", false, Collections.emptyMap());
        DataConnection dataConnection = null;
        try {
            dataConnection = this.linkService.getAndRetainDataConnection(this.name, DataConnection.class);
            Assert.assertEquals((Object)catalogDataConnectionConfig, (Object)dataConnection.getConfig());
        }
        catch (Throwable throwable) {
            Assert.assertNotNull(dataConnection);
            dataConnection.retain();
            throw throwable;
        }
        Assert.assertNotNull((Object)dataConnection);
        dataConnection.retain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_outdatedDataConnectionWasAlteredInDataConnectionService() {
        this.linkService.createOrReplaceSqlDataConnection(this.name, "DUMMY", false, Collections.emptyMap());
        Map<String, String> alteredOptions = Collections.singletonMap("a", "b");
        this.sqlCatalog.put((Object)QueryUtils.wrapDataConnectionKey((String)this.name), (Object)new DataConnectionCatalogEntry(this.name, "DUMMY", true, alteredOptions));
        DataConnectionConfig catalogDataConnectionConfig = this.linkService.toConfig(this.name, "DUMMY", true, alteredOptions);
        this.dataConnectionConsistencyChecker.check();
        DataConnection dataConnection = null;
        try {
            dataConnection = this.linkService.getAndRetainDataConnection(this.name, DataConnection.class);
            Assert.assertEquals((Object)catalogDataConnectionConfig, (Object)dataConnection.getConfig());
        }
        catch (Throwable throwable) {
            Assert.assertNotNull(dataConnection);
            dataConnection.retain();
            throw throwable;
        }
        Assert.assertNotNull((Object)dataConnection);
        dataConnection.retain();
    }

    @Test
    public void test_outdatedDataConnectionWasRemovedFromDataConnectionService() {
        this.linkService.createOrReplaceSqlDataConnection(this.name, "DUMMY", false, Collections.emptyMap());
        Assert.assertTrue((boolean)this.linkService.existsSqlDataConnection(this.name));
        Assert.assertFalse((boolean)this.sqlCatalog.containsKey((Object)QueryUtils.wrapDataConnectionKey((String)this.name)));
        this.dataConnectionConsistencyChecker.check();
        Assert.assertFalse((boolean)this.linkService.existsSqlDataConnection(this.name));
    }

    @Test
    public void test_dynamicConfigOriginatedDataConnectionWasAddedToDataConnectionService() {
        this.sqlCatalog.put((Object)QueryUtils.wrapDataConnectionKey((String)this.name), (Object)new DataConnectionCatalogEntry(this.name, "DUMMY", false, Collections.emptyMap()));
        this.linkService.createConfigDataConnection(new DataConnectionConfig(this.name).setType("DUMMY"));
        DataConnectionConsistencyCheckerTest.assertTrueEventually(() -> this.linkService.existsConfigDataConnection(this.name));
        this.dataConnectionConsistencyChecker.check();
        Assert.assertFalse((boolean)this.linkService.existsSqlDataConnection(this.name));
        Assert.assertFalse((boolean)this.sqlCatalog.containsKey((Object)QueryUtils.wrapDataConnectionKey((String)this.name)));
    }

    @Test
    public void test_dataConnectionCheckDoesNotThrow_whenNoPartitionAssignment() {
        Assert.assertFalse((boolean)Accessors.getNodeEngineImpl((HazelcastInstance)this.instance()).getPartitionService().isPartitionAssignmentDone());
        this.instance().getCluster().changeClusterState(ClusterState.FROZEN);
        this.dataConnectionConsistencyChecker.init();
        this.dataConnectionConsistencyChecker.check();
    }

    private HazelcastInstance instance() {
        return this.instances[0];
    }
}

