/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.cache.ICache;
import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.cp.CPMap;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.jet.JetService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.spring.ExposeHazelcastObjects;
import com.hazelcast.spring.HazelcastObjectExtractionConfiguration;
import com.hazelcast.sql.SqlService;
import com.hazelcast.topic.ITopic;
import javax.annotation.Nonnull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

final class BeanExporter
implements BeanDefinitionRegistryPostProcessor {
    private static final ILogger LOGGER = Logger.getLogger(BeanExporter.class);
    private final HazelcastInstance hazelcastInstance;
    private final ExposeHazelcastObjects.Configuration exposeConf;

    BeanExporter(HazelcastInstance hazelcastInstance, ExposeHazelcastObjects.Configuration exposeConf) {
        this.hazelcastInstance = hazelcastInstance;
        this.exposeConf = exposeConf;
    }

    public void postProcessBeanDefinitionRegistry(@Nonnull BeanDefinitionRegistry registry) throws BeansException {
        Config hazelcastConfiguration = this.hazelcastInstance.getConfig();
        if (LOGGER.isFineEnabled()) {
            LOGGER.fine("Exposing Hazelcast objects, using configuration: %s", (Object)this.exposeConf);
        }
        HazelcastObjectExtractionConfiguration.RegistrationChain reg = new HazelcastObjectExtractionConfiguration.RegistrationChain(this.hazelcastInstance, registry, this.exposeConf).register(registry, "jetService", JetService.class, (hz, n) -> hz.getJet()).register(registry, "sqlService", SqlService.class, (hz, n) -> hz.getSql()).register(hazelcastConfiguration.getMapConfigs(), IMap.class, HazelcastInstance::getMap).register(hazelcastConfiguration.getQueueConfigs(), IQueue.class, HazelcastInstance::getQueue).register(hazelcastConfiguration.getFlakeIdGeneratorConfigs(), FlakeIdGenerator.class, HazelcastInstance::getFlakeIdGenerator).register(hazelcastConfiguration.getMultiMapConfigs(), MultiMap.class, HazelcastInstance::getMultiMap).register(hazelcastConfiguration.getPNCounterConfigs(), PNCounter.class, HazelcastInstance::getPNCounter).register(hazelcastConfiguration.getReliableTopicConfigs(), ITopic.class, HazelcastInstance::getReliableTopic).register(hazelcastConfiguration.getReplicatedMapConfigs(), ReplicatedMap.class, HazelcastInstance::getReplicatedMap).register(hazelcastConfiguration.getRingbufferConfigs(), Ringbuffer.class, HazelcastInstance::getRingbuffer).register(hazelcastConfiguration.getSetConfigs(), ISet.class, HazelcastInstance::getSet).register(hazelcastConfiguration.getTopicConfigs(), ITopic.class, HazelcastInstance::getTopic).register(hazelcastConfiguration.getScheduledExecutorConfigs(), IScheduledExecutorService.class, HazelcastInstance::getScheduledExecutorService).register(hazelcastConfiguration.getDurableExecutorConfigs(), DurableExecutorService.class, HazelcastInstance::getDurableExecutorService).register(hazelcastConfiguration.getExecutorConfigs(), IExecutorService.class, HazelcastInstance::getExecutorService).register(hazelcastConfiguration.getListConfigs(), IList.class, HazelcastInstance::getList).register(hazelcastConfiguration.getCardinalityEstimatorConfigs(), CardinalityEstimator.class, HazelcastInstance::getCardinalityEstimator).register(hazelcastConfiguration.getCPSubsystemConfig().getCpMapConfigs(), CPMap.class, (i, n) -> i.getCPSubsystem().getMap(n)).register(hazelcastConfiguration.getCPSubsystemConfig().getLockConfigs(), FencedLock.class, (i, n) -> i.getCPSubsystem().getLock(n)).register(hazelcastConfiguration.getCPSubsystemConfig().getSemaphoreConfigs(), ISemaphore.class, (i, n) -> i.getCPSubsystem().getSemaphore(n));
        if (this.cachePresent()) {
            reg.register(hazelcastConfiguration.getCacheConfigs(), ICache.class, (instance, name) -> instance.getCacheManager().getCache(name));
        }
    }

    private boolean cachePresent() {
        String cacheClassName = "javax.cache.Cache";
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Class<?> aClass = contextClassLoader.loadClass("javax.cache.Cache");
            assert (aClass != null);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOGGER.fine("Javax Cache class '%s' not found, skipping adding ICache beans", (Object)"javax.cache.Cache");
            return false;
        }
    }

    public void postProcessBeanFactory(@Nonnull ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }
}

