/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection;

import com.h3xstream.findsecbugs.BCELUtil;
import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.common.ByteCode;
import com.h3xstream.findsecbugs.injection.AbstractInjectionDetector;
import com.h3xstream.findsecbugs.injection.ClassMethodSignature;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.SinksLoader;
import com.h3xstream.findsecbugs.taintanalysis.TaintDataflowEngine;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrameAdditionalVisitor;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldOrMethod;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public abstract class BasicInjectionDetector
extends AbstractInjectionDetector {
    private final Map<ClassMethodSignature, InjectionPoint> injectionMap = new HashMap<ClassMethodSignature, InjectionPoint>();
    private static final SinksLoader SINKS_LOADER = new SinksLoader();
    static ClassMethodSignature OBJECT = new ClassMethodSignature("java/lang/Object", "<init>", "()V");

    protected BasicInjectionDetector(BugReporter bugReporter) {
        super(bugReporter);
        this.loadCustomSinksConfigFiles();
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        assert (invoke != null && cpg != null);
        ClassMethodSignature classMethodSignature = new ClassMethodSignature(BCELUtil.getSlashedClassName(cpg, (FieldOrMethod)invoke), invoke.getMethodName(cpg), invoke.getSignature(cpg));
        if (OBJECT.equals(classMethodSignature)) {
            return InjectionPoint.NONE;
        }
        InjectionPoint injectionPoint = this.injectionMap.get(classMethodSignature);
        if (injectionPoint != null) {
            return injectionPoint;
        }
        try {
            String className = ByteCode.stripObjectArrayFromClassName(invoke.getClassName(cpg));
            if (className.startsWith("[")) {
                return InjectionPoint.NONE;
            }
            JavaClass classDef = Repository.lookupClass((String)className);
            Set<String> parentClassNames = BCELUtil.getParentClassNames(classDef);
            for (String parentClassName : parentClassNames) {
                classMethodSignature.setClassName(parentClassName);
                injectionPoint = this.injectionMap.get(classMethodSignature);
                if (injectionPoint == null) continue;
                return injectionPoint;
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)e);
        }
        return InjectionPoint.NONE;
    }

    protected void loadConfiguredSinks(InputStream stream, String bugType) throws IOException {
        SINKS_LOADER.loadSinks(stream, bugType, new SinksLoader.InjectionPointReceiver(){

            @Override
            public void receiveInjectionPoint(String fullMethodName, InjectionPoint injectionPoint) {
                BasicInjectionDetector.this.addParsedInjectionPoint(fullMethodName, injectionPoint);
            }
        });
    }

    protected void loadConfiguredSinks(String filename, String bugType) {
        SINKS_LOADER.loadConfiguredSinks(filename, bugType, new SinksLoader.InjectionPointReceiver(){

            @Override
            public void receiveInjectionPoint(String fullMethodName, InjectionPoint injectionPoint) {
                BasicInjectionDetector.this.addParsedInjectionPoint(fullMethodName, injectionPoint);
            }
        });
    }

    protected void loadCustomSinksConfigFiles() {
        String customConfigFile = FindSecBugsGlobalConfig.getInstance().getCustomSinksConfigFile(this.getClass().getSimpleName());
        if (customConfigFile != null && !customConfigFile.isEmpty()) {
            for (String configFile : customConfigFile.split(File.pathSeparator)) {
                String[] injectionDefinition = configFile.split(Pattern.quote("|"));
                if (injectionDefinition.length != 2 || injectionDefinition[0].trim().isEmpty() || injectionDefinition[1].trim().isEmpty()) {
                    AnalysisContext.logError((String)("Wrong injection config file definition: " + configFile + ". Syntax: fileName|bugType, example: sql-custom.txt|SQL_INJECTION_HIBERNATE"));
                    continue;
                }
                this.loadCustomSinks(injectionDefinition[0], injectionDefinition[1]);
            }
        }
    }

    protected void loadCustomSinks(String fileName, String bugType) {
        File file = new File(fileName);
        try (InputStream stream = file.exists() ? new FileInputStream(file) : this.getClass().getClassLoader().getResourceAsStream(fileName);){
            this.loadConfiguredSinks(stream, bugType);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot load custom injection sinks from " + fileName, ex);
        }
    }

    protected void loadSink(String line, String bugType) {
        SINKS_LOADER.loadSink(line, bugType, new SinksLoader.InjectionPointReceiver(){

            @Override
            public void receiveInjectionPoint(String fullMethodName, InjectionPoint injectionPoint) {
                BasicInjectionDetector.this.addParsedInjectionPoint(fullMethodName, injectionPoint);
            }
        });
    }

    protected void addParsedInjectionPoint(String fullMethodName, InjectionPoint injectionPoint) {
        ClassMethodSignature classMethodSignature = ClassMethodSignature.from(fullMethodName);
        assert (!this.injectionMap.containsKey(classMethodSignature)) : "Duplicate method name loaded: " + fullMethodName;
        this.injectionMap.put(classMethodSignature, injectionPoint);
    }

    public void registerVisitor(TaintFrameAdditionalVisitor visitor) {
        TaintDataflowEngine.registerAdditionalVisitor(visitor);
    }
}

