/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.InvalidPluginIdException;
import com.gradle.publish.PluginId;
import com.gradle.publish.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;

abstract class AbstractConfigValidator {
    protected static final Collection<String> FORBIDDEN_NAMESPACES = Collections.unmodifiableList(Arrays.asList("org.gradle", "com.gradleware", "com.gradle", "org.samples.greeting"));
    private static final Pattern MAVEN_ID_REGEX = Pattern.compile("[A-Za-z0-9_\\-.]+");
    private final boolean skipNamespaceCheck;

    AbstractConfigValidator(boolean skipNamespaceCheck) {
        this.skipNamespaceCheck = skipNamespaceCheck;
    }

    public abstract void validateConfig(GradlePluginDevelopmentExtension var1);

    public abstract void validatePluginConfig(PluginDeclaration var1);

    public abstract void validateTags(PluginDeclaration var1);

    public void validateMavenCoordinates(String groupId, String artifactId, String version) {
        if (Util.isBlank(groupId)) {
            throw new IllegalArgumentException("Cannot publish artifacts as no group ID set.\nPlease set the group at the project level.");
        }
        if (!MAVEN_ID_REGEX.matcher(groupId).matches()) {
            throw new IllegalArgumentException("Cannot publish artifacts as group ID '" + groupId + "' is invalid.\nValid group IDs may include alphanumeric characters, numbers, dashes,\nunderscores and dots.");
        }
        if (this.failsNamespaceCheck(groupId)) {
            throw new IllegalArgumentException("Cannot publish artifacts as group ID '" + groupId + "' is not allowed.\nGroup IDs cannot begin with " + String.join((CharSequence)", ", FORBIDDEN_NAMESPACES));
        }
        if (!MAVEN_ID_REGEX.matcher(artifactId).matches()) {
            throw new IllegalArgumentException("Cannot publish artifacts as artifact ID '" + artifactId + "' is invalid.\nValid artifact IDs may include alphanumeric characters, numbers, dashes,\nunderscores and dots.");
        }
        if (artifactId.equals(groupId + ".gradle.plugin")) {
            throw new IllegalArgumentException("Group ID + '.gradle.plugin' suffix not allowed as artifact ID");
        }
        if (Util.isBlank(version) || version.equals("unspecified")) {
            throw new IllegalArgumentException("Cannot publish artifacts as no version set.\nPlease set the version at the project level.");
        }
    }

    protected void validateURLs(String websiteUrl, String vcsUrl) {
        this.validateURL(websiteUrl, "Website");
        this.validateURL(vcsUrl, "VCS");
    }

    private void validateURL(String url, String description) {
        if (Util.isBlank(url)) {
            throw new IllegalArgumentException(description + " URL not set");
        }
        try {
            URI normalizedURI = new URI(url.toLowerCase());
            String scheme = normalizedURI.getScheme();
            if (!scheme.equals("http") && !scheme.equals("https")) {
                throw new IllegalArgumentException(description + " URL only supports HTTP or HTTPS schemas");
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Can't parse URL '" + url + "'");
        }
    }

    protected void validatePluginIdUniqueness(GradlePluginDevelopmentExtension pluginConfig) {
        HashSet<String> usedPluginIds = new HashSet<String>();
        for (PluginDeclaration plugin : pluginConfig.getPlugins()) {
            String pluginId = plugin.getId();
            if (usedPluginIds.contains(pluginId)) {
                throw new InvalidPluginIdException(pluginId, "multiple plugins are using the same ID");
            }
            usedPluginIds.add(pluginId);
        }
    }

    protected void validatePluginId(String pluginName, String pluginId) {
        if (pluginId == null || pluginId.isEmpty()) {
            throw new IllegalArgumentException("Plugin " + pluginName + " does not define a plugin ID. Please set the 'id' property in the plugin declaration");
        }
        PluginId id = PluginId.of(pluginId);
        if (!id.isQualified()) {
            throw new InvalidPluginIdException(pluginId, "Plugin IDs should be namespaced, e.g. 'com.example." + pluginId + "'");
        }
        if (this.failsNamespaceCheck(pluginId)) {
            throw new InvalidPluginIdException(pluginId, "cannot begin with " + FORBIDDEN_NAMESPACES);
        }
    }

    protected void validateTags(String pluginName, Collection<String> tags) {
        if (tags == null || tags.isEmpty()) {
            throw new IllegalArgumentException("Plugin '" + pluginName + "' has no 'tags' property set");
        }
    }

    protected void validateDisplayName(String pluginName, String displayName) {
        this.validateProperty(pluginName, "displayName", displayName);
    }

    protected void validateDescription(String pluginName, String description) {
        this.validateProperty(pluginName, "description", description);
    }

    protected void validateImplementationClass(String pluginName, String implementationClass) {
        this.validateProperty(pluginName, "implementationClass", implementationClass);
    }

    private void validateProperty(String pluginName, String propertyName, String propertyValue) {
        if (propertyValue == null || Util.isBlank(propertyValue)) {
            throw new IllegalArgumentException("Plugin '" + pluginName + "' has no '" + propertyName + "' property set");
        }
    }

    private boolean failsNamespaceCheck(String id) {
        if (!this.skipNamespaceCheck) {
            id = id.toLowerCase();
            for (String ns : FORBIDDEN_NAMESPACES) {
                if (!id.equals(ns) && !id.startsWith(ns + ".")) continue;
                return true;
            }
        }
        return false;
    }
}

