/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent;

import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.FutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Promise;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PromiseNotificationUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;

public class PromiseNotifier<V, F extends Future<V>>
implements GenericFutureListener<F> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PromiseNotifier.class);
    private final Promise<? super V>[] promises;
    private final boolean logNotifyFailure;

    @SafeVarargs
    public PromiseNotifier(boolean bl2, Promise<? super V> ... promiseArray) {
        ObjectUtil.checkNotNull(promiseArray, "promises");
        for (Promise<? super V> promise : promiseArray) {
            ObjectUtil.checkNotNullWithIAE(promise, "promise");
        }
        this.promises = (Promise[])promiseArray.clone();
        this.logNotifyFailure = bl2;
    }

    public static <V, F extends Future<V>> F cascade(boolean bl2, final F f2, final Promise<? super V> promise) {
        promise.addListener((GenericFutureListener)new FutureListener(){

            public void operationComplete(Future future) {
                if (future.isCancelled()) {
                    f2.cancel(false);
                }
            }
        });
        f2.addListener(new PromiseNotifier(bl2, new Promise[]{promise}){

            @Override
            public void operationComplete(Future future) throws Exception {
                if (promise.isCancelled() && future.isCancelled()) {
                    return;
                }
                super.operationComplete(f2);
            }
        });
        return f2;
    }

    @Override
    public void operationComplete(F f2) throws Exception {
        InternalLogger internalLogger;
        InternalLogger internalLogger2 = internalLogger = this.logNotifyFailure ? logger : null;
        if (f2.isSuccess()) {
            Object v2 = f2.get();
            for (Promise<? super V> promise : this.promises) {
                PromiseNotificationUtil.trySuccess(promise, v2, internalLogger);
            }
        } else if (f2.isCancelled()) {
            for (Promise<? super V> promise : this.promises) {
                PromiseNotificationUtil.tryCancel(promise, internalLogger);
            }
        } else {
            Throwable throwable = f2.cause();
            for (Promise<? super V> promise : this.promises) {
                PromiseNotificationUtil.tryFailure(promise, throwable, internalLogger);
            }
        }
    }
}

