/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx;

import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandshakeHandler;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.List;

public class WebSocketClientProtocolHandler
extends WebSocketProtocolHandler {
    private final WebSocketClientHandshaker handshaker;
    private final WebSocketClientProtocolConfig clientConfig;

    public WebSocketClientProtocolHandler(WebSocketClientProtocolConfig webSocketClientProtocolConfig) {
        super(ObjectUtil.checkNotNull(webSocketClientProtocolConfig, "clientConfig").dropPongFrames(), webSocketClientProtocolConfig.sendCloseFrame(), webSocketClientProtocolConfig.forceCloseTimeoutMillis());
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(webSocketClientProtocolConfig.webSocketUri(), webSocketClientProtocolConfig.version(), webSocketClientProtocolConfig.subprotocol(), webSocketClientProtocolConfig.allowExtensions(), webSocketClientProtocolConfig.customHeaders(), webSocketClientProtocolConfig.maxFramePayloadLength(), webSocketClientProtocolConfig.performMasking(), webSocketClientProtocolConfig.allowMaskMismatch(), webSocketClientProtocolConfig.forceCloseTimeoutMillis(), webSocketClientProtocolConfig.absoluteUpgradeUrl(), webSocketClientProtocolConfig.generateOriginHeader());
        this.clientConfig = webSocketClientProtocolConfig;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) throws Exception {
        if (this.clientConfig.handleCloseFrames() && webSocketFrame instanceof CloseWebSocketFrame) {
            channelHandlerContext.close();
            return;
        }
        super.decode(channelHandlerContext, webSocketFrame, list);
    }

    @Override
    protected WebSocketClientHandshakeException buildHandshakeException(String string) {
        return new WebSocketClientHandshakeException(string);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        if (channelPipeline.get(WebSocketClientProtocolHandshakeHandler.class) == null) {
            channelHandlerContext.pipeline().addBefore(channelHandlerContext.name(), WebSocketClientProtocolHandshakeHandler.class.getName(), new WebSocketClientProtocolHandshakeHandler(this.handshaker, this.clientConfig.handshakeTimeoutMillis()));
        }
        if (this.clientConfig.withUTF8Validator() && channelPipeline.get(Utf8FrameValidator.class) == null) {
            channelHandlerContext.pipeline().addBefore(channelHandlerContext.name(), Utf8FrameValidator.class.getName(), new Utf8FrameValidator());
        }
    }

    public static enum ClientHandshakeStateEvent {
        HANDSHAKE_TIMEOUT,
        HANDSHAKE_ISSUED,
        HANDSHAKE_COMPLETE;

    }
}

