/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.io.build;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.io.build.AbstractSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public abstract class AbstractOrigin<T, B extends AbstractOrigin<T, B>>
extends AbstractSupplier<T, B> {
    final T origin;

    protected AbstractOrigin(T t2) {
        this.origin = Objects.requireNonNull(t2, "origin");
    }

    public T get() {
        return this.origin;
    }

    public InputStream getInputStream(OpenOption ... openOptionArray) throws IOException {
        return Files.newInputStream(this.getPath(), openOptionArray);
    }

    public Path getPath() {
        throw new UnsupportedOperationException(String.format("%s#getPath() for %s origin %s", this.getSimpleClassName(), this.origin.getClass().getSimpleName(), this.origin));
    }

    private String getSimpleClassName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.getSimpleClassName() + "[" + this.origin.toString() + "]";
    }

    public static class InputStreamOrigin
    extends AbstractOrigin<InputStream, InputStreamOrigin> {
        public InputStreamOrigin(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public InputStream getInputStream(OpenOption ... openOptionArray) {
            return (InputStream)this.get();
        }
    }
}

