/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.FactoryBasedEnumDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.CompactStringObjectMap;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

@JacksonStdImpl
public class EnumDeserializer
extends StdScalarDeserializer<Object>
implements ContextualDeserializer {
    protected Object[] _enumsByIndex;
    private final Enum<?> _enumDefaultValue;
    protected final CompactStringObjectMap _lookupByName;
    protected volatile CompactStringObjectMap _lookupByToString;
    protected final Boolean _caseInsensitive;
    private Boolean _useDefaultValueForUnknownEnum;
    private Boolean _useNullForUnknownEnum;
    protected final boolean _isFromIntValue;
    protected final boolean _hasAsValueAnnotation;
    protected final CompactStringObjectMap _lookupByEnumNaming;

    public EnumDeserializer(EnumResolver enumResolver, boolean bl2, EnumResolver enumResolver2, EnumResolver enumResolver3) {
        super(enumResolver.getEnumClass());
        this._lookupByName = enumResolver.constructLookup();
        this._hasAsValueAnnotation = enumResolver.hasAsValueAnnotation();
        this._enumsByIndex = enumResolver.getRawEnums();
        this._enumDefaultValue = enumResolver.getDefaultValue();
        this._caseInsensitive = bl2;
        this._isFromIntValue = enumResolver.isFromIntValue();
        this._lookupByEnumNaming = enumResolver2 == null ? null : enumResolver2.constructLookup();
        this._lookupByToString = enumResolver3 == null ? null : enumResolver3.constructLookup();
    }

    protected EnumDeserializer(EnumDeserializer enumDeserializer, Boolean bl2, Boolean bl3, Boolean bl4) {
        super(enumDeserializer);
        this._lookupByName = enumDeserializer._lookupByName;
        this._hasAsValueAnnotation = enumDeserializer._hasAsValueAnnotation;
        this._enumsByIndex = enumDeserializer._enumsByIndex;
        this._enumDefaultValue = enumDeserializer._enumDefaultValue;
        this._caseInsensitive = Boolean.TRUE.equals(bl2);
        this._isFromIntValue = enumDeserializer._isFromIntValue;
        this._useDefaultValueForUnknownEnum = bl3;
        this._useNullForUnknownEnum = bl4;
        this._lookupByEnumNaming = enumDeserializer._lookupByEnumNaming;
        this._lookupByToString = enumDeserializer._lookupByToString;
    }

    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray, EnumResolver enumResolver) {
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new FactoryBasedEnumDeserializer(clazz, annotatedMethod, annotatedMethod.getParameterType(0), valueInstantiator, settableBeanPropertyArray, enumResolver);
    }

    public static JsonDeserializer<?> deserializerForNoArgsCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod) {
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new FactoryBasedEnumDeserializer(clazz, annotatedMethod);
    }

    public EnumDeserializer withResolved(Boolean bl2, Boolean bl3, Boolean bl4) {
        if (Objects.equals(this._caseInsensitive, bl2) && Objects.equals(this._useDefaultValueForUnknownEnum, bl3) && Objects.equals(this._useNullForUnknownEnum, bl4)) {
            return this;
        }
        return new EnumDeserializer(this, bl2, bl3, bl4);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        Boolean bl2 = Optional.ofNullable(this.findFormatFeature(deserializationContext, beanProperty, this.handledType(), JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)).orElse(this._caseInsensitive);
        Boolean bl3 = Optional.ofNullable(this.findFormatFeature(deserializationContext, beanProperty, this.handledType(), JsonFormat.Feature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)).orElse(this._useDefaultValueForUnknownEnum);
        Boolean bl4 = Optional.ofNullable(this.findFormatFeature(deserializationContext, beanProperty, this.handledType(), JsonFormat.Feature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)).orElse(this._useNullForUnknownEnum);
        return this.withResolved(bl2, bl3, bl4);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Enum;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
        return this._enumDefaultValue;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            if (this._isFromIntValue) {
                return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
            }
            return this._fromInteger(jsonParser, deserializationContext, jsonParser.getIntValue());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            String string = deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
            if (string == null) {
                return deserializationContext.handleUnexpectedToken(this._enumClass(), jsonParser);
            }
            return this._fromString(jsonParser, deserializationContext, string);
        }
        return this._deserializeOther(jsonParser, deserializationContext);
    }

    protected Object _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2;
        CompactStringObjectMap compactStringObjectMap = this._resolveCurrentLookup(deserializationContext);
        Object object = compactStringObjectMap.find(string);
        if (object == null && ((string2 = string.trim()) == string || (object = compactStringObjectMap.find(string2)) == null)) {
            return this._deserializeAltString(jsonParser, deserializationContext, compactStringObjectMap, string2);
        }
        return object;
    }

    private CompactStringObjectMap _resolveCurrentLookup(DeserializationContext deserializationContext) {
        if (this._lookupByEnumNaming != null) {
            return this._lookupByEnumNaming;
        }
        if (this._hasAsValueAnnotation || !deserializationContext.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING)) {
            return this._lookupByName;
        }
        return this._getToStringLookup(deserializationContext);
    }

    protected Object _fromInteger(JsonParser jsonParser, DeserializationContext deserializationContext, int n2) throws IOException {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(this.logicalType(), this.handledType(), CoercionInputShape.Integer);
        if (coercionAction == CoercionAction.Fail) {
            if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) {
                return deserializationContext.handleWeirdNumberValue(this._enumClass(), n2, "not allowed to deserialize Enum value out of number: disable DeserializationConfig.DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS to allow", new Object[0]);
            }
            this._checkCoercionFail(deserializationContext, coercionAction, this.handledType(), n2, "Integer value (" + n2 + ")");
        }
        switch (coercionAction) {
            case AsNull: {
                return null;
            }
            case AsEmpty: {
                return this.getEmptyValue(deserializationContext);
            }
        }
        if (n2 >= 0 && n2 < this._enumsByIndex.length) {
            return this._enumsByIndex[n2];
        }
        if (this.useDefaultValueForUnknownEnum(deserializationContext)) {
            return this._enumDefaultValue;
        }
        if (!this.useNullForUnknownEnum(deserializationContext)) {
            return deserializationContext.handleWeirdNumberValue(this._enumClass(), n2, "index value outside legal index range [0..%s]", this._enumsByIndex.length - 1);
        }
        return null;
    }

    private final Object _deserializeAltString(JsonParser jsonParser, DeserializationContext deserializationContext, CompactStringObjectMap compactStringObjectMap, String string) throws IOException {
        char c2;
        Object object;
        String string2 = string.trim();
        if (string2.isEmpty()) {
            CoercionAction coercionAction;
            if (this.useDefaultValueForUnknownEnum(deserializationContext)) {
                return this._enumDefaultValue;
            }
            if (this.useNullForUnknownEnum(deserializationContext)) {
                return null;
            }
            if (string.isEmpty()) {
                coercionAction = this._findCoercionFromEmptyString(deserializationContext);
                coercionAction = this._checkCoercionFail(deserializationContext, coercionAction, this.handledType(), string, "empty String (\"\")");
            } else {
                coercionAction = this._findCoercionFromBlankString(deserializationContext);
                coercionAction = this._checkCoercionFail(deserializationContext, coercionAction, this.handledType(), string, "blank String (all whitespace)");
            }
            switch (coercionAction) {
                case AsEmpty: 
                case TryConvert: {
                    return this.getEmptyValue(deserializationContext);
                }
            }
            return null;
        }
        if (Boolean.TRUE.equals(this._caseInsensitive) && (object = compactStringObjectMap.findCaseInsensitive(string2)) != null) {
            return object;
        }
        if (!(deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS) || this._isFromIntValue || (c2 = string2.charAt(0)) < '0' || c2 > '9' || c2 == '0' && string2.length() > 1)) {
            try {
                int n2 = Integer.parseInt(string2);
                if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
                    return deserializationContext.handleWeirdStringValue(this._enumClass(), string2, "value looks like quoted Enum index, but `MapperFeature.ALLOW_COERCION_OF_SCALARS` prevents use", new Object[0]);
                }
                if (n2 >= 0 && n2 < this._enumsByIndex.length) {
                    return this._enumsByIndex[n2];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.useDefaultValueForUnknownEnum(deserializationContext)) {
            return this._enumDefaultValue;
        }
        if (this.useNullForUnknownEnum(deserializationContext)) {
            return null;
        }
        return deserializationContext.handleWeirdStringValue(this._enumClass(), string2, "not one of the values accepted for Enum class: %s", compactStringObjectMap.keys());
    }

    protected Object _deserializeOther(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.START_ARRAY)) {
            return this._deserializeFromArray(jsonParser, deserializationContext);
        }
        return deserializationContext.handleUnexpectedToken(this._enumClass(), jsonParser);
    }

    protected Class<?> _enumClass() {
        return this.handledType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected CompactStringObjectMap _getToStringLookup(DeserializationContext deserializationContext) {
        CompactStringObjectMap compactStringObjectMap = this._lookupByToString;
        if (compactStringObjectMap == null) {
            EnumDeserializer enumDeserializer = this;
            synchronized (enumDeserializer) {
                compactStringObjectMap = this._lookupByToString;
                if (compactStringObjectMap == null) {
                    DeserializationConfig deserializationConfig = deserializationContext.getConfig();
                    AnnotatedClass annotatedClass = deserializationConfig.introspectClassAnnotations(this._enumClass()).getClassInfo();
                    this._lookupByToString = EnumResolver.constructUsingToString(deserializationConfig, annotatedClass).constructLookup();
                }
            }
        }
        return compactStringObjectMap;
    }

    protected boolean useNullForUnknownEnum(DeserializationContext deserializationContext) {
        if (this._useNullForUnknownEnum != null) {
            return this._useNullForUnknownEnum;
        }
        return deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
    }

    protected boolean useDefaultValueForUnknownEnum(DeserializationContext deserializationContext) {
        if (this._enumDefaultValue != null) {
            if (this._useDefaultValueForUnknownEnum != null) {
                return this._useDefaultValueForUnknownEnum;
            }
            return deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        }
        return false;
    }
}

