/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.impl;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.JsonLocationInstantiator;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JDKValueInstantiators {
    public static ValueInstantiator findStdValueInstantiator(DeserializationConfig deserializationConfig, Class<?> clazz) {
        if (clazz == JsonLocation.class) {
            return new JsonLocationInstantiator();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (clazz == ArrayList.class) {
                return ArrayListInstantiator.INSTANCE;
            }
            if (clazz == HashSet.class) {
                return HashSetInstantiator.INSTANCE;
            }
            if (clazz == LinkedList.class) {
                return new LinkedListInstantiator();
            }
            if (clazz == TreeSet.class) {
                return new TreeSetInstantiator();
            }
            if (clazz == LinkedHashSet.class) {
                return new LinkedHashSetInstantiator();
            }
            if (clazz == Collections.emptySet().getClass()) {
                return new ConstantValueInstantiator(Collections.emptySet());
            }
            if (clazz == Collections.emptyList().getClass()) {
                return new ConstantValueInstantiator(Collections.emptyList());
            }
        } else if (Map.class.isAssignableFrom(clazz)) {
            if (clazz == LinkedHashMap.class) {
                return LinkedHashMapInstantiator.INSTANCE;
            }
            if (clazz == HashMap.class) {
                return HashMapInstantiator.INSTANCE;
            }
            if (clazz == ConcurrentHashMap.class) {
                return new ConcurrentHashMapInstantiator();
            }
            if (clazz == TreeMap.class) {
                return new TreeMapInstantiator();
            }
            if (Properties.class.isAssignableFrom(clazz)) {
                return new PropertiesInstantiator();
            }
            if (clazz == Collections.emptyMap().getClass()) {
                return new ConstantValueInstantiator(Collections.emptyMap());
            }
        }
        return null;
    }

    private static class ConstantValueInstantiator
    extends JDKValueInstantiator {
        protected final Object _value;

        public ConstantValueInstantiator(Object object) {
            super(object.getClass());
            this._value = object;
        }

        @Override
        public final Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
            return this._value;
        }
    }

    private static class PropertiesInstantiator
    extends JDKValueInstantiator {
        public PropertiesInstantiator() {
            super(Properties.class);
        }

        @Override
        public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
            return new Properties();
        }
    }

    private static class TreeMapInstantiator
    extends JDKValueInstantiator {
        public TreeMapInstantiator() {
            super(TreeMap.class);
        }

        @Override
        public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
            return new TreeMap();
        }
    }

    private static class LinkedHashMapInstantiator
    extends JDKValueInstantiator {
        static final LinkedHashMapInstantiator INSTANCE = new LinkedHashMapInstantiator();

        public LinkedHashMapInstantiator() {
            super(LinkedHashMap.class);
        }

        @Override
        public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
            return new LinkedHashMap();
        }
    }

    private static class HashMapInstantiator
    extends JDKValueInstantiator {
        static final HashMapInstantiator INSTANCE = new HashMapInstantiator();

        public HashMapInstantiator() {
            super(HashMap.class);
        }

        @Override
        public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
            return new HashMap();
        }
    }

    private static class ConcurrentHashMapInstantiator
    extends JDKValueInstantiator {
        public ConcurrentHashMapInstantiator() {
            super(ConcurrentHashMap.class);
        }

        @Override
        public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
            return new ConcurrentHashMap();
        }
    }

    private static class LinkedHashSetInstantiator
    extends JDKValueInstantiator {
        public LinkedHashSetInstantiator() {
            super(LinkedHashSet.class);
        }

        @Override
        public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
            return new LinkedHashSet();
        }
    }

    private static class TreeSetInstantiator
    extends JDKValueInstantiator {
        public TreeSetInstantiator() {
            super(TreeSet.class);
        }

        @Override
        public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
            return new TreeSet();
        }
    }

    private static class HashSetInstantiator
    extends JDKValueInstantiator {
        static final HashSetInstantiator INSTANCE = new HashSetInstantiator();

        public HashSetInstantiator() {
            super(HashSet.class);
        }

        @Override
        public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
            return new HashSet();
        }
    }

    private static class LinkedListInstantiator
    extends JDKValueInstantiator {
        public LinkedListInstantiator() {
            super(LinkedList.class);
        }

        @Override
        public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
            return new LinkedList();
        }
    }

    private static class ArrayListInstantiator
    extends JDKValueInstantiator {
        static final ArrayListInstantiator INSTANCE = new ArrayListInstantiator();

        public ArrayListInstantiator() {
            super(ArrayList.class);
        }

        @Override
        public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
            return new ArrayList();
        }
    }

    private static abstract class JDKValueInstantiator
    extends ValueInstantiator.Base
    implements Serializable {
        public JDKValueInstantiator(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public final boolean canInstantiate() {
            return true;
        }

        @Override
        public final boolean canCreateUsingDefault() {
            return true;
        }
    }
}

