package com.gradle.develocity.agent.gradle.scan;

import com.gradle.obfuscation.Keep;

import java.net.URI;

/**
 * A reference to a published build scan.
 *
 * @since 3.17
 */
@Keep
public interface PublishedBuildScan {

    /**
     * The ID of the build scan.
     * <p>
     * Example: "bzoxfqz2pcmk4".
     *
     * @return the ID of the build scan
     */
    String getBuildScanId();

    /**
     * The complete address of the build scan.
     * <p>
     * Example: "https://my-server/s/bzoxfqz2pcmk4".
     *
     * @return the complete address of the build scan.
     */
    URI getBuildScanUri();

}
