/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.util;

import gradlegitproperties.org.eclipse.jgit.internal.JGitText;
import gradlegitproperties.org.eclipse.jgit.lib.GpgSignatureVerifier;
import gradlegitproperties.org.eclipse.jgit.lib.PersonIdent;
import gradlegitproperties.org.eclipse.jgit.util.GitDateFormatter;
import gradlegitproperties.org.eclipse.jgit.util.StringUtils;
import java.text.MessageFormat;
import java.util.Locale;

public final class SignatureUtils {
    private SignatureUtils() {
    }

    public static String toString(GpgSignatureVerifier.SignatureVerification verification, PersonIdent creator, GitDateFormatter formatter) {
        StringBuilder result = new StringBuilder();
        PersonIdent dateId = new PersonIdent(creator, verification.getCreationDate());
        result.append(MessageFormat.format(JGitText.get().verifySignatureMade, formatter.formatDate(dateId)));
        result.append('\n');
        result.append(MessageFormat.format(JGitText.get().verifySignatureKey, verification.getKeyFingerprint().toUpperCase(Locale.ROOT)));
        result.append('\n');
        if (!StringUtils.isEmptyOrNull(verification.getSigner())) {
            result.append(MessageFormat.format(JGitText.get().verifySignatureIssuer, verification.getSigner()));
            result.append('\n');
        }
        String msg = verification.getVerified() ? (verification.isExpired() ? JGitText.get().verifySignatureExpired : JGitText.get().verifySignatureGood) : JGitText.get().verifySignatureBad;
        result.append(MessageFormat.format(msg, verification.getKeyUser()));
        if (!GpgSignatureVerifier.TrustLevel.UNKNOWN.equals((Object)verification.getTrustLevel())) {
            result.append(String.valueOf(' ') + MessageFormat.format(JGitText.get().verifySignatureTrust, verification.getTrustLevel().name().toLowerCase(Locale.ROOT)));
        }
        result.append('\n');
        msg = verification.getMessage();
        if (!StringUtils.isEmptyOrNull(msg)) {
            result.append(msg);
            result.append('\n');
        }
        return result.toString();
    }
}

