/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import com.google.testing.junit.testparameterinjector.ParameterValueParsing;
import com.google.testing.junit.testparameterinjector.TestParameterAnnotation;
import com.google.testing.junit.testparameterinjector.TestParameterValue;
import com.google.testing.junit.testparameterinjector.TestParameterValueProvider;
import com.google.testing.junit.testparameterinjector.TestParameterValuesProvider;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.PARAMETER})
@TestParameterAnnotation(valueProvider=InternalImplementationOfThisParameter.class)
public @interface TestParameter {
    public String[] value() default {};

    public Class<? extends TestParameterValuesProvider> valuesProvider() default DefaultTestParameterValuesProvider.class;

    public static final class InternalImplementationOfThisParameter
    implements TestParameterValueProvider {
        @Override
        public List<Object> provideValues(Annotation uncastAnnotation, ImmutableList<Annotation> otherAnnotations, Optional<Class<?>> maybeParameterClass, Class<?> testClass) {
            TestParameter annotation = (TestParameter)uncastAnnotation;
            Class<?> parameterClass = this.getValueType(annotation.annotationType(), maybeParameterClass);
            boolean valueIsSet = annotation.value().length > 0;
            boolean valuesProviderIsSet = !annotation.valuesProvider().equals(DefaultTestParameterValuesProvider.class);
            Preconditions.checkState((!valueIsSet || !valuesProviderIsSet ? 1 : 0) != 0, (String)"It is not allowed to specify both value and valuesProvider on annotation %s", (Object)annotation);
            if (valueIsSet) {
                return Lists.newArrayList((Object[])FluentIterable.from((Object[])annotation.value()).transform(v -> InternalImplementationOfThisParameter.parseStringValue(v, parameterClass)).toArray(Object.class));
            }
            if (valuesProviderIsSet) {
                return InternalImplementationOfThisParameter.getValuesFromProvider(annotation.valuesProvider(), new TestParameterValuesProvider.Context(otherAnnotations, testClass));
            }
            if (Enum.class.isAssignableFrom(parameterClass)) {
                return Arrays.asList(parameterClass.asSubclass(Enum.class).getEnumConstants());
            }
            if (Primitives.wrap(parameterClass).equals(Boolean.class)) {
                return Arrays.asList(false, true);
            }
            throw new IllegalStateException(String.format("A @TestParameter without values can only be placed at an enum or a boolean, but was placed by a %s", parameterClass));
        }

        @Override
        public Class<?> getValueType(Class<? extends Annotation> annotationType, Optional<Class<?>> parameterClass) {
            if (parameterClass.isPresent()) {
                return (Class)parameterClass.get();
            }
            throw new AssertionError((Object)String.format("An empty parameter class should not be possible since @TestParameter can only target FIELD or PARAMETER, both of which are supported for annotation %s.", annotationType));
        }

        private static Object parseStringValue(String value, Class<?> parameterClass) {
            if (parameterClass.equals(String.class)) {
                return value.equals("null") ? null : value;
            }
            if (Enum.class.isAssignableFrom(parameterClass)) {
                return value.equals("null") ? null : ParameterValueParsing.parseEnum(value, parameterClass);
            }
            return ParameterValueParsing.parseYamlStringToJavaType(value, parameterClass);
        }

        private static List<Object> getValuesFromProvider(Class<? extends TestParameterValuesProvider> valuesProvider, TestParameterValuesProvider.Context context) {
            try {
                Constructor<? extends TestParameterValuesProvider> constructor = valuesProvider.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                TestParameterValuesProvider instance = constructor.newInstance(new Object[0]);
                if (instance instanceof com.google.testing.junit.testparameterinjector.TestParameterValuesProvider) {
                    return new ArrayList<Object>(((com.google.testing.junit.testparameterinjector.TestParameterValuesProvider)instance).provideValues(context));
                }
                return new ArrayList<Object>(instance.provideValues());
            }
            catch (NoSuchMethodException e) {
                if (!Modifier.isStatic(valuesProvider.getModifiers()) && valuesProvider.isMemberClass()) {
                    throw new IllegalStateException(String.format("Could not find a no-arg constructor for %s, probably because it is a not-static inner class. You can fix this by making %s static.", valuesProvider.getSimpleName(), valuesProvider.getSimpleName()), e);
                }
                throw new IllegalStateException(String.format("Could not find a no-arg constructor for %s.", valuesProvider.getSimpleName()), e);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException(e);
            }
        }
    }

    public static class DefaultTestParameterValuesProvider
    implements TestParameterValuesProvider {
        public List<Object> provideValues() {
            return ImmutableList.of();
        }
    }

    public static interface TestParameterValuesProvider {
        public List<?> provideValues();

        default public TestParameterValue value(@Nullable Object wrappedValue) {
            return TestParameterValue.wrap(wrappedValue);
        }
    }
}

