/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.newtypes.PersistentSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NaivePersistentSet<K>
extends PersistentSet<K> {
    private final Set<K> set;

    private NaivePersistentSet(Set<K> s) {
        this.set = s;
    }

    public static <K> PersistentSet<K> create() {
        return new NaivePersistentSet<K>(Sets.newHashSet());
    }

    @Override
    public PersistentSet<K> with(K key) {
        HashSet newSet = Sets.newHashSet(this.set);
        newSet.add(key);
        return new NaivePersistentSet<K>(newSet);
    }

    @Override
    public PersistentSet<K> without(K key) {
        HashSet newSet = Sets.newHashSet(this.set);
        newSet.remove(key);
        return new NaivePersistentSet<K>(newSet);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Iterator<K> iterator() {
        return this.set.iterator();
    }
}

