/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import java.util.Arrays;
import java.util.logging.Logger;

public class InternalFlags {
    private static final Logger logger = Logger.getLogger(InternalFlags.class.getName());

    public static IncludeStackTraceOption getIncludeStackTraceOption() {
        String flag = System.getProperty("guice_include_stack_traces");
        try {
            return flag == null || flag.length() == 0 ? IncludeStackTraceOption.ONLY_FOR_DECLARING_SOURCE : IncludeStackTraceOption.valueOf(flag);
        }
        catch (IllegalArgumentException e) {
            String string = String.valueOf(String.valueOf(flag));
            String string2 = String.valueOf(String.valueOf(Arrays.asList(IncludeStackTraceOption.values())));
            logger.warning(new StringBuilder(82 + string.length() + string2.length()).append(string).append(" is not a valid flag value for guice_include_stack_traces. ").append(" Values must be one of ").append(string2).toString());
            return IncludeStackTraceOption.ONLY_FOR_DECLARING_SOURCE;
        }
    }

    public static enum IncludeStackTraceOption {
        OFF,
        ONLY_FOR_DECLARING_SOURCE,
        COMPLETE;

    }
}

