/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import dagger.internal.codegen.AutoValue_MultibindingDeclaration;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.SetType;
import dagger.model.Key;
import dagger.multibindings.Multibinds;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

@AutoValue
abstract class MultibindingDeclaration
extends BindingDeclaration
implements ContributionType.HasContributionType {
    MultibindingDeclaration() {
    }

    @Override
    public abstract Key key();

    @Override
    public abstract ContributionType contributionType();

    static final class Factory {
        private final Types types;
        private final KeyFactory keyFactory;

        @Inject
        Factory(Types types, KeyFactory keyFactory) {
            this.types = types;
            this.keyFactory = keyFactory;
        }

        MultibindingDeclaration forMultibindsMethod(ExecutableElement moduleMethod, TypeElement moduleElement) {
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(moduleMethod, Multibinds.class));
            return this.forDeclaredMethod(moduleMethod, MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(moduleElement.asType()), moduleMethod)), moduleElement);
        }

        private MultibindingDeclaration forDeclaredMethod(ExecutableElement method, ExecutableType methodType, TypeElement contributingType) {
            TypeMirror returnType = methodType.getReturnType();
            Preconditions.checkArgument((SetType.isSet(returnType) || MapType.isMap(returnType) ? 1 : 0) != 0, (String)"%s must return a set or map", (Object)method);
            return new AutoValue_MultibindingDeclaration(Optional.of(method), Optional.of(contributingType), this.keyFactory.forMultibindsMethod(methodType, method), this.contributionType(returnType));
        }

        private ContributionType contributionType(TypeMirror returnType) {
            if (MapType.isMap(returnType)) {
                return ContributionType.MAP;
            }
            if (SetType.isSet(returnType)) {
                return ContributionType.SET;
            }
            throw new IllegalArgumentException("Must be Map or Set: " + returnType);
        }
    }
}

