/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.http.ResponseException;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.registry.AbstractManifestPuller;
import com.google.cloud.tools.jib.registry.ErrorCodes;
import com.google.cloud.tools.jib.registry.ErrorResponseUtil;
import com.google.cloud.tools.jib.registry.ManifestAndDigest;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import java.util.Optional;

class ManifestChecker<T extends ManifestTemplate>
extends AbstractManifestPuller<T, Optional<ManifestAndDigest<T>>> {
    ManifestChecker(RegistryEndpointRequestProperties registryEndpointRequestProperties, String imageQualifier, Class<T> manifestTemplateClass) {
        super(registryEndpointRequestProperties, imageQualifier, manifestTemplateClass);
    }

    @Override
    public Optional<ManifestAndDigest<T>> handleHttpResponseException(ResponseException responseException) throws ResponseException {
        if (responseException.getStatusCode() != 404) {
            throw responseException;
        }
        if (responseException.getContent() == null) {
            return Optional.empty();
        }
        ErrorCodes errorCode = ErrorResponseUtil.getErrorCode(responseException);
        if (errorCode == ErrorCodes.MANIFEST_UNKNOWN) {
            return Optional.empty();
        }
        throw responseException;
    }

    @Override
    Optional<ManifestAndDigest<T>> computeReturn(ManifestAndDigest<T> manifestAndDigest) {
        return Optional.of(manifestAndDigest);
    }
}

