/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.api;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vertexai.api.CreateEndpointOperationMetadata;
import com.google.cloud.vertexai.api.CreateEndpointRequest;
import com.google.cloud.vertexai.api.DeleteEndpointRequest;
import com.google.cloud.vertexai.api.DeleteOperationMetadata;
import com.google.cloud.vertexai.api.DeployModelOperationMetadata;
import com.google.cloud.vertexai.api.DeployModelRequest;
import com.google.cloud.vertexai.api.DeployModelResponse;
import com.google.cloud.vertexai.api.DeployedModel;
import com.google.cloud.vertexai.api.Endpoint;
import com.google.cloud.vertexai.api.EndpointName;
import com.google.cloud.vertexai.api.EndpointServiceSettings;
import com.google.cloud.vertexai.api.GetEndpointRequest;
import com.google.cloud.vertexai.api.ListEndpointsRequest;
import com.google.cloud.vertexai.api.ListEndpointsResponse;
import com.google.cloud.vertexai.api.LocationName;
import com.google.cloud.vertexai.api.MutateDeployedModelOperationMetadata;
import com.google.cloud.vertexai.api.MutateDeployedModelRequest;
import com.google.cloud.vertexai.api.MutateDeployedModelResponse;
import com.google.cloud.vertexai.api.UndeployModelOperationMetadata;
import com.google.cloud.vertexai.api.UndeployModelRequest;
import com.google.cloud.vertexai.api.UndeployModelResponse;
import com.google.cloud.vertexai.api.UpdateEndpointRequest;
import com.google.cloud.vertexai.api.stub.EndpointServiceStub;
import com.google.cloud.vertexai.api.stub.EndpointServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EndpointServiceClient
implements BackgroundResource {
    private final EndpointServiceSettings settings;
    private final EndpointServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final EndpointServiceClient create() throws IOException {
        return EndpointServiceClient.create(EndpointServiceSettings.newBuilder().build());
    }

    public static final EndpointServiceClient create(EndpointServiceSettings settings) throws IOException {
        return new EndpointServiceClient(settings);
    }

    public static final EndpointServiceClient create(EndpointServiceStub stub) {
        return new EndpointServiceClient(stub);
    }

    protected EndpointServiceClient(EndpointServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EndpointServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected EndpointServiceClient(EndpointServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final EndpointServiceSettings getSettings() {
        return this.settings;
    }

    public EndpointServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Endpoint, CreateEndpointOperationMetadata> createEndpointAsync(LocationName parent, Endpoint endpoint) {
        CreateEndpointRequest request = CreateEndpointRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEndpoint(endpoint).build();
        return this.createEndpointAsync(request);
    }

    public final OperationFuture<Endpoint, CreateEndpointOperationMetadata> createEndpointAsync(String parent, Endpoint endpoint) {
        CreateEndpointRequest request = CreateEndpointRequest.newBuilder().setParent(parent).setEndpoint(endpoint).build();
        return this.createEndpointAsync(request);
    }

    public final OperationFuture<Endpoint, CreateEndpointOperationMetadata> createEndpointAsync(LocationName parent, Endpoint endpoint, String endpointId) {
        CreateEndpointRequest request = CreateEndpointRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEndpoint(endpoint).setEndpointId(endpointId).build();
        return this.createEndpointAsync(request);
    }

    public final OperationFuture<Endpoint, CreateEndpointOperationMetadata> createEndpointAsync(String parent, Endpoint endpoint, String endpointId) {
        CreateEndpointRequest request = CreateEndpointRequest.newBuilder().setParent(parent).setEndpoint(endpoint).setEndpointId(endpointId).build();
        return this.createEndpointAsync(request);
    }

    public final OperationFuture<Endpoint, CreateEndpointOperationMetadata> createEndpointAsync(CreateEndpointRequest request) {
        return this.createEndpointOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEndpointRequest, Endpoint, CreateEndpointOperationMetadata> createEndpointOperationCallable() {
        return this.stub.createEndpointOperationCallable();
    }

    public final UnaryCallable<CreateEndpointRequest, Operation> createEndpointCallable() {
        return this.stub.createEndpointCallable();
    }

    public final Endpoint getEndpoint(EndpointName name) {
        GetEndpointRequest request = GetEndpointRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEndpoint(request);
    }

    public final Endpoint getEndpoint(String name) {
        GetEndpointRequest request = GetEndpointRequest.newBuilder().setName(name).build();
        return this.getEndpoint(request);
    }

    public final Endpoint getEndpoint(GetEndpointRequest request) {
        return (Endpoint)this.getEndpointCallable().call((Object)request);
    }

    public final UnaryCallable<GetEndpointRequest, Endpoint> getEndpointCallable() {
        return this.stub.getEndpointCallable();
    }

    public final ListEndpointsPagedResponse listEndpoints(LocationName parent) {
        ListEndpointsRequest request = ListEndpointsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEndpoints(request);
    }

    public final ListEndpointsPagedResponse listEndpoints(String parent) {
        ListEndpointsRequest request = ListEndpointsRequest.newBuilder().setParent(parent).build();
        return this.listEndpoints(request);
    }

    public final ListEndpointsPagedResponse listEndpoints(ListEndpointsRequest request) {
        return (ListEndpointsPagedResponse)((Object)this.listEndpointsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEndpointsRequest, ListEndpointsPagedResponse> listEndpointsPagedCallable() {
        return this.stub.listEndpointsPagedCallable();
    }

    public final UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> listEndpointsCallable() {
        return this.stub.listEndpointsCallable();
    }

    public final Endpoint updateEndpoint(Endpoint endpoint, FieldMask updateMask) {
        UpdateEndpointRequest request = UpdateEndpointRequest.newBuilder().setEndpoint(endpoint).setUpdateMask(updateMask).build();
        return this.updateEndpoint(request);
    }

    public final Endpoint updateEndpoint(UpdateEndpointRequest request) {
        return (Endpoint)this.updateEndpointCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEndpointRequest, Endpoint> updateEndpointCallable() {
        return this.stub.updateEndpointCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteEndpointAsync(EndpointName name) {
        DeleteEndpointRequest request = DeleteEndpointRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEndpointAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteEndpointAsync(String name) {
        DeleteEndpointRequest request = DeleteEndpointRequest.newBuilder().setName(name).build();
        return this.deleteEndpointAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteEndpointAsync(DeleteEndpointRequest request) {
        return this.deleteEndpointOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEndpointRequest, Empty, DeleteOperationMetadata> deleteEndpointOperationCallable() {
        return this.stub.deleteEndpointOperationCallable();
    }

    public final UnaryCallable<DeleteEndpointRequest, Operation> deleteEndpointCallable() {
        return this.stub.deleteEndpointCallable();
    }

    public final OperationFuture<DeployModelResponse, DeployModelOperationMetadata> deployModelAsync(EndpointName endpoint, DeployedModel deployedModel, Map<String, Integer> trafficSplit) {
        DeployModelRequest request = DeployModelRequest.newBuilder().setEndpoint(endpoint == null ? null : endpoint.toString()).setDeployedModel(deployedModel).putAllTrafficSplit(trafficSplit).build();
        return this.deployModelAsync(request);
    }

    public final OperationFuture<DeployModelResponse, DeployModelOperationMetadata> deployModelAsync(String endpoint, DeployedModel deployedModel, Map<String, Integer> trafficSplit) {
        DeployModelRequest request = DeployModelRequest.newBuilder().setEndpoint(endpoint).setDeployedModel(deployedModel).putAllTrafficSplit(trafficSplit).build();
        return this.deployModelAsync(request);
    }

    public final OperationFuture<DeployModelResponse, DeployModelOperationMetadata> deployModelAsync(DeployModelRequest request) {
        return this.deployModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeployModelRequest, DeployModelResponse, DeployModelOperationMetadata> deployModelOperationCallable() {
        return this.stub.deployModelOperationCallable();
    }

    public final UnaryCallable<DeployModelRequest, Operation> deployModelCallable() {
        return this.stub.deployModelCallable();
    }

    public final OperationFuture<UndeployModelResponse, UndeployModelOperationMetadata> undeployModelAsync(EndpointName endpoint, String deployedModelId, Map<String, Integer> trafficSplit) {
        UndeployModelRequest request = UndeployModelRequest.newBuilder().setEndpoint(endpoint == null ? null : endpoint.toString()).setDeployedModelId(deployedModelId).putAllTrafficSplit(trafficSplit).build();
        return this.undeployModelAsync(request);
    }

    public final OperationFuture<UndeployModelResponse, UndeployModelOperationMetadata> undeployModelAsync(String endpoint, String deployedModelId, Map<String, Integer> trafficSplit) {
        UndeployModelRequest request = UndeployModelRequest.newBuilder().setEndpoint(endpoint).setDeployedModelId(deployedModelId).putAllTrafficSplit(trafficSplit).build();
        return this.undeployModelAsync(request);
    }

    public final OperationFuture<UndeployModelResponse, UndeployModelOperationMetadata> undeployModelAsync(UndeployModelRequest request) {
        return this.undeployModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeployModelRequest, UndeployModelResponse, UndeployModelOperationMetadata> undeployModelOperationCallable() {
        return this.stub.undeployModelOperationCallable();
    }

    public final UnaryCallable<UndeployModelRequest, Operation> undeployModelCallable() {
        return this.stub.undeployModelCallable();
    }

    public final OperationFuture<MutateDeployedModelResponse, MutateDeployedModelOperationMetadata> mutateDeployedModelAsync(EndpointName endpoint, DeployedModel deployedModel, FieldMask updateMask) {
        MutateDeployedModelRequest request = MutateDeployedModelRequest.newBuilder().setEndpoint(endpoint == null ? null : endpoint.toString()).setDeployedModel(deployedModel).setUpdateMask(updateMask).build();
        return this.mutateDeployedModelAsync(request);
    }

    public final OperationFuture<MutateDeployedModelResponse, MutateDeployedModelOperationMetadata> mutateDeployedModelAsync(String endpoint, DeployedModel deployedModel, FieldMask updateMask) {
        MutateDeployedModelRequest request = MutateDeployedModelRequest.newBuilder().setEndpoint(endpoint).setDeployedModel(deployedModel).setUpdateMask(updateMask).build();
        return this.mutateDeployedModelAsync(request);
    }

    public final OperationFuture<MutateDeployedModelResponse, MutateDeployedModelOperationMetadata> mutateDeployedModelAsync(MutateDeployedModelRequest request) {
        return this.mutateDeployedModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<MutateDeployedModelRequest, MutateDeployedModelResponse, MutateDeployedModelOperationMetadata> mutateDeployedModelOperationCallable() {
        return this.stub.mutateDeployedModelOperationCallable();
    }

    public final UnaryCallable<MutateDeployedModelRequest, Operation> mutateDeployedModelCallable() {
        return this.stub.mutateDeployedModelCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEndpointsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEndpointsRequest, ListEndpointsResponse, Endpoint, ListEndpointsPage, ListEndpointsFixedSizeCollection> {
        private ListEndpointsFixedSizeCollection(List<ListEndpointsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEndpointsFixedSizeCollection createEmptyCollection() {
            return new ListEndpointsFixedSizeCollection(null, 0);
        }

        protected ListEndpointsFixedSizeCollection createCollection(List<ListEndpointsPage> pages, int collectionSize) {
            return new ListEndpointsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEndpointsPage
    extends AbstractPage<ListEndpointsRequest, ListEndpointsResponse, Endpoint, ListEndpointsPage> {
        private ListEndpointsPage(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ListEndpointsResponse response) {
            super(context, (Object)response);
        }

        private static ListEndpointsPage createEmptyPage() {
            return new ListEndpointsPage(null, null);
        }

        protected ListEndpointsPage createPage(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ListEndpointsResponse response) {
            return new ListEndpointsPage(context, response);
        }

        public ApiFuture<ListEndpointsPage> createPageAsync(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ApiFuture<ListEndpointsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEndpointsPagedResponse
    extends AbstractPagedListResponse<ListEndpointsRequest, ListEndpointsResponse, Endpoint, ListEndpointsPage, ListEndpointsFixedSizeCollection> {
        public static ApiFuture<ListEndpointsPagedResponse> createAsync(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ApiFuture<ListEndpointsResponse> futureResponse) {
            ApiFuture<ListEndpointsPage> futurePage = ListEndpointsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEndpointsPagedResponse((ListEndpointsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEndpointsPagedResponse(ListEndpointsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEndpointsFixedSizeCollection.createEmptyCollection());
        }
    }
}

