/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.generativeai;

import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.FunctionCall;
import com.google.cloud.vertexai.api.Part;
import com.google.cloud.vertexai.generativeai.ContentMaker;
import com.google.cloud.vertexai.generativeai.PartMaker;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

@Deprecated
public final class AutomaticFunctionCallingResponder {
    private int maxFunctionCalls = 1;
    private int remainingFunctionCalls;
    private final Map<String, CallableFunction> callableFunctions = new HashMap<String, CallableFunction>();
    private static final Logger logger = Logger.getLogger(AutomaticFunctionCallingResponder.class.getName());

    public AutomaticFunctionCallingResponder() {
        this.remainingFunctionCalls = this.maxFunctionCalls;
    }

    public AutomaticFunctionCallingResponder(int maxFunctionCalls) {
        this.maxFunctionCalls = maxFunctionCalls;
        this.remainingFunctionCalls = maxFunctionCalls;
    }

    public void setMaxFunctionCalls(int maxFunctionCalls) {
        this.remainingFunctionCalls = this.maxFunctionCalls = maxFunctionCalls;
    }

    public int getMaxFunctionCalls() {
        return this.maxFunctionCalls;
    }

    void resetRemainingFunctionCalls() {
        this.remainingFunctionCalls = this.maxFunctionCalls;
    }

    public void addCallableFunction(String functionName, Method callableFunction, String ... orderedParameterNames) {
        if (this.callableFunctions.containsKey(functionName)) {
            throw new IllegalArgumentException("Duplicate function name: " + functionName);
        }
        this.callableFunctions.put(functionName, new CallableFunction(callableFunction, orderedParameterNames));
    }

    Content getContentFromFunctionCalls(List<FunctionCall> functionCalls) {
        Preconditions.checkNotNull(functionCalls, (Object)"functionCalls cannot be null.");
        ArrayList<Part> responseParts = new ArrayList<Part>();
        for (FunctionCall functionCall : functionCalls) {
            if (this.remainingFunctionCalls <= 0) {
                throw new IllegalStateException("Exceeded the maximum number of continuous automatic function calls (" + this.maxFunctionCalls + "). If more automatic function calls are needed, please call `setMaxFunctionCalls() to set a higher number. The last function call is:\n" + functionCall);
            }
            --this.remainingFunctionCalls;
            String functionName = functionCall.getName();
            CallableFunction callableFunction = this.callableFunctions.get(functionName);
            if (callableFunction == null) {
                throw new IllegalArgumentException("Model has asked to call function \"" + functionName + "\" which was not found.");
            }
            responseParts.add(PartMaker.fromFunctionResponse(functionName, Collections.singletonMap("result", callableFunction.call(functionCall.getArgs()))));
        }
        return ContentMaker.fromMultiModalData(responseParts.toArray());
    }

    static class CallableFunction {
        private final Method callableFunction;
        private final ImmutableList<String> orderedParameterNames;

        CallableFunction(Method callableFunction, String ... orderedParameterNames) {
            this.validateFunction(callableFunction);
            this.callableFunction = callableFunction;
            if (orderedParameterNames.length == 0) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Parameter parameter : callableFunction.getParameters()) {
                    if (!parameter.isNamePresent()) {
                        throw new IllegalStateException("Failed to retrieve the parameter name from reflection. Please compile your code with  \"-parameters\" flag or use `addCallableFunction(String, Method, String...)` to manually enter parameter names");
                    }
                    builder.add((Object)parameter.getName());
                }
                this.orderedParameterNames = builder.build();
            } else if (orderedParameterNames.length == callableFunction.getParameters().length) {
                this.orderedParameterNames = ImmutableList.copyOf((Object[])orderedParameterNames);
            } else {
                throw new IllegalArgumentException("The number of provided parameter names doesn't match the number of parameters in the callable function.");
            }
        }

        Object call(Struct args) {
            Map argsMap = args.getFieldsMap();
            ArrayList<Object> argsList = new ArrayList<Object>();
            block8: for (int i = 0; i < this.orderedParameterNames.size(); ++i) {
                String parameterName = (String)this.orderedParameterNames.get(i);
                if (!argsMap.containsKey(parameterName)) {
                    throw new IllegalArgumentException("The parameter \"" + parameterName + "\" was not found in the arguments requested by the model. Args map: " + argsMap);
                }
                Value value = (Value)argsMap.get(parameterName);
                switch (value.getKindCase()) {
                    case NUMBER_VALUE: {
                        Class<?> parameterType = this.callableFunction.getParameters()[i].getType();
                        if (parameterType.equals(Integer.TYPE)) {
                            argsList.add((int)value.getNumberValue());
                            continue block8;
                        }
                        if (parameterType.equals(Float.TYPE)) {
                            argsList.add(Float.valueOf((float)value.getNumberValue()));
                            continue block8;
                        }
                        argsList.add(value.getNumberValue());
                        continue block8;
                    }
                    case STRING_VALUE: {
                        argsList.add(value.getStringValue());
                        continue block8;
                    }
                    case BOOL_VALUE: {
                        argsList.add(value.getBoolValue());
                        continue block8;
                    }
                    case NULL_VALUE: {
                        argsList.add(null);
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported value type " + value.getKindCase() + " for parameter " + parameterName);
                    }
                }
            }
            logger.info("Automatically calling function: " + this.callableFunction.getName() + ((Object)argsList).toString().replace('[', '(').replace(']', ')'));
            try {
                return this.callableFunction.invoke(null, argsList.toArray());
            }
            catch (Exception e) {
                throw new IllegalStateException("Error raised when calling function \"" + this.callableFunction.getName() + "\" as requested by the model. ", e);
            }
        }

        private void validateFunction(Method method) {
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Function calling only supports static methods.");
            }
        }
    }
}

