/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.google.common.base.MoreObjects;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class Part {
    @JacksonXmlProperty(localName="PartNumber")
    private int partNumber;
    @JacksonXmlProperty(localName="ETag")
    private String eTag;
    @JacksonXmlProperty(localName="Size")
    private long size;
    @JacksonXmlProperty(localName="LastModified")
    private OffsetDateTime lastModified;

    private Part() {
    }

    private Part(Builder builder) {
        this.partNumber = builder.partNumber;
        this.eTag = builder.eTag;
        this.size = builder.size;
        this.lastModified = builder.lastModified;
    }

    public int partNumber() {
        return this.partNumber;
    }

    public String eTag() {
        return this.eTag;
    }

    public long size() {
        return this.size;
    }

    public OffsetDateTime lastModified() {
        return this.lastModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Part)) {
            return false;
        }
        Part that = (Part)o;
        return Objects.equals(this.partNumber, that.partNumber) && Objects.equals(this.eTag, that.eTag) && Objects.equals(this.size, that.size) && Objects.equals(this.lastModified, that.lastModified);
    }

    public int hashCode() {
        return Objects.hash(this.partNumber, this.eTag, this.size, this.lastModified);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partNumber", this.partNumber).add("eTag", (Object)this.eTag).add("size", this.size).add("lastModified", (Object)this.lastModified).toString();
    }

    public static final class Builder {
        private int partNumber;
        private String eTag;
        private long size;
        private OffsetDateTime lastModified;

        private Builder() {
        }

        public Builder partNumber(int partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder lastModified(OffsetDateTime lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Part build() {
            return new Part(this);
        }
    }
}

