/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.storage.ApiaryUnbufferedWritableByteChannel;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.ChannelSession;
import com.google.cloud.storage.DefaultBufferedWritableByteChannel;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.HttpClientContext;
import com.google.cloud.storage.JsonResumableWrite;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.StorageByteChannels;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.LongConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;

final class HttpWritableByteChannelSessionBuilder {
    private static final int DEFAULT_BUFFER_CAPACITY = 0x1000000;
    private final @NonNull HttpClientContext httpClientContext;

    HttpWritableByteChannelSessionBuilder(@NonNull HttpClientContext httpClientContext) {
        this.httpClientContext = Objects.requireNonNull(httpClientContext, "httpClientContext must be non null");
    }

    ResumableUploadBuilder resumable() {
        return new ResumableUploadBuilder(this.httpClientContext);
    }

    static final class ResumableUploadBuilder {
        private final @NonNull HttpClientContext httpClientContext;
        private Retrying.RetrierWithAlg retrier;
        private LongConsumer committedBytesCallback;
        private Hasher hasher;

        ResumableUploadBuilder(@NonNull HttpClientContext httpClientContext) {
            this.httpClientContext = httpClientContext;
            this.retrier = Retrying.RetrierWithAlg.attemptOnce();
            this.committedBytesCallback = l -> {};
            this.hasher = Hasher.defaultHasher();
        }

        ResumableUploadBuilder setCommittedBytesCallback(@NonNull LongConsumer committedBytesCallback) {
            this.committedBytesCallback = Objects.requireNonNull(committedBytesCallback, "committedBytesCallback must be non null");
            return this;
        }

        ResumableUploadBuilder withRetryConfig( @NonNull Retrying.RetrierWithAlg retrier) {
            this.retrier = Objects.requireNonNull(retrier, "retrier must be non null");
            return this;
        }

        ResumableUploadBuilder setHasher(@NonNull Hasher hasher) {
            this.hasher = Objects.requireNonNull(hasher, "hasher must be non null");
            return this;
        }

        UnbufferedResumableUploadBuilder unbuffered() {
            return new UnbufferedResumableUploadBuilder();
        }

        BufferedResumableUploadBuilder buffered() {
            return this.buffered(BufferHandle.allocate(0x1000000));
        }

        BufferedResumableUploadBuilder buffered(ByteBuffer byteBuffer) {
            return this.buffered(BufferHandle.handleOf(byteBuffer));
        }

        BufferedResumableUploadBuilder buffered(BufferHandle bufferHandle) {
            return new BufferedResumableUploadBuilder(bufferHandle);
        }

        private BiFunction<JsonResumableWrite, SettableApiFuture<StorageObject>, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel> bindFunction() {
            Retrying.RetrierWithAlg boundRetrier = this.retrier;
            return (start, resultFuture) -> new ApiaryUnbufferedWritableByteChannel(this.httpClientContext, boundRetrier, (JsonResumableWrite)start, (SettableApiFuture<StorageObject>)resultFuture, this.committedBytesCallback);
        }

        final class UnbufferedResumableUploadBuilder {
            private ApiFuture<JsonResumableWrite> start;

            UnbufferedResumableUploadBuilder() {
            }

            UnbufferedResumableUploadBuilder setStartAsync(ApiFuture<JsonResumableWrite> start) {
                this.start = Objects.requireNonNull(start, "start must be non null");
                return this;
            }

            UnbufferedWritableByteChannelSession<StorageObject> build() {
                return new ChannelSession.UnbufferedWriteSession(Objects.requireNonNull(this.start, "start must be non null"), ResumableUploadBuilder.this.bindFunction().andThen(StorageByteChannels.writable()::createSynchronized));
            }
        }

        final class BufferedResumableUploadBuilder {
            private final BufferHandle bufferHandle;
            private ApiFuture<JsonResumableWrite> start;

            BufferedResumableUploadBuilder(BufferHandle bufferHandle) {
                this.bufferHandle = bufferHandle;
            }

            BufferedResumableUploadBuilder setStartAsync(ApiFuture<JsonResumableWrite> start) {
                this.start = Objects.requireNonNull(start, "start must be non null");
                return this;
            }

            BufferedWritableByteChannelSession<StorageObject> build() {
                return new ChannelSession.BufferedWriteSession(Objects.requireNonNull(this.start, "start must be non null"), ResumableUploadBuilder.this.bindFunction().andThen(c -> new DefaultBufferedWritableByteChannel(this.bufferHandle, (UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel)c)).andThen(StorageByteChannels.writable()::createSynchronized));
            }
        }
    }
}

