/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.google.cloud.storage.multipartupload.model.MultipartUpload;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class ListMultipartUploadsResponse {
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="Upload")
    private List<MultipartUpload> uploads;
    @JacksonXmlProperty(localName="Bucket")
    private String bucket;
    @JacksonXmlProperty(localName="Delimiter")
    private String delimiter;
    @JacksonXmlProperty(localName="EncodingType")
    private String encodingType;
    @JacksonXmlProperty(localName="KeyMarker")
    private String keyMarker;
    @JacksonXmlProperty(localName="UploadIdMarker")
    private String uploadIdMarker;
    @JacksonXmlProperty(localName="NextKeyMarker")
    private String nextKeyMarker;
    @JacksonXmlProperty(localName="NextUploadIdMarker")
    private String nextUploadIdMarker;
    @JacksonXmlProperty(localName="MaxUploads")
    private int maxUploads;
    @JacksonXmlProperty(localName="Prefix")
    private String prefix;
    @JsonAlias(value={"truncated"})
    @JacksonXmlProperty(localName="IsTruncated")
    private boolean isTruncated;
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="CommonPrefixes")
    private List<CommonPrefixHelper> commonPrefixes;

    private ListMultipartUploadsResponse() {
    }

    private ListMultipartUploadsResponse(List<MultipartUpload> uploads, String bucket, String delimiter, String encodingType, String keyMarker, String uploadIdMarker, String nextKeyMarker, String nextUploadIdMarker, int maxUploads, String prefix, boolean isTruncated, List<String> commonPrefixes) {
        this.uploads = uploads;
        this.bucket = bucket;
        this.delimiter = delimiter;
        this.encodingType = encodingType;
        this.keyMarker = keyMarker;
        this.uploadIdMarker = uploadIdMarker;
        this.nextKeyMarker = nextKeyMarker;
        this.nextUploadIdMarker = nextUploadIdMarker;
        this.maxUploads = maxUploads;
        this.prefix = prefix;
        this.isTruncated = isTruncated;
        if (commonPrefixes != null) {
            this.commonPrefixes = new ArrayList<CommonPrefixHelper>();
            for (String p : commonPrefixes) {
                CommonPrefixHelper h = new CommonPrefixHelper();
                h.prefix = p;
                this.commonPrefixes.add(h);
            }
        }
    }

    public ImmutableList<MultipartUpload> uploads() {
        return this.uploads == null ? ImmutableList.of() : ImmutableList.copyOf(this.uploads);
    }

    public String bucket() {
        return this.bucket;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public String encodingType() {
        return this.encodingType;
    }

    public String keyMarker() {
        return this.keyMarker;
    }

    public String uploadIdMarker() {
        return this.uploadIdMarker;
    }

    public String nextKeyMarker() {
        return this.nextKeyMarker;
    }

    public String nextUploadIdMarker() {
        return this.nextUploadIdMarker;
    }

    public int maxUploads() {
        return this.maxUploads;
    }

    public String prefix() {
        return this.prefix;
    }

    public boolean truncated() {
        return this.isTruncated;
    }

    public ImmutableList<String> commonPrefixes() {
        if (this.commonPrefixes == null) {
            return ImmutableList.of();
        }
        return (ImmutableList)this.commonPrefixes.stream().map(h -> h.prefix).collect(ImmutableList.toImmutableList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListMultipartUploadsResponse that = (ListMultipartUploadsResponse)o;
        return this.isTruncated == that.isTruncated && this.maxUploads == that.maxUploads && Objects.equals(this.uploads(), that.uploads()) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.encodingType, that.encodingType) && Objects.equals(this.keyMarker, that.keyMarker) && Objects.equals(this.uploadIdMarker, that.uploadIdMarker) && Objects.equals(this.nextKeyMarker, that.nextKeyMarker) && Objects.equals(this.nextUploadIdMarker, that.nextUploadIdMarker) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.commonPrefixes(), that.commonPrefixes());
    }

    public int hashCode() {
        return Objects.hash(this.uploads(), this.bucket, this.delimiter, this.encodingType, this.keyMarker, this.uploadIdMarker, this.nextKeyMarker, this.nextUploadIdMarker, this.maxUploads, this.prefix, this.isTruncated, this.commonPrefixes());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uploads", this.uploads()).add("bucket", (Object)this.bucket).add("delimiter", (Object)this.delimiter).add("encodingType", (Object)this.encodingType).add("keyMarker", (Object)this.keyMarker).add("uploadIdMarker", (Object)this.uploadIdMarker).add("nextKeyMarker", (Object)this.nextKeyMarker).add("nextUploadIdMarker", (Object)this.nextUploadIdMarker).add("maxUploads", this.maxUploads).add("prefix", (Object)this.prefix).add("isTruncated", this.isTruncated).add("commonPrefixes", this.commonPrefixes()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    static class CommonPrefixHelper {
        @JacksonXmlProperty(localName="Prefix")
        public String prefix;

        CommonPrefixHelper() {
        }
    }

    public static final class Builder {
        private ImmutableList<MultipartUpload> uploads;
        private String bucket;
        private String delimiter;
        private String encodingType;
        private String keyMarker;
        private String uploadIdMarker;
        private String nextKeyMarker;
        private String nextUploadIdMarker;
        private int maxUploads;
        private String prefix;
        private boolean isTruncated;
        private ImmutableList<String> commonPrefixes;

        private Builder() {
        }

        public Builder uploads(ImmutableList<MultipartUpload> uploads) {
            this.uploads = uploads;
            return this;
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        public Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        public Builder uploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
            return this;
        }

        public Builder nextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
            return this;
        }

        public Builder nextUploadIdMarker(String nextUploadIdMarker) {
            this.nextUploadIdMarker = nextUploadIdMarker;
            return this;
        }

        public Builder maxUploads(int maxUploads) {
            this.maxUploads = maxUploads;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder truncated(boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public Builder commonPrefixes(ImmutableList<String> commonPrefixes) {
            this.commonPrefixes = commonPrefixes;
            return this;
        }

        public ListMultipartUploadsResponse build() {
            return new ListMultipartUploadsResponse((List)this.uploads, this.bucket, this.delimiter, this.encodingType, this.keyMarker, this.uploadIdMarker, this.nextKeyMarker, this.nextUploadIdMarker, this.maxUploads, this.prefix, this.isTruncated, (List)this.commonPrefixes);
        }
    }
}

