/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddAssociationOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.AddRuleOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.CopyRulesOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.DeleteOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetAssociationOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetRuleOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.InsertOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.ListAssociationsOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.ListOrganizationSecurityPoliciesRequest;
import com.google.cloud.compute.v1.ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest;
import com.google.cloud.compute.v1.MoveOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OrganizationSecurityPoliciesListAssociationsResponse;
import com.google.cloud.compute.v1.OrganizationSecurityPoliciesSettings;
import com.google.cloud.compute.v1.PatchOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.PatchRuleOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.RemoveAssociationOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.RemoveRuleOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.SecurityPoliciesListPreconfiguredExpressionSetsResponse;
import com.google.cloud.compute.v1.SecurityPolicy;
import com.google.cloud.compute.v1.SecurityPolicyAssociation;
import com.google.cloud.compute.v1.SecurityPolicyList;
import com.google.cloud.compute.v1.SecurityPolicyRule;
import com.google.cloud.compute.v1.stub.OrganizationSecurityPoliciesStub;
import com.google.cloud.compute.v1.stub.OrganizationSecurityPoliciesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class OrganizationSecurityPoliciesClient
implements BackgroundResource {
    private final OrganizationSecurityPoliciesSettings settings;
    private final OrganizationSecurityPoliciesStub stub;

    public static final OrganizationSecurityPoliciesClient create() throws IOException {
        return OrganizationSecurityPoliciesClient.create(OrganizationSecurityPoliciesSettings.newBuilder().build());
    }

    public static final OrganizationSecurityPoliciesClient create(OrganizationSecurityPoliciesSettings settings) throws IOException {
        return new OrganizationSecurityPoliciesClient(settings);
    }

    public static final OrganizationSecurityPoliciesClient create(OrganizationSecurityPoliciesStub stub) {
        return new OrganizationSecurityPoliciesClient(stub);
    }

    protected OrganizationSecurityPoliciesClient(OrganizationSecurityPoliciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((OrganizationSecurityPoliciesStubSettings)settings.getStubSettings()).createStub();
    }

    protected OrganizationSecurityPoliciesClient(OrganizationSecurityPoliciesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final OrganizationSecurityPoliciesSettings getSettings() {
        return this.settings;
    }

    public OrganizationSecurityPoliciesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> addAssociationAsync(String securityPolicy, SecurityPolicyAssociation securityPolicyAssociationResource) {
        AddAssociationOrganizationSecurityPolicyRequest request = AddAssociationOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicy(securityPolicy).setSecurityPolicyAssociationResource(securityPolicyAssociationResource).build();
        return this.addAssociationAsync(request);
    }

    public final OperationFuture<Operation, Operation> addAssociationAsync(AddAssociationOrganizationSecurityPolicyRequest request) {
        return this.addAssociationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddAssociationOrganizationSecurityPolicyRequest, Operation, Operation> addAssociationOperationCallable() {
        return this.stub.addAssociationOperationCallable();
    }

    public final UnaryCallable<AddAssociationOrganizationSecurityPolicyRequest, Operation> addAssociationCallable() {
        return this.stub.addAssociationCallable();
    }

    public final OperationFuture<Operation, Operation> addRuleAsync(String securityPolicy, SecurityPolicyRule securityPolicyRuleResource) {
        AddRuleOrganizationSecurityPolicyRequest request = AddRuleOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicy(securityPolicy).setSecurityPolicyRuleResource(securityPolicyRuleResource).build();
        return this.addRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> addRuleAsync(AddRuleOrganizationSecurityPolicyRequest request) {
        return this.addRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddRuleOrganizationSecurityPolicyRequest, Operation, Operation> addRuleOperationCallable() {
        return this.stub.addRuleOperationCallable();
    }

    public final UnaryCallable<AddRuleOrganizationSecurityPolicyRequest, Operation> addRuleCallable() {
        return this.stub.addRuleCallable();
    }

    public final OperationFuture<Operation, Operation> copyRulesAsync(String securityPolicy) {
        CopyRulesOrganizationSecurityPolicyRequest request = CopyRulesOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicy(securityPolicy).build();
        return this.copyRulesAsync(request);
    }

    public final OperationFuture<Operation, Operation> copyRulesAsync(CopyRulesOrganizationSecurityPolicyRequest request) {
        return this.copyRulesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CopyRulesOrganizationSecurityPolicyRequest, Operation, Operation> copyRulesOperationCallable() {
        return this.stub.copyRulesOperationCallable();
    }

    public final UnaryCallable<CopyRulesOrganizationSecurityPolicyRequest, Operation> copyRulesCallable() {
        return this.stub.copyRulesCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String securityPolicy) {
        DeleteOrganizationSecurityPolicyRequest request = DeleteOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicy(securityPolicy).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteOrganizationSecurityPolicyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteOrganizationSecurityPolicyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteOrganizationSecurityPolicyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final SecurityPolicy get(String securityPolicy) {
        GetOrganizationSecurityPolicyRequest request = GetOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicy(securityPolicy).build();
        return this.get(request);
    }

    public final SecurityPolicy get(GetOrganizationSecurityPolicyRequest request) {
        return (SecurityPolicy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetOrganizationSecurityPolicyRequest, SecurityPolicy> getCallable() {
        return this.stub.getCallable();
    }

    public final SecurityPolicyAssociation getAssociation(String securityPolicy) {
        GetAssociationOrganizationSecurityPolicyRequest request = GetAssociationOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicy(securityPolicy).build();
        return this.getAssociation(request);
    }

    public final SecurityPolicyAssociation getAssociation(GetAssociationOrganizationSecurityPolicyRequest request) {
        return (SecurityPolicyAssociation)this.getAssociationCallable().call((Object)request);
    }

    public final UnaryCallable<GetAssociationOrganizationSecurityPolicyRequest, SecurityPolicyAssociation> getAssociationCallable() {
        return this.stub.getAssociationCallable();
    }

    public final SecurityPolicyRule getRule(String securityPolicy) {
        GetRuleOrganizationSecurityPolicyRequest request = GetRuleOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicy(securityPolicy).build();
        return this.getRule(request);
    }

    public final SecurityPolicyRule getRule(GetRuleOrganizationSecurityPolicyRequest request) {
        return (SecurityPolicyRule)this.getRuleCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuleOrganizationSecurityPolicyRequest, SecurityPolicyRule> getRuleCallable() {
        return this.stub.getRuleCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(SecurityPolicy securityPolicyResource) {
        InsertOrganizationSecurityPolicyRequest request = InsertOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicyResource(securityPolicyResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertOrganizationSecurityPolicyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertOrganizationSecurityPolicyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertOrganizationSecurityPolicyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list() {
        ListOrganizationSecurityPoliciesRequest request = ListOrganizationSecurityPoliciesRequest.newBuilder().build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListOrganizationSecurityPoliciesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOrganizationSecurityPoliciesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList> listCallable() {
        return this.stub.listCallable();
    }

    public final OrganizationSecurityPoliciesListAssociationsResponse listAssociations() {
        ListAssociationsOrganizationSecurityPolicyRequest request = ListAssociationsOrganizationSecurityPolicyRequest.newBuilder().build();
        return this.listAssociations(request);
    }

    public final OrganizationSecurityPoliciesListAssociationsResponse listAssociations(ListAssociationsOrganizationSecurityPolicyRequest request) {
        return (OrganizationSecurityPoliciesListAssociationsResponse)this.listAssociationsCallable().call((Object)request);
    }

    public final UnaryCallable<ListAssociationsOrganizationSecurityPolicyRequest, OrganizationSecurityPoliciesListAssociationsResponse> listAssociationsCallable() {
        return this.stub.listAssociationsCallable();
    }

    public final SecurityPoliciesListPreconfiguredExpressionSetsResponse listPreconfiguredExpressionSets() {
        ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest request = ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest.newBuilder().build();
        return this.listPreconfiguredExpressionSets(request);
    }

    public final SecurityPoliciesListPreconfiguredExpressionSetsResponse listPreconfiguredExpressionSets(ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest request) {
        return (SecurityPoliciesListPreconfiguredExpressionSetsResponse)this.listPreconfiguredExpressionSetsCallable().call((Object)request);
    }

    public final UnaryCallable<ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsCallable() {
        return this.stub.listPreconfiguredExpressionSetsCallable();
    }

    public final OperationFuture<Operation, Operation> moveAsync(String securityPolicy) {
        MoveOrganizationSecurityPolicyRequest request = MoveOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicy(securityPolicy).build();
        return this.moveAsync(request);
    }

    public final OperationFuture<Operation, Operation> moveAsync(MoveOrganizationSecurityPolicyRequest request) {
        return this.moveOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<MoveOrganizationSecurityPolicyRequest, Operation, Operation> moveOperationCallable() {
        return this.stub.moveOperationCallable();
    }

    public final UnaryCallable<MoveOrganizationSecurityPolicyRequest, Operation> moveCallable() {
        return this.stub.moveCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String securityPolicy, SecurityPolicy securityPolicyResource) {
        PatchOrganizationSecurityPolicyRequest request = PatchOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicy(securityPolicy).setSecurityPolicyResource(securityPolicyResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchOrganizationSecurityPolicyRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchOrganizationSecurityPolicyRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchOrganizationSecurityPolicyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> patchRuleAsync(String securityPolicy, SecurityPolicyRule securityPolicyRuleResource) {
        PatchRuleOrganizationSecurityPolicyRequest request = PatchRuleOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicy(securityPolicy).setSecurityPolicyRuleResource(securityPolicyRuleResource).build();
        return this.patchRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchRuleAsync(PatchRuleOrganizationSecurityPolicyRequest request) {
        return this.patchRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRuleOrganizationSecurityPolicyRequest, Operation, Operation> patchRuleOperationCallable() {
        return this.stub.patchRuleOperationCallable();
    }

    public final UnaryCallable<PatchRuleOrganizationSecurityPolicyRequest, Operation> patchRuleCallable() {
        return this.stub.patchRuleCallable();
    }

    public final OperationFuture<Operation, Operation> removeAssociationAsync(String securityPolicy) {
        RemoveAssociationOrganizationSecurityPolicyRequest request = RemoveAssociationOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicy(securityPolicy).build();
        return this.removeAssociationAsync(request);
    }

    public final OperationFuture<Operation, Operation> removeAssociationAsync(RemoveAssociationOrganizationSecurityPolicyRequest request) {
        return this.removeAssociationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveAssociationOrganizationSecurityPolicyRequest, Operation, Operation> removeAssociationOperationCallable() {
        return this.stub.removeAssociationOperationCallable();
    }

    public final UnaryCallable<RemoveAssociationOrganizationSecurityPolicyRequest, Operation> removeAssociationCallable() {
        return this.stub.removeAssociationCallable();
    }

    public final OperationFuture<Operation, Operation> removeRuleAsync(String securityPolicy) {
        RemoveRuleOrganizationSecurityPolicyRequest request = RemoveRuleOrganizationSecurityPolicyRequest.newBuilder().setSecurityPolicy(securityPolicy).build();
        return this.removeRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> removeRuleAsync(RemoveRuleOrganizationSecurityPolicyRequest request) {
        return this.removeRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveRuleOrganizationSecurityPolicyRequest, Operation, Operation> removeRuleOperationCallable() {
        return this.stub.removeRuleOperationCallable();
    }

    public final UnaryCallable<RemoveRuleOrganizationSecurityPolicyRequest, Operation> removeRuleCallable() {
        return this.stub.removeRuleCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage> {
        private ListPage(PageContext<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, SecurityPolicyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, SecurityPolicyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, ApiFuture<SecurityPolicyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, ApiFuture<SecurityPolicyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

