/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetInterconnectLocationRequest;
import com.google.cloud.compute.v1.InterconnectLocation;
import com.google.cloud.compute.v1.InterconnectLocationList;
import com.google.cloud.compute.v1.InterconnectLocationsSettings;
import com.google.cloud.compute.v1.ListInterconnectLocationsRequest;
import com.google.cloud.compute.v1.stub.InterconnectLocationsStub;
import com.google.cloud.compute.v1.stub.InterconnectLocationsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InterconnectLocationsClient
implements BackgroundResource {
    private final InterconnectLocationsSettings settings;
    private final InterconnectLocationsStub stub;

    public static final InterconnectLocationsClient create() throws IOException {
        return InterconnectLocationsClient.create(InterconnectLocationsSettings.newBuilder().build());
    }

    public static final InterconnectLocationsClient create(InterconnectLocationsSettings settings) throws IOException {
        return new InterconnectLocationsClient(settings);
    }

    public static final InterconnectLocationsClient create(InterconnectLocationsStub stub) {
        return new InterconnectLocationsClient(stub);
    }

    protected InterconnectLocationsClient(InterconnectLocationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InterconnectLocationsStubSettings)settings.getStubSettings()).createStub();
    }

    protected InterconnectLocationsClient(InterconnectLocationsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InterconnectLocationsSettings getSettings() {
        return this.settings;
    }

    public InterconnectLocationsStub getStub() {
        return this.stub;
    }

    public final InterconnectLocation get(String project, String interconnectLocation) {
        GetInterconnectLocationRequest request = GetInterconnectLocationRequest.newBuilder().setProject(project).setInterconnectLocation(interconnectLocation).build();
        return this.get(request);
    }

    public final InterconnectLocation get(GetInterconnectLocationRequest request) {
        return (InterconnectLocation)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInterconnectLocationRequest, InterconnectLocation> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project) {
        ListInterconnectLocationsRequest request = ListInterconnectLocationsRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInterconnectLocationsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInterconnectLocationsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInterconnectLocationsRequest, InterconnectLocationList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInterconnectLocationsRequest, InterconnectLocationList, InterconnectLocation, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInterconnectLocationsRequest, InterconnectLocationList, InterconnectLocation, ListPage> {
        private ListPage(PageContext<ListInterconnectLocationsRequest, InterconnectLocationList, InterconnectLocation> context, InterconnectLocationList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInterconnectLocationsRequest, InterconnectLocationList, InterconnectLocation> context, InterconnectLocationList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInterconnectLocationsRequest, InterconnectLocationList, InterconnectLocation> context, ApiFuture<InterconnectLocationList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInterconnectLocationsRequest, InterconnectLocationList, InterconnectLocation, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInterconnectLocationsRequest, InterconnectLocationList, InterconnectLocation> context, ApiFuture<InterconnectLocationList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

