/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetPreviewFeatureRequest;
import com.google.cloud.compute.v1.ListPreviewFeaturesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PreviewFeature;
import com.google.cloud.compute.v1.PreviewFeatureList;
import com.google.cloud.compute.v1.PreviewFeaturesSettings;
import com.google.cloud.compute.v1.UpdatePreviewFeatureRequest;
import com.google.cloud.compute.v1.stub.PreviewFeaturesStub;
import com.google.cloud.compute.v1.stub.PreviewFeaturesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class PreviewFeaturesClient
implements BackgroundResource {
    private final PreviewFeaturesSettings settings;
    private final PreviewFeaturesStub stub;

    public static final PreviewFeaturesClient create() throws IOException {
        return PreviewFeaturesClient.create(PreviewFeaturesSettings.newBuilder().build());
    }

    public static final PreviewFeaturesClient create(PreviewFeaturesSettings settings) throws IOException {
        return new PreviewFeaturesClient(settings);
    }

    public static final PreviewFeaturesClient create(PreviewFeaturesStub stub) {
        return new PreviewFeaturesClient(stub);
    }

    protected PreviewFeaturesClient(PreviewFeaturesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PreviewFeaturesStubSettings)settings.getStubSettings()).createStub();
    }

    protected PreviewFeaturesClient(PreviewFeaturesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PreviewFeaturesSettings getSettings() {
        return this.settings;
    }

    public PreviewFeaturesStub getStub() {
        return this.stub;
    }

    public final PreviewFeature get(String project, String previewFeature) {
        GetPreviewFeatureRequest request = GetPreviewFeatureRequest.newBuilder().setProject(project).setPreviewFeature(previewFeature).build();
        return this.get(request);
    }

    public final PreviewFeature get(GetPreviewFeatureRequest request) {
        return (PreviewFeature)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetPreviewFeatureRequest, PreviewFeature> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project) {
        ListPreviewFeaturesRequest request = ListPreviewFeaturesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListPreviewFeaturesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPreviewFeaturesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListPreviewFeaturesRequest, PreviewFeatureList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String previewFeature, PreviewFeature previewFeatureResource) {
        UpdatePreviewFeatureRequest request = UpdatePreviewFeatureRequest.newBuilder().setProject(project).setPreviewFeature(previewFeature).setPreviewFeatureResource(previewFeatureResource).build();
        return this.updateAsync(request);
    }

    public final OperationFuture<Operation, Operation> updateAsync(UpdatePreviewFeatureRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePreviewFeatureRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdatePreviewFeatureRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPreviewFeaturesRequest, PreviewFeatureList, PreviewFeature, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListPreviewFeaturesRequest, PreviewFeatureList, PreviewFeature, ListPage> {
        private ListPage(PageContext<ListPreviewFeaturesRequest, PreviewFeatureList, PreviewFeature> context, PreviewFeatureList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListPreviewFeaturesRequest, PreviewFeatureList, PreviewFeature> context, PreviewFeatureList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListPreviewFeaturesRequest, PreviewFeatureList, PreviewFeature> context, ApiFuture<PreviewFeatureList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListPreviewFeaturesRequest, PreviewFeatureList, PreviewFeature, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListPreviewFeaturesRequest, PreviewFeatureList, PreviewFeature> context, ApiFuture<PreviewFeatureList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

