/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetIamPolicyReservationBlockRequest;
import com.google.cloud.compute.v1.GetReservationBlockRequest;
import com.google.cloud.compute.v1.ListReservationBlocksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PerformMaintenanceReservationBlockRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ReservationBlock;
import com.google.cloud.compute.v1.ReservationBlocksGetResponse;
import com.google.cloud.compute.v1.ReservationBlocksListResponse;
import com.google.cloud.compute.v1.ReservationBlocksSettings;
import com.google.cloud.compute.v1.ReservationsBlocksPerformMaintenanceRequest;
import com.google.cloud.compute.v1.SetIamPolicyReservationBlockRequest;
import com.google.cloud.compute.v1.TestIamPermissionsReservationBlockRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.ZoneSetNestedPolicyRequest;
import com.google.cloud.compute.v1.stub.ReservationBlocksStub;
import com.google.cloud.compute.v1.stub.ReservationBlocksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ReservationBlocksClient
implements BackgroundResource {
    private final ReservationBlocksSettings settings;
    private final ReservationBlocksStub stub;

    public static final ReservationBlocksClient create() throws IOException {
        return ReservationBlocksClient.create(ReservationBlocksSettings.newBuilder().build());
    }

    public static final ReservationBlocksClient create(ReservationBlocksSettings settings) throws IOException {
        return new ReservationBlocksClient(settings);
    }

    public static final ReservationBlocksClient create(ReservationBlocksStub stub) {
        return new ReservationBlocksClient(stub);
    }

    protected ReservationBlocksClient(ReservationBlocksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ReservationBlocksStubSettings)settings.getStubSettings()).createStub();
    }

    protected ReservationBlocksClient(ReservationBlocksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ReservationBlocksSettings getSettings() {
        return this.settings;
    }

    public ReservationBlocksStub getStub() {
        return this.stub;
    }

    public final ReservationBlocksGetResponse get(String project, String zone, String reservation, String reservationBlock) {
        GetReservationBlockRequest request = GetReservationBlockRequest.newBuilder().setProject(project).setZone(zone).setReservation(reservation).setReservationBlock(reservationBlock).build();
        return this.get(request);
    }

    public final ReservationBlocksGetResponse get(GetReservationBlockRequest request) {
        return (ReservationBlocksGetResponse)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetReservationBlockRequest, ReservationBlocksGetResponse> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String zone, String parentResource, String resource) {
        GetIamPolicyReservationBlockRequest request = GetIamPolicyReservationBlockRequest.newBuilder().setProject(project).setZone(zone).setParentResource(parentResource).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyReservationBlockRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyReservationBlockRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final ListPagedResponse list(String project, String zone, String reservation) {
        ListReservationBlocksRequest request = ListReservationBlocksRequest.newBuilder().setProject(project).setZone(zone).setReservation(reservation).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListReservationBlocksRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReservationBlocksRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListReservationBlocksRequest, ReservationBlocksListResponse> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> performMaintenanceAsync(String project, String zone, String reservation, String reservationBlock, ReservationsBlocksPerformMaintenanceRequest reservationsBlocksPerformMaintenanceRequestResource) {
        PerformMaintenanceReservationBlockRequest request = PerformMaintenanceReservationBlockRequest.newBuilder().setProject(project).setZone(zone).setReservation(reservation).setReservationBlock(reservationBlock).setReservationsBlocksPerformMaintenanceRequestResource(reservationsBlocksPerformMaintenanceRequestResource).build();
        return this.performMaintenanceAsync(request);
    }

    public final OperationFuture<Operation, Operation> performMaintenanceAsync(PerformMaintenanceReservationBlockRequest request) {
        return this.performMaintenanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PerformMaintenanceReservationBlockRequest, Operation, Operation> performMaintenanceOperationCallable() {
        return this.stub.performMaintenanceOperationCallable();
    }

    public final UnaryCallable<PerformMaintenanceReservationBlockRequest, Operation> performMaintenanceCallable() {
        return this.stub.performMaintenanceCallable();
    }

    public final Policy setIamPolicy(String project, String zone, String parentResource, String resource, ZoneSetNestedPolicyRequest zoneSetNestedPolicyRequestResource) {
        SetIamPolicyReservationBlockRequest request = SetIamPolicyReservationBlockRequest.newBuilder().setProject(project).setZone(zone).setParentResource(parentResource).setResource(resource).setZoneSetNestedPolicyRequestResource(zoneSetNestedPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyReservationBlockRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyReservationBlockRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String zone, String parentResource, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsReservationBlockRequest request = TestIamPermissionsReservationBlockRequest.newBuilder().setProject(project).setZone(zone).setParentResource(parentResource).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsReservationBlockRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsReservationBlockRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlock, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlock, ListPage> {
        private ListPage(PageContext<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlock> context, ReservationBlocksListResponse response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlock> context, ReservationBlocksListResponse response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlock> context, ApiFuture<ReservationBlocksListResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlock, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlock> context, ApiFuture<ReservationBlocksListResponse> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

