/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddSignedUrlKeyBackendBucketRequest;
import com.google.cloud.compute.v1.BackendBucket;
import com.google.cloud.compute.v1.BackendBucketList;
import com.google.cloud.compute.v1.BackendBucketsSettings;
import com.google.cloud.compute.v1.DeleteBackendBucketRequest;
import com.google.cloud.compute.v1.DeleteSignedUrlKeyBackendBucketRequest;
import com.google.cloud.compute.v1.GetBackendBucketRequest;
import com.google.cloud.compute.v1.InsertBackendBucketRequest;
import com.google.cloud.compute.v1.ListBackendBucketsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchBackendBucketRequest;
import com.google.cloud.compute.v1.SecurityPolicyReference;
import com.google.cloud.compute.v1.SetEdgeSecurityPolicyBackendBucketRequest;
import com.google.cloud.compute.v1.SignedUrlKey;
import com.google.cloud.compute.v1.UpdateBackendBucketRequest;
import com.google.cloud.compute.v1.stub.BackendBucketsStub;
import com.google.cloud.compute.v1.stub.BackendBucketsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BackendBucketsClient
implements BackgroundResource {
    private final BackendBucketsSettings settings;
    private final BackendBucketsStub stub;

    public static final BackendBucketsClient create() throws IOException {
        return BackendBucketsClient.create(BackendBucketsSettings.newBuilder().build());
    }

    public static final BackendBucketsClient create(BackendBucketsSettings settings) throws IOException {
        return new BackendBucketsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BackendBucketsClient create(BackendBucketsStub stub) {
        return new BackendBucketsClient(stub);
    }

    protected BackendBucketsClient(BackendBucketsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BackendBucketsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BackendBucketsClient(BackendBucketsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BackendBucketsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BackendBucketsStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> addSignedUrlKeyAsync(String project, String backendBucket, SignedUrlKey signedUrlKeyResource) {
        AddSignedUrlKeyBackendBucketRequest request = AddSignedUrlKeyBackendBucketRequest.newBuilder().setProject(project).setBackendBucket(backendBucket).setSignedUrlKeyResource(signedUrlKeyResource).build();
        return this.addSignedUrlKeyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> addSignedUrlKeyAsync(AddSignedUrlKeyBackendBucketRequest request) {
        return this.addSignedUrlKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddSignedUrlKeyBackendBucketRequest, Operation, Operation> addSignedUrlKeyOperationCallable() {
        return this.stub.addSignedUrlKeyOperationCallable();
    }

    public final UnaryCallable<AddSignedUrlKeyBackendBucketRequest, Operation> addSignedUrlKeyCallable() {
        return this.stub.addSignedUrlKeyCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String backendBucket) {
        DeleteBackendBucketRequest request = DeleteBackendBucketRequest.newBuilder().setProject(project).setBackendBucket(backendBucket).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteBackendBucketRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackendBucketRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteBackendBucketRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final OperationFuture<Operation, Operation> deleteSignedUrlKeyAsync(String project, String backendBucket, String keyName) {
        DeleteSignedUrlKeyBackendBucketRequest request = DeleteSignedUrlKeyBackendBucketRequest.newBuilder().setProject(project).setBackendBucket(backendBucket).setKeyName(keyName).build();
        return this.deleteSignedUrlKeyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteSignedUrlKeyAsync(DeleteSignedUrlKeyBackendBucketRequest request) {
        return this.deleteSignedUrlKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSignedUrlKeyBackendBucketRequest, Operation, Operation> deleteSignedUrlKeyOperationCallable() {
        return this.stub.deleteSignedUrlKeyOperationCallable();
    }

    public final UnaryCallable<DeleteSignedUrlKeyBackendBucketRequest, Operation> deleteSignedUrlKeyCallable() {
        return this.stub.deleteSignedUrlKeyCallable();
    }

    public final BackendBucket get(String project, String backendBucket) {
        GetBackendBucketRequest request = GetBackendBucketRequest.newBuilder().setProject(project).setBackendBucket(backendBucket).build();
        return this.get(request);
    }

    public final BackendBucket get(GetBackendBucketRequest request) {
        return (BackendBucket)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackendBucketRequest, BackendBucket> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, BackendBucket backendBucketResource) {
        InsertBackendBucketRequest request = InsertBackendBucketRequest.newBuilder().setProject(project).setBackendBucketResource(backendBucketResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertBackendBucketRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertBackendBucketRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertBackendBucketRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListBackendBucketsRequest request = ListBackendBucketsRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListBackendBucketsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackendBucketsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListBackendBucketsRequest, BackendBucketList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String backendBucket, BackendBucket backendBucketResource) {
        PatchBackendBucketRequest request = PatchBackendBucketRequest.newBuilder().setProject(project).setBackendBucket(backendBucket).setBackendBucketResource(backendBucketResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchBackendBucketRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchBackendBucketRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchBackendBucketRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> setEdgeSecurityPolicyAsync(String project, String backendBucket, SecurityPolicyReference securityPolicyReferenceResource) {
        SetEdgeSecurityPolicyBackendBucketRequest request = SetEdgeSecurityPolicyBackendBucketRequest.newBuilder().setProject(project).setBackendBucket(backendBucket).setSecurityPolicyReferenceResource(securityPolicyReferenceResource).build();
        return this.setEdgeSecurityPolicyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setEdgeSecurityPolicyAsync(SetEdgeSecurityPolicyBackendBucketRequest request) {
        return this.setEdgeSecurityPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetEdgeSecurityPolicyBackendBucketRequest, Operation, Operation> setEdgeSecurityPolicyOperationCallable() {
        return this.stub.setEdgeSecurityPolicyOperationCallable();
    }

    public final UnaryCallable<SetEdgeSecurityPolicyBackendBucketRequest, Operation> setEdgeSecurityPolicyCallable() {
        return this.stub.setEdgeSecurityPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String backendBucket, BackendBucket backendBucketResource) {
        UpdateBackendBucketRequest request = UpdateBackendBucketRequest.newBuilder().setProject(project).setBackendBucket(backendBucket).setBackendBucketResource(backendBucketResource).build();
        return this.updateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> updateAsync(UpdateBackendBucketRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateBackendBucketRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdateBackendBucketRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackendBucketsRequest, BackendBucketList, BackendBucket, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListBackendBucketsRequest, BackendBucketList, BackendBucket, ListPage> {
        private ListPage(PageContext<ListBackendBucketsRequest, BackendBucketList, BackendBucket> context, BackendBucketList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListBackendBucketsRequest, BackendBucketList, BackendBucket> context, BackendBucketList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListBackendBucketsRequest, BackendBucketList, BackendBucket> context, ApiFuture<BackendBucketList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListBackendBucketsRequest, BackendBucketList, BackendBucket, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListBackendBucketsRequest, BackendBucketList, BackendBucket> context, ApiFuture<BackendBucketList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

