/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListUrlMapsRequest;
import com.google.cloud.compute.v1.DeleteUrlMapRequest;
import com.google.cloud.compute.v1.GetUrlMapRequest;
import com.google.cloud.compute.v1.InsertUrlMapRequest;
import com.google.cloud.compute.v1.InvalidateCacheUrlMapRequest;
import com.google.cloud.compute.v1.ListUrlMapsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchUrlMapRequest;
import com.google.cloud.compute.v1.UpdateUrlMapRequest;
import com.google.cloud.compute.v1.UrlMap;
import com.google.cloud.compute.v1.UrlMapList;
import com.google.cloud.compute.v1.UrlMapsAggregatedList;
import com.google.cloud.compute.v1.UrlMapsClient;
import com.google.cloud.compute.v1.UrlMapsScopedList;
import com.google.cloud.compute.v1.UrlMapsValidateResponse;
import com.google.cloud.compute.v1.ValidateUrlMapRequest;
import com.google.cloud.compute.v1.stub.HttpJsonUrlMapsStub;
import com.google.cloud.compute.v1.stub.UrlMapsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class UrlMapsStubSettings
extends StubSettings<UrlMapsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, UrlMapsClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteUrlMapRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteUrlMapRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetUrlMapRequest, UrlMap> getSettings;
    private final UnaryCallSettings<InsertUrlMapRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertUrlMapRequest, Operation, Operation> insertOperationSettings;
    private final UnaryCallSettings<InvalidateCacheUrlMapRequest, Operation> invalidateCacheSettings;
    private final OperationCallSettings<InvalidateCacheUrlMapRequest, Operation, Operation> invalidateCacheOperationSettings;
    private final PagedCallSettings<ListUrlMapsRequest, UrlMapList, UrlMapsClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchUrlMapRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchUrlMapRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<UpdateUrlMapRequest, Operation> updateSettings;
    private final OperationCallSettings<UpdateUrlMapRequest, Operation, Operation> updateOperationSettings;
    private final UnaryCallSettings<ValidateUrlMapRequest, UrlMapsValidateResponse> validateSettings;
    private static final PagedListDescriptor<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, Map.Entry<String, UrlMapsScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, Map.Entry<String, UrlMapsScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListUrlMapsRequest injectToken(AggregatedListUrlMapsRequest payload, String token) {
            return AggregatedListUrlMapsRequest.newBuilder((AggregatedListUrlMapsRequest)payload).setPageToken(token).build();
        }

        public AggregatedListUrlMapsRequest injectPageSize(AggregatedListUrlMapsRequest payload, int pageSize) {
            return AggregatedListUrlMapsRequest.newBuilder((AggregatedListUrlMapsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListUrlMapsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(UrlMapsAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, UrlMapsScopedList>> extractResources(UrlMapsAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListUrlMapsRequest, UrlMapList, UrlMap> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListUrlMapsRequest, UrlMapList, UrlMap>(){

        public String emptyToken() {
            return "";
        }

        public ListUrlMapsRequest injectToken(ListUrlMapsRequest payload, String token) {
            return ListUrlMapsRequest.newBuilder((ListUrlMapsRequest)payload).setPageToken(token).build();
        }

        public ListUrlMapsRequest injectPageSize(ListUrlMapsRequest payload, int pageSize) {
            return ListUrlMapsRequest.newBuilder((ListUrlMapsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListUrlMapsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(UrlMapList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UrlMap> extractResources(UrlMapList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, UrlMapsClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, UrlMapsClient.AggregatedListPagedResponse>(){

        public ApiFuture<UrlMapsClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListUrlMapsRequest, UrlMapsAggregatedList> callable, AggregatedListUrlMapsRequest request, ApiCallContext context, ApiFuture<UrlMapsAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return UrlMapsClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, Map.Entry<String, UrlMapsScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListUrlMapsRequest, UrlMapList, UrlMapsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListUrlMapsRequest, UrlMapList, UrlMapsClient.ListPagedResponse>(){

        public ApiFuture<UrlMapsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListUrlMapsRequest, UrlMapList> callable, ListUrlMapsRequest request, ApiCallContext context, ApiFuture<UrlMapList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return UrlMapsClient.ListPagedResponse.createAsync((PageContext<ListUrlMapsRequest, UrlMapList, UrlMap>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, UrlMapsClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteUrlMapRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteUrlMapRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetUrlMapRequest, UrlMap> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertUrlMapRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertUrlMapRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public UnaryCallSettings<InvalidateCacheUrlMapRequest, Operation> invalidateCacheSettings() {
        return this.invalidateCacheSettings;
    }

    public OperationCallSettings<InvalidateCacheUrlMapRequest, Operation, Operation> invalidateCacheOperationSettings() {
        return this.invalidateCacheOperationSettings;
    }

    public PagedCallSettings<ListUrlMapsRequest, UrlMapList, UrlMapsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchUrlMapRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchUrlMapRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<UpdateUrlMapRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    public OperationCallSettings<UpdateUrlMapRequest, Operation, Operation> updateOperationSettings() {
        return this.updateOperationSettings;
    }

    public UnaryCallSettings<ValidateUrlMapRequest, UrlMapsValidateResponse> validateSettings() {
        return this.validateSettings;
    }

    public UrlMapsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonUrlMapsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return UrlMapsStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return UrlMapsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(UrlMapsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected UrlMapsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.invalidateCacheSettings = settingsBuilder.invalidateCacheSettings().build();
        this.invalidateCacheOperationSettings = settingsBuilder.invalidateCacheOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
        this.updateOperationSettings = settingsBuilder.updateOperationSettings().build();
        this.validateSettings = settingsBuilder.validateSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<UrlMapsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, UrlMapsClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteUrlMapRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteUrlMapRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetUrlMapRequest, UrlMap> getSettings;
        private final UnaryCallSettings.Builder<InsertUrlMapRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertUrlMapRequest, Operation, Operation> insertOperationSettings;
        private final UnaryCallSettings.Builder<InvalidateCacheUrlMapRequest, Operation> invalidateCacheSettings;
        private final OperationCallSettings.Builder<InvalidateCacheUrlMapRequest, Operation, Operation> invalidateCacheOperationSettings;
        private final PagedCallSettings.Builder<ListUrlMapsRequest, UrlMapList, UrlMapsClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchUrlMapRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchUrlMapRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<UpdateUrlMapRequest, Operation> updateSettings;
        private final OperationCallSettings.Builder<UpdateUrlMapRequest, Operation, Operation> updateOperationSettings;
        private final UnaryCallSettings.Builder<ValidateUrlMapRequest, UrlMapsValidateResponse> validateSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.invalidateCacheSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.invalidateCacheOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOperationSettings = OperationCallSettings.newBuilder();
            this.validateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.invalidateCacheSettings, this.listSettings, this.patchSettings, this.updateSettings, this.validateSettings);
            Builder.initDefaults(this);
        }

        protected Builder(UrlMapsStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.invalidateCacheSettings = settings.invalidateCacheSettings.toBuilder();
            this.invalidateCacheOperationSettings = settings.invalidateCacheOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.updateOperationSettings = settings.updateOperationSettings.toBuilder();
            this.validateSettings = settings.validateSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.invalidateCacheSettings, this.listSettings, this.patchSettings, this.updateSettings, this.validateSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(UrlMapsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)UrlMapsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)UrlMapsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(UrlMapsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.invalidateCacheSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.validateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.invalidateCacheOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, UrlMapsClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteUrlMapRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteUrlMapRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetUrlMapRequest, UrlMap> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertUrlMapRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertUrlMapRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public UnaryCallSettings.Builder<InvalidateCacheUrlMapRequest, Operation> invalidateCacheSettings() {
            return this.invalidateCacheSettings;
        }

        public OperationCallSettings.Builder<InvalidateCacheUrlMapRequest, Operation, Operation> invalidateCacheOperationSettings() {
            return this.invalidateCacheOperationSettings;
        }

        public PagedCallSettings.Builder<ListUrlMapsRequest, UrlMapList, UrlMapsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchUrlMapRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchUrlMapRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateUrlMapRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        public OperationCallSettings.Builder<UpdateUrlMapRequest, Operation, Operation> updateOperationSettings() {
            return this.updateOperationSettings;
        }

        public UnaryCallSettings.Builder<ValidateUrlMapRequest, UrlMapsValidateResponse> validateSettings() {
            return this.validateSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return UrlMapsStubSettings.getDefaultEndpoint();
        }

        public UrlMapsStubSettings build() throws IOException {
            return new UrlMapsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

