/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.FieldsExtractor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteImageRequest;
import com.google.cloud.compute.v1.DeprecateImageRequest;
import com.google.cloud.compute.v1.GetFromFamilyImageRequest;
import com.google.cloud.compute.v1.GetIamPolicyImageRequest;
import com.google.cloud.compute.v1.GetImageRequest;
import com.google.cloud.compute.v1.Image;
import com.google.cloud.compute.v1.ImageList;
import com.google.cloud.compute.v1.ImagesClient;
import com.google.cloud.compute.v1.InsertImageRequest;
import com.google.cloud.compute.v1.ListImagesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchImageRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyImageRequest;
import com.google.cloud.compute.v1.SetLabelsImageRequest;
import com.google.cloud.compute.v1.TestIamPermissionsImageRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonImagesCallableFactory;
import com.google.cloud.compute.v1.stub.ImagesStub;
import com.google.cloud.compute.v1.stub.ImagesStubSettings;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonImagesStub
extends ImagesStub {
    private static final ApiMethodDescriptor<DeleteImageRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Images/Delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/images/{image}", (FieldsExtractor)new FieldsExtractor<DeleteImageRequest, Map<String, String>>(){

        public Map<String, String> extract(DeleteImageRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "image", (Object)request.getImage());
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<DeleteImageRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(DeleteImageRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<DeleteImageRequest, String>(){

        public String extract(DeleteImageRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<DeprecateImageRequest, Operation> deprecateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Images/Deprecate").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/images/{image}/deprecate", (FieldsExtractor)new FieldsExtractor<DeprecateImageRequest, Map<String, String>>(){

        public Map<String, String> extract(DeprecateImageRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "image", (Object)request.getImage());
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<DeprecateImageRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(DeprecateImageRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<DeprecateImageRequest, String>(){

        public String extract(DeprecateImageRequest request) {
            return ProtoRestSerializer.create().toBody("deprecationStatusResource", (Message)request.getDeprecationStatusResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<GetImageRequest, Image> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Images/Get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/images/{image}", (FieldsExtractor)new FieldsExtractor<GetImageRequest, Map<String, String>>(){

        public Map<String, String> extract(GetImageRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "image", (Object)request.getImage());
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<GetImageRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(GetImageRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<GetImageRequest, String>(){

        public String extract(GetImageRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Image.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<GetFromFamilyImageRequest, Image> getFromFamilyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Images/GetFromFamily").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/images/family/{family}", (FieldsExtractor)new FieldsExtractor<GetFromFamilyImageRequest, Map<String, String>>(){

        public Map<String, String> extract(GetFromFamilyImageRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "family", (Object)request.getFamily());
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<GetFromFamilyImageRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(GetFromFamilyImageRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<GetFromFamilyImageRequest, String>(){

        public String extract(GetFromFamilyImageRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Image.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyImageRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Images/GetIamPolicy").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/images/{resource}/getIamPolicy", (FieldsExtractor)new FieldsExtractor<GetIamPolicyImageRequest, Map<String, String>>(){

        public Map<String, String> extract(GetIamPolicyImageRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<GetIamPolicyImageRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(GetIamPolicyImageRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasOptionsRequestedPolicyVersion()) {
                serializer.putQueryParam(fields, "optionsRequestedPolicyVersion", (Object)request.getOptionsRequestedPolicyVersion());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<GetIamPolicyImageRequest, String>(){

        public String extract(GetIamPolicyImageRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<InsertImageRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Images/Insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/images", (FieldsExtractor)new FieldsExtractor<InsertImageRequest, Map<String, String>>(){

        public Map<String, String> extract(InsertImageRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<InsertImageRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(InsertImageRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasForceCreate()) {
                serializer.putQueryParam(fields, "forceCreate", (Object)request.getForceCreate());
            }
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<InsertImageRequest, String>(){

        public String extract(InsertImageRequest request) {
            return ProtoRestSerializer.create().toBody("imageResource", (Message)request.getImageResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<ListImagesRequest, ImageList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Images/List").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/images", (FieldsExtractor)new FieldsExtractor<ListImagesRequest, Map<String, String>>(){

        public Map<String, String> extract(ListImagesRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<ListImagesRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(ListImagesRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasFilter()) {
                serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
            }
            if (request.hasMaxResults()) {
                serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
            }
            if (request.hasOrderBy()) {
                serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
            }
            if (request.hasPageToken()) {
                serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
            }
            if (request.hasReturnPartialSuccess()) {
                serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<ListImagesRequest, String>(){

        public String extract(ListImagesRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ImageList.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<PatchImageRequest, Operation> patchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Images/Patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/images/{image}", (FieldsExtractor)new FieldsExtractor<PatchImageRequest, Map<String, String>>(){

        public Map<String, String> extract(PatchImageRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "image", (Object)request.getImage());
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<PatchImageRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(PatchImageRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<PatchImageRequest, String>(){

        public String extract(PatchImageRequest request) {
            return ProtoRestSerializer.create().toBody("imageResource", (Message)request.getImageResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyImageRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Images/SetIamPolicy").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/images/{resource}/setIamPolicy", (FieldsExtractor)new FieldsExtractor<SetIamPolicyImageRequest, Map<String, String>>(){

        public Map<String, String> extract(SetIamPolicyImageRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<SetIamPolicyImageRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(SetIamPolicyImageRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<SetIamPolicyImageRequest, String>(){

        public String extract(SetIamPolicyImageRequest request) {
            return ProtoRestSerializer.create().toBody("globalSetPolicyRequestResource", (Message)request.getGlobalSetPolicyRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<SetLabelsImageRequest, Operation> setLabelsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Images/SetLabels").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/images/{resource}/setLabels", (FieldsExtractor)new FieldsExtractor<SetLabelsImageRequest, Map<String, String>>(){

        public Map<String, String> extract(SetLabelsImageRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<SetLabelsImageRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(SetLabelsImageRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<SetLabelsImageRequest, String>(){

        public String extract(SetLabelsImageRequest request) {
            return ProtoRestSerializer.create().toBody("globalSetLabelsRequestResource", (Message)request.getGlobalSetLabelsRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsImageRequest, TestPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Images/TestIamPermissions").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/images/{resource}/testIamPermissions", (FieldsExtractor)new FieldsExtractor<TestIamPermissionsImageRequest, Map<String, String>>(){

        public Map<String, String> extract(TestIamPermissionsImageRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<TestIamPermissionsImageRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(TestIamPermissionsImageRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<TestIamPermissionsImageRequest, String>(){

        public String extract(TestIamPermissionsImageRequest request) {
            return ProtoRestSerializer.create().toBody("testPermissionsRequestResource", (Message)request.getTestPermissionsRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestPermissionsResponse.getDefaultInstance()).build()).build();
    private final UnaryCallable<DeleteImageRequest, Operation> deleteCallable;
    private final UnaryCallable<DeprecateImageRequest, Operation> deprecateCallable;
    private final UnaryCallable<GetImageRequest, Image> getCallable;
    private final UnaryCallable<GetFromFamilyImageRequest, Image> getFromFamilyCallable;
    private final UnaryCallable<GetIamPolicyImageRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<InsertImageRequest, Operation> insertCallable;
    private final UnaryCallable<ListImagesRequest, ImageList> listCallable;
    private final UnaryCallable<ListImagesRequest, ImagesClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<PatchImageRequest, Operation> patchCallable;
    private final UnaryCallable<SetIamPolicyImageRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<SetLabelsImageRequest, Operation> setLabelsCallable;
    private final UnaryCallable<TestIamPermissionsImageRequest, TestPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonImagesStub create(ImagesStubSettings settings) throws IOException {
        return new HttpJsonImagesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonImagesStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonImagesStub(ImagesStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonImagesStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonImagesStub(ImagesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonImagesStub(ImagesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonImagesCallableFactory());
    }

    protected HttpJsonImagesStub(ImagesStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).build();
        HttpJsonCallSettings deprecateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deprecateMethodDescriptor).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).build();
        HttpJsonCallSettings getFromFamilyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFromFamilyMethodDescriptor).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).build();
        HttpJsonCallSettings patchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchMethodDescriptor).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).build();
        HttpJsonCallSettings setLabelsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setLabelsMethodDescriptor).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).build();
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.deprecateCallable = callableFactory.createUnaryCallable(deprecateTransportSettings, settings.deprecateSettings(), clientContext);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.getFromFamilyCallable = callableFactory.createUnaryCallable(getFromFamilyTransportSettings, settings.getFromFamilySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.patchCallable = callableFactory.createUnaryCallable(patchTransportSettings, settings.patchSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.setLabelsCallable = callableFactory.createUnaryCallable(setLabelsTransportSettings, settings.setLabelsSettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(deleteMethodDescriptor);
        methodDescriptors.add(deprecateMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(getFromFamilyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(insertMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        methodDescriptors.add(patchMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(setLabelsMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<DeleteImageRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public UnaryCallable<DeprecateImageRequest, Operation> deprecateCallable() {
        return this.deprecateCallable;
    }

    @Override
    public UnaryCallable<GetImageRequest, Image> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<GetFromFamilyImageRequest, Image> getFromFamilyCallable() {
        return this.getFromFamilyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyImageRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<InsertImageRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public UnaryCallable<ListImagesRequest, ImageList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListImagesRequest, ImagesClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<PatchImageRequest, Operation> patchCallable() {
        return this.patchCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyImageRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetLabelsImageRequest, Operation> setLabelsCallable() {
        return this.setLabelsCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsImageRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

