/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteSslPolicyRequest;
import com.google.cloud.compute.v1.GetSslPolicyRequest;
import com.google.cloud.compute.v1.InsertSslPolicyRequest;
import com.google.cloud.compute.v1.ListAvailableFeaturesSslPoliciesRequest;
import com.google.cloud.compute.v1.ListSslPoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchSslPolicyRequest;
import com.google.cloud.compute.v1.SslPoliciesList;
import com.google.cloud.compute.v1.SslPoliciesListAvailableFeaturesResponse;
import com.google.cloud.compute.v1.SslPoliciesSettings;
import com.google.cloud.compute.v1.SslPolicy;
import com.google.cloud.compute.v1.stub.SslPoliciesStub;
import com.google.cloud.compute.v1.stub.SslPoliciesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SslPoliciesClient
implements BackgroundResource {
    private final SslPoliciesSettings settings;
    private final SslPoliciesStub stub;

    public static final SslPoliciesClient create() throws IOException {
        return SslPoliciesClient.create(SslPoliciesSettings.newBuilder().build());
    }

    public static final SslPoliciesClient create(SslPoliciesSettings settings) throws IOException {
        return new SslPoliciesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SslPoliciesClient create(SslPoliciesStub stub) {
        return new SslPoliciesClient(stub);
    }

    protected SslPoliciesClient(SslPoliciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SslPoliciesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SslPoliciesClient(SslPoliciesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SslPoliciesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SslPoliciesStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String sslPolicy) {
        DeleteSslPolicyRequest request = DeleteSslPolicyRequest.newBuilder().setProject(project).setSslPolicy(sslPolicy).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteSslPolicyRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSslPolicyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final SslPolicy get(String project, String sslPolicy) {
        GetSslPolicyRequest request = GetSslPolicyRequest.newBuilder().setProject(project).setSslPolicy(sslPolicy).build();
        return this.get(request);
    }

    public final SslPolicy get(GetSslPolicyRequest request) {
        return (SslPolicy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetSslPolicyRequest, SslPolicy> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, SslPolicy sslPolicyResource) {
        InsertSslPolicyRequest request = InsertSslPolicyRequest.newBuilder().setProject(project).setSslPolicyResource(sslPolicyResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertSslPolicyRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertSslPolicyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListSslPoliciesRequest request = ListSslPoliciesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListSslPoliciesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSslPoliciesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListSslPoliciesRequest, SslPoliciesList> listCallable() {
        return this.stub.listCallable();
    }

    public final SslPoliciesListAvailableFeaturesResponse listAvailableFeatures(String project) {
        ListAvailableFeaturesSslPoliciesRequest request = ListAvailableFeaturesSslPoliciesRequest.newBuilder().setProject(project).build();
        return this.listAvailableFeatures(request);
    }

    public final SslPoliciesListAvailableFeaturesResponse listAvailableFeatures(ListAvailableFeaturesSslPoliciesRequest request) {
        return (SslPoliciesListAvailableFeaturesResponse)this.listAvailableFeaturesCallable().call((Object)request);
    }

    public final UnaryCallable<ListAvailableFeaturesSslPoliciesRequest, SslPoliciesListAvailableFeaturesResponse> listAvailableFeaturesCallable() {
        return this.stub.listAvailableFeaturesCallable();
    }

    public final Operation patch(String project, String sslPolicy, SslPolicy sslPolicyResource) {
        PatchSslPolicyRequest request = PatchSslPolicyRequest.newBuilder().setProject(project).setSslPolicy(sslPolicy).setSslPolicyResource(sslPolicyResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchSslPolicyRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchSslPolicyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSslPoliciesRequest, SslPoliciesList, SslPolicy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListSslPoliciesRequest, SslPoliciesList, SslPolicy, ListPage> {
        private ListPage(PageContext<ListSslPoliciesRequest, SslPoliciesList, SslPolicy> context, SslPoliciesList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListSslPoliciesRequest, SslPoliciesList, SslPolicy> context, SslPoliciesList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListSslPoliciesRequest, SslPoliciesList, SslPolicy> context, ApiFuture<SslPoliciesList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListSslPoliciesRequest, SslPoliciesList, SslPolicy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListSslPoliciesRequest, SslPoliciesList, SslPolicy> context, ApiFuture<SslPoliciesList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

