/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetRegionInstanceGroupRequest;
import com.google.cloud.compute.v1.InstanceGroup;
import com.google.cloud.compute.v1.InstanceWithNamedPorts;
import com.google.cloud.compute.v1.ListInstancesRegionInstanceGroupsRequest;
import com.google.cloud.compute.v1.ListRegionInstanceGroupsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionInstanceGroupList;
import com.google.cloud.compute.v1.RegionInstanceGroupsListInstances;
import com.google.cloud.compute.v1.RegionInstanceGroupsListInstancesRequest;
import com.google.cloud.compute.v1.RegionInstanceGroupsSetNamedPortsRequest;
import com.google.cloud.compute.v1.RegionInstanceGroupsSettings;
import com.google.cloud.compute.v1.SetNamedPortsRegionInstanceGroupRequest;
import com.google.cloud.compute.v1.stub.RegionInstanceGroupsStub;
import com.google.cloud.compute.v1.stub.RegionInstanceGroupsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionInstanceGroupsClient
implements BackgroundResource {
    private final RegionInstanceGroupsSettings settings;
    private final RegionInstanceGroupsStub stub;

    public static final RegionInstanceGroupsClient create() throws IOException {
        return RegionInstanceGroupsClient.create(RegionInstanceGroupsSettings.newBuilder().build());
    }

    public static final RegionInstanceGroupsClient create(RegionInstanceGroupsSettings settings) throws IOException {
        return new RegionInstanceGroupsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionInstanceGroupsClient create(RegionInstanceGroupsStub stub) {
        return new RegionInstanceGroupsClient(stub);
    }

    protected RegionInstanceGroupsClient(RegionInstanceGroupsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionInstanceGroupsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionInstanceGroupsClient(RegionInstanceGroupsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionInstanceGroupsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionInstanceGroupsStub getStub() {
        return this.stub;
    }

    public final InstanceGroup get(String project, String region, String instanceGroup) {
        GetRegionInstanceGroupRequest request = GetRegionInstanceGroupRequest.newBuilder().setProject(project).setRegion(region).setInstanceGroup(instanceGroup).build();
        return this.get(request);
    }

    public final InstanceGroup get(GetRegionInstanceGroupRequest request) {
        return (InstanceGroup)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionInstanceGroupRequest, InstanceGroup> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionInstanceGroupsRequest request = ListRegionInstanceGroupsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionInstanceGroupsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionInstanceGroupsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionInstanceGroupsRequest, RegionInstanceGroupList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListInstancesPagedResponse listInstances(String project, String region, String instanceGroup, RegionInstanceGroupsListInstancesRequest regionInstanceGroupsListInstancesRequestResource) {
        ListInstancesRegionInstanceGroupsRequest request = ListInstancesRegionInstanceGroupsRequest.newBuilder().setProject(project).setRegion(region).setInstanceGroup(instanceGroup).setRegionInstanceGroupsListInstancesRequestResource(regionInstanceGroupsListInstancesRequestResource).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRegionInstanceGroupsRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRegionInstanceGroupsRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Operation setNamedPorts(String project, String region, String instanceGroup, RegionInstanceGroupsSetNamedPortsRequest regionInstanceGroupsSetNamedPortsRequestResource) {
        SetNamedPortsRegionInstanceGroupRequest request = SetNamedPortsRegionInstanceGroupRequest.newBuilder().setProject(project).setRegion(region).setInstanceGroup(instanceGroup).setRegionInstanceGroupsSetNamedPortsRequestResource(regionInstanceGroupsSetNamedPortsRequestResource).build();
        return this.setNamedPorts(request);
    }

    public final Operation setNamedPorts(SetNamedPortsRegionInstanceGroupRequest request) {
        return (Operation)this.setNamedPortsCallable().call((Object)request);
    }

    public final UnaryCallable<SetNamedPortsRegionInstanceGroupRequest, Operation> setNamedPortsCallable() {
        return this.stub.setNamedPortsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts> context, RegionInstanceGroupsListInstances response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts> context, RegionInstanceGroupsListInstances response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts> context, ApiFuture<RegionInstanceGroupsListInstances> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts> context, ApiFuture<RegionInstanceGroupsListInstances> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInstancesPage, ListInstancesPagedResponse>(){

                public ListInstancesPagedResponse apply(ListInstancesPage input) {
                    return new ListInstancesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, InstanceGroup, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, InstanceGroup, ListPage> {
        private ListPage(PageContext<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, InstanceGroup> context, RegionInstanceGroupList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, InstanceGroup> context, RegionInstanceGroupList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, InstanceGroup> context, ApiFuture<RegionInstanceGroupList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, InstanceGroup, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, InstanceGroup> context, ApiFuture<RegionInstanceGroupList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

