/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteGlobalForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.ForwardingRule;
import com.google.cloud.compute.v1.ForwardingRuleList;
import com.google.cloud.compute.v1.GetGlobalForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.GlobalForwardingRuleSettings;
import com.google.cloud.compute.v1.InsertGlobalForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.ListGlobalForwardingRulesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalForwardingRuleName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SetTargetGlobalForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.TargetReference;
import com.google.cloud.compute.v1.stub.GlobalForwardingRuleStub;
import com.google.cloud.compute.v1.stub.GlobalForwardingRuleStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GlobalForwardingRuleClient
implements BackgroundResource {
    private final GlobalForwardingRuleSettings settings;
    private final GlobalForwardingRuleStub stub;

    public static final GlobalForwardingRuleClient create() throws IOException {
        return GlobalForwardingRuleClient.create(GlobalForwardingRuleSettings.newBuilder().build());
    }

    public static final GlobalForwardingRuleClient create(GlobalForwardingRuleSettings settings) throws IOException {
        return new GlobalForwardingRuleClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GlobalForwardingRuleClient create(GlobalForwardingRuleStub stub) {
        return new GlobalForwardingRuleClient(stub);
    }

    protected GlobalForwardingRuleClient(GlobalForwardingRuleSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GlobalForwardingRuleStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GlobalForwardingRuleClient(GlobalForwardingRuleStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GlobalForwardingRuleSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalForwardingRuleStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteGlobalForwardingRule(ProjectGlobalForwardingRuleName forwardingRule) {
        DeleteGlobalForwardingRuleHttpRequest request = DeleteGlobalForwardingRuleHttpRequest.newBuilder().setForwardingRule(forwardingRule == null ? null : forwardingRule.toString()).build();
        return this.deleteGlobalForwardingRule(request);
    }

    @BetaApi
    public final Operation deleteGlobalForwardingRule(String forwardingRule) {
        DeleteGlobalForwardingRuleHttpRequest request = DeleteGlobalForwardingRuleHttpRequest.newBuilder().setForwardingRule(forwardingRule).build();
        return this.deleteGlobalForwardingRule(request);
    }

    @BetaApi
    public final Operation deleteGlobalForwardingRule(DeleteGlobalForwardingRuleHttpRequest request) {
        return (Operation)this.deleteGlobalForwardingRuleCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteGlobalForwardingRuleHttpRequest, Operation> deleteGlobalForwardingRuleCallable() {
        return this.stub.deleteGlobalForwardingRuleCallable();
    }

    @BetaApi
    public final ForwardingRule getGlobalForwardingRule(ProjectGlobalForwardingRuleName forwardingRule) {
        GetGlobalForwardingRuleHttpRequest request = GetGlobalForwardingRuleHttpRequest.newBuilder().setForwardingRule(forwardingRule == null ? null : forwardingRule.toString()).build();
        return this.getGlobalForwardingRule(request);
    }

    @BetaApi
    public final ForwardingRule getGlobalForwardingRule(String forwardingRule) {
        GetGlobalForwardingRuleHttpRequest request = GetGlobalForwardingRuleHttpRequest.newBuilder().setForwardingRule(forwardingRule).build();
        return this.getGlobalForwardingRule(request);
    }

    @BetaApi
    public final ForwardingRule getGlobalForwardingRule(GetGlobalForwardingRuleHttpRequest request) {
        return (ForwardingRule)this.getGlobalForwardingRuleCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetGlobalForwardingRuleHttpRequest, ForwardingRule> getGlobalForwardingRuleCallable() {
        return this.stub.getGlobalForwardingRuleCallable();
    }

    @BetaApi
    public final Operation insertGlobalForwardingRule(ProjectName project, ForwardingRule forwardingRuleResource) {
        InsertGlobalForwardingRuleHttpRequest request = InsertGlobalForwardingRuleHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setForwardingRuleResource(forwardingRuleResource).build();
        return this.insertGlobalForwardingRule(request);
    }

    @BetaApi
    public final Operation insertGlobalForwardingRule(String project, ForwardingRule forwardingRuleResource) {
        InsertGlobalForwardingRuleHttpRequest request = InsertGlobalForwardingRuleHttpRequest.newBuilder().setProject(project).setForwardingRuleResource(forwardingRuleResource).build();
        return this.insertGlobalForwardingRule(request);
    }

    @BetaApi
    public final Operation insertGlobalForwardingRule(InsertGlobalForwardingRuleHttpRequest request) {
        return (Operation)this.insertGlobalForwardingRuleCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertGlobalForwardingRuleHttpRequest, Operation> insertGlobalForwardingRuleCallable() {
        return this.stub.insertGlobalForwardingRuleCallable();
    }

    @BetaApi
    public final ListGlobalForwardingRulesPagedResponse listGlobalForwardingRules(ProjectName project) {
        ListGlobalForwardingRulesHttpRequest request = ListGlobalForwardingRulesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listGlobalForwardingRules(request);
    }

    @BetaApi
    public final ListGlobalForwardingRulesPagedResponse listGlobalForwardingRules(String project) {
        ListGlobalForwardingRulesHttpRequest request = ListGlobalForwardingRulesHttpRequest.newBuilder().setProject(project).build();
        return this.listGlobalForwardingRules(request);
    }

    @BetaApi
    public final ListGlobalForwardingRulesPagedResponse listGlobalForwardingRules(ListGlobalForwardingRulesHttpRequest request) {
        return (ListGlobalForwardingRulesPagedResponse)((Object)this.listGlobalForwardingRulesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListGlobalForwardingRulesHttpRequest, ListGlobalForwardingRulesPagedResponse> listGlobalForwardingRulesPagedCallable() {
        return this.stub.listGlobalForwardingRulesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList> listGlobalForwardingRulesCallable() {
        return this.stub.listGlobalForwardingRulesCallable();
    }

    @BetaApi
    public final Operation setTargetGlobalForwardingRule(ProjectGlobalForwardingRuleName forwardingRule, TargetReference targetReferenceResource) {
        SetTargetGlobalForwardingRuleHttpRequest request = SetTargetGlobalForwardingRuleHttpRequest.newBuilder().setForwardingRule(forwardingRule == null ? null : forwardingRule.toString()).setTargetReferenceResource(targetReferenceResource).build();
        return this.setTargetGlobalForwardingRule(request);
    }

    @BetaApi
    public final Operation setTargetGlobalForwardingRule(String forwardingRule, TargetReference targetReferenceResource) {
        SetTargetGlobalForwardingRuleHttpRequest request = SetTargetGlobalForwardingRuleHttpRequest.newBuilder().setForwardingRule(forwardingRule).setTargetReferenceResource(targetReferenceResource).build();
        return this.setTargetGlobalForwardingRule(request);
    }

    @BetaApi
    public final Operation setTargetGlobalForwardingRule(SetTargetGlobalForwardingRuleHttpRequest request) {
        return (Operation)this.setTargetGlobalForwardingRuleCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetTargetGlobalForwardingRuleHttpRequest, Operation> setTargetGlobalForwardingRuleCallable() {
        return this.stub.setTargetGlobalForwardingRuleCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListGlobalForwardingRulesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule, ListGlobalForwardingRulesPage, ListGlobalForwardingRulesFixedSizeCollection> {
        private ListGlobalForwardingRulesFixedSizeCollection(List<ListGlobalForwardingRulesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGlobalForwardingRulesFixedSizeCollection createEmptyCollection() {
            return new ListGlobalForwardingRulesFixedSizeCollection(null, 0);
        }

        protected ListGlobalForwardingRulesFixedSizeCollection createCollection(List<ListGlobalForwardingRulesPage> pages, int collectionSize) {
            return new ListGlobalForwardingRulesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGlobalForwardingRulesPage
    extends AbstractPage<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule, ListGlobalForwardingRulesPage> {
        private ListGlobalForwardingRulesPage(PageContext<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule> context, ForwardingRuleList response) {
            super(context, (Object)response);
        }

        private static ListGlobalForwardingRulesPage createEmptyPage() {
            return new ListGlobalForwardingRulesPage(null, null);
        }

        protected ListGlobalForwardingRulesPage createPage(PageContext<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule> context, ForwardingRuleList response) {
            return new ListGlobalForwardingRulesPage(context, response);
        }

        public ApiFuture<ListGlobalForwardingRulesPage> createPageAsync(PageContext<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule> context, ApiFuture<ForwardingRuleList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGlobalForwardingRulesPagedResponse
    extends AbstractPagedListResponse<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule, ListGlobalForwardingRulesPage, ListGlobalForwardingRulesFixedSizeCollection> {
        public static ApiFuture<ListGlobalForwardingRulesPagedResponse> createAsync(PageContext<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule> context, ApiFuture<ForwardingRuleList> futureResponse) {
            ApiFuture<ListGlobalForwardingRulesPage> futurePage = ListGlobalForwardingRulesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListGlobalForwardingRulesPage, ListGlobalForwardingRulesPagedResponse>(){

                public ListGlobalForwardingRulesPagedResponse apply(ListGlobalForwardingRulesPage input) {
                    return new ListGlobalForwardingRulesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListGlobalForwardingRulesPagedResponse(ListGlobalForwardingRulesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGlobalForwardingRulesFixedSizeCollection.createEmptyCollection());
        }
    }
}

