/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ResourceCommitment
implements ApiMessage {
    private final String amount;
    private final String type;
    private static final ResourceCommitment DEFAULT_INSTANCE = new ResourceCommitment();

    private ResourceCommitment() {
        this.amount = null;
        this.type = null;
    }

    private ResourceCommitment(String amount, String type) {
        this.amount = amount;
        this.type = type;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("amount")) {
            return this.amount;
        }
        if (fieldName.equals("type")) {
            return this.type;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getType() {
        return this.type;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ResourceCommitment prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ResourceCommitment getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ResourceCommitment{amount=" + this.amount + ", type=" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ResourceCommitment) {
            ResourceCommitment that = (ResourceCommitment)o;
            return Objects.equals(this.amount, that.getAmount()) && Objects.equals(this.type, that.getType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.type);
    }

    public static class Builder {
        private String amount;
        private String type;

        Builder() {
        }

        public Builder mergeFrom(ResourceCommitment other) {
            if (other == ResourceCommitment.getDefaultInstance()) {
                return this;
            }
            if (other.getAmount() != null) {
                this.amount = other.amount;
            }
            if (other.getType() != null) {
                this.type = other.type;
            }
            return this;
        }

        Builder(ResourceCommitment source) {
            this.amount = source.amount;
            this.type = source.type;
        }

        public String getAmount() {
            return this.amount;
        }

        public Builder setAmount(String amount) {
            this.amount = amount;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public ResourceCommitment build() {
            return new ResourceCommitment(this.amount, this.type);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAmount(this.amount);
            newBuilder.setType(this.type);
            return newBuilder;
        }
    }
}

