/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class DeprecationStatus
implements ApiMessage {
    private final String deleted;
    private final String deprecated;
    private final String obsolete;
    private final String replacement;
    private final String state;
    private static final DeprecationStatus DEFAULT_INSTANCE = new DeprecationStatus();

    private DeprecationStatus() {
        this.deleted = null;
        this.deprecated = null;
        this.obsolete = null;
        this.replacement = null;
        this.state = null;
    }

    private DeprecationStatus(String deleted, String deprecated, String obsolete, String replacement, String state) {
        this.deleted = deleted;
        this.deprecated = deprecated;
        this.obsolete = obsolete;
        this.replacement = replacement;
        this.state = state;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("deleted")) {
            return this.deleted;
        }
        if (fieldName.equals("deprecated")) {
            return this.deprecated;
        }
        if (fieldName.equals("obsolete")) {
            return this.obsolete;
        }
        if (fieldName.equals("replacement")) {
            return this.replacement;
        }
        if (fieldName.equals("state")) {
            return this.state;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getDeleted() {
        return this.deleted;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public String getObsolete() {
        return this.obsolete;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public String getState() {
        return this.state;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DeprecationStatus prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static DeprecationStatus getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "DeprecationStatus{deleted=" + this.deleted + ", deprecated=" + this.deprecated + ", obsolete=" + this.obsolete + ", replacement=" + this.replacement + ", state=" + this.state + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DeprecationStatus) {
            DeprecationStatus that = (DeprecationStatus)o;
            return Objects.equals(this.deleted, that.getDeleted()) && Objects.equals(this.deprecated, that.getDeprecated()) && Objects.equals(this.obsolete, that.getObsolete()) && Objects.equals(this.replacement, that.getReplacement()) && Objects.equals(this.state, that.getState());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.deleted, this.deprecated, this.obsolete, this.replacement, this.state);
    }

    public static class Builder {
        private String deleted;
        private String deprecated;
        private String obsolete;
        private String replacement;
        private String state;

        Builder() {
        }

        public Builder mergeFrom(DeprecationStatus other) {
            if (other == DeprecationStatus.getDefaultInstance()) {
                return this;
            }
            if (other.getDeleted() != null) {
                this.deleted = other.deleted;
            }
            if (other.getDeprecated() != null) {
                this.deprecated = other.deprecated;
            }
            if (other.getObsolete() != null) {
                this.obsolete = other.obsolete;
            }
            if (other.getReplacement() != null) {
                this.replacement = other.replacement;
            }
            if (other.getState() != null) {
                this.state = other.state;
            }
            return this;
        }

        Builder(DeprecationStatus source) {
            this.deleted = source.deleted;
            this.deprecated = source.deprecated;
            this.obsolete = source.obsolete;
            this.replacement = source.replacement;
            this.state = source.state;
        }

        public String getDeleted() {
            return this.deleted;
        }

        public Builder setDeleted(String deleted) {
            this.deleted = deleted;
            return this;
        }

        public String getDeprecated() {
            return this.deprecated;
        }

        public Builder setDeprecated(String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public String getObsolete() {
            return this.obsolete;
        }

        public Builder setObsolete(String obsolete) {
            this.obsolete = obsolete;
            return this;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public Builder setReplacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        public String getState() {
            return this.state;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public DeprecationStatus build() {
            return new DeprecationStatus(this.deleted, this.deprecated, this.obsolete, this.replacement, this.state);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setDeleted(this.deleted);
            newBuilder.setDeprecated(this.deprecated);
            newBuilder.setObsolete(this.obsolete);
            newBuilder.setReplacement(this.replacement);
            newBuilder.setState(this.state);
            return newBuilder;
        }
    }
}

