/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Subnetwork;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InsertSubnetworkHttpRequest
implements ApiMessage {
    private final String access_token;
    private final String callback;
    private final String fields;
    private final String key;
    private final String prettyPrint;
    private final String quotaUser;
    private final String region;
    private final String requestId;
    private final Subnetwork subnetworkResource;
    private final String userIp;
    private static final InsertSubnetworkHttpRequest DEFAULT_INSTANCE = new InsertSubnetworkHttpRequest();

    private InsertSubnetworkHttpRequest() {
        this.access_token = null;
        this.callback = null;
        this.fields = null;
        this.key = null;
        this.prettyPrint = null;
        this.quotaUser = null;
        this.region = null;
        this.requestId = null;
        this.subnetworkResource = null;
        this.userIp = null;
    }

    private InsertSubnetworkHttpRequest(String access_token, String callback, String fields, String key, String prettyPrint, String quotaUser, String region, String requestId, Subnetwork subnetworkResource, String userIp) {
        this.access_token = access_token;
        this.callback = callback;
        this.fields = fields;
        this.key = key;
        this.prettyPrint = prettyPrint;
        this.quotaUser = quotaUser;
        this.region = region;
        this.requestId = requestId;
        this.subnetworkResource = subnetworkResource;
        this.userIp = userIp;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("access_token")) {
            return this.access_token;
        }
        if (fieldName.equals("callback")) {
            return this.callback;
        }
        if (fieldName.equals("fields")) {
            return this.fields;
        }
        if (fieldName.equals("key")) {
            return this.key;
        }
        if (fieldName.equals("prettyPrint")) {
            return this.prettyPrint;
        }
        if (fieldName.equals("quotaUser")) {
            return this.quotaUser;
        }
        if (fieldName.equals("region")) {
            return this.region;
        }
        if (fieldName.equals("requestId")) {
            return this.requestId;
        }
        if (fieldName.equals("subnetworkResource")) {
            return this.subnetworkResource;
        }
        if (fieldName.equals("userIp")) {
            return this.userIp;
        }
        return null;
    }

    @Nullable
    public Subnetwork getApiMessageRequestBody() {
        return this.subnetworkResource;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getFields() {
        return this.fields;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public String getQuotaUser() {
        return this.quotaUser;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Subnetwork getSubnetworkResource() {
        return this.subnetworkResource;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InsertSubnetworkHttpRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InsertSubnetworkHttpRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InsertSubnetworkHttpRequest{access_token=" + this.access_token + ", callback=" + this.callback + ", fields=" + this.fields + ", key=" + this.key + ", prettyPrint=" + this.prettyPrint + ", quotaUser=" + this.quotaUser + ", region=" + this.region + ", requestId=" + this.requestId + ", subnetworkResource=" + this.subnetworkResource + ", userIp=" + this.userIp + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InsertSubnetworkHttpRequest) {
            InsertSubnetworkHttpRequest that = (InsertSubnetworkHttpRequest)o;
            return Objects.equals(this.access_token, that.getAccessToken()) && Objects.equals(this.callback, that.getCallback()) && Objects.equals(this.fields, that.getFields()) && Objects.equals(this.key, that.getKey()) && Objects.equals(this.prettyPrint, that.getPrettyPrint()) && Objects.equals(this.quotaUser, that.getQuotaUser()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.requestId, that.getRequestId()) && Objects.equals(this.subnetworkResource, that.getSubnetworkResource()) && Objects.equals(this.userIp, that.getUserIp());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.access_token, this.callback, this.fields, this.key, this.prettyPrint, this.quotaUser, this.region, this.requestId, this.subnetworkResource, this.userIp);
    }

    public static class Builder {
        private String access_token;
        private String callback;
        private String fields;
        private String key;
        private String prettyPrint;
        private String quotaUser;
        private String region;
        private String requestId;
        private Subnetwork subnetworkResource;
        private String userIp;

        Builder() {
        }

        public Builder mergeFrom(InsertSubnetworkHttpRequest other) {
            if (other == InsertSubnetworkHttpRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessToken() != null) {
                this.access_token = other.access_token;
            }
            if (other.getCallback() != null) {
                this.callback = other.callback;
            }
            if (other.getFields() != null) {
                this.fields = other.fields;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getPrettyPrint() != null) {
                this.prettyPrint = other.prettyPrint;
            }
            if (other.getQuotaUser() != null) {
                this.quotaUser = other.quotaUser;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getRequestId() != null) {
                this.requestId = other.requestId;
            }
            if (other.getSubnetworkResource() != null) {
                this.subnetworkResource = other.subnetworkResource;
            }
            if (other.getUserIp() != null) {
                this.userIp = other.userIp;
            }
            return this;
        }

        Builder(InsertSubnetworkHttpRequest source) {
            this.access_token = source.access_token;
            this.callback = source.callback;
            this.fields = source.fields;
            this.key = source.key;
            this.prettyPrint = source.prettyPrint;
            this.quotaUser = source.quotaUser;
            this.region = source.region;
            this.requestId = source.requestId;
            this.subnetworkResource = source.subnetworkResource;
            this.userIp = source.userIp;
        }

        public String getAccessToken() {
            return this.access_token;
        }

        public Builder setAccessToken(String access_token) {
            this.access_token = access_token;
            return this;
        }

        public String getCallback() {
            return this.callback;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public String getFields() {
            return this.fields;
        }

        public Builder setFields(String fields) {
            this.fields = fields;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getPrettyPrint() {
            return this.prettyPrint;
        }

        public Builder setPrettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public String getQuotaUser() {
            return this.quotaUser;
        }

        public Builder setQuotaUser(String quotaUser) {
            this.quotaUser = quotaUser;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Subnetwork getSubnetworkResource() {
            return this.subnetworkResource;
        }

        public Builder setSubnetworkResource(Subnetwork subnetworkResource) {
            this.subnetworkResource = subnetworkResource;
            return this;
        }

        public String getUserIp() {
            return this.userIp;
        }

        public Builder setUserIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public InsertSubnetworkHttpRequest build() {
            String missing = "";
            if (this.region == null) {
                missing = missing + " region";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new InsertSubnetworkHttpRequest(this.access_token, this.callback, this.fields, this.key, this.prettyPrint, this.quotaUser, this.region, this.requestId, this.subnetworkResource, this.userIp);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAccessToken(this.access_token);
            newBuilder.setCallback(this.callback);
            newBuilder.setFields(this.fields);
            newBuilder.setKey(this.key);
            newBuilder.setPrettyPrint(this.prettyPrint);
            newBuilder.setQuotaUser(this.quotaUser);
            newBuilder.setRegion(this.region);
            newBuilder.setRequestId(this.requestId);
            newBuilder.setSubnetworkResource(this.subnetworkResource);
            newBuilder.setUserIp(this.userIp);
            return newBuilder;
        }
    }
}

