/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.SubnetworkId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class NetworkInterface
implements Serializable {
    static final Function<com.google.api.services.compute.model.NetworkInterface, NetworkInterface> FROM_PB_FUNCTION = new Function<com.google.api.services.compute.model.NetworkInterface, NetworkInterface>(){

        public NetworkInterface apply(com.google.api.services.compute.model.NetworkInterface pb) {
            return NetworkInterface.fromPb(pb);
        }
    };
    static final Function<NetworkInterface, com.google.api.services.compute.model.NetworkInterface> TO_PB_FUNCTION = new Function<NetworkInterface, com.google.api.services.compute.model.NetworkInterface>(){

        public com.google.api.services.compute.model.NetworkInterface apply(NetworkInterface networkInterface) {
            return networkInterface.toPb();
        }
    };
    private static final long serialVersionUID = 936741262053605581L;
    private final String name;
    private final NetworkId network;
    private final String networkIp;
    private final SubnetworkId subnetwork;
    private final List<AccessConfig> accessConfigurations;

    private NetworkInterface(Builder builder) {
        this.name = builder.name;
        this.network = builder.network;
        this.networkIp = builder.networkIp;
        this.subnetwork = builder.subnetwork;
        this.accessConfigurations = builder.accessConfigurations != null ? builder.accessConfigurations : ImmutableList.of();
    }

    public String name() {
        return this.name;
    }

    public NetworkId network() {
        return this.network;
    }

    public String networkIp() {
        return this.networkIp;
    }

    public SubnetworkId subnetwork() {
        return this.subnetwork;
    }

    public List<AccessConfig> accessConfigurations() {
        return this.accessConfigurations;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("network", (Object)this.network).add("networkIp", (Object)this.networkIp).add("subnetwork", (Object)this.subnetwork).add("accessConfigurations", this.accessConfigurations).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.network, this.networkIp, this.subnetwork, this.accessConfigurations);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(NetworkInterface.class) && Objects.equals(this.toPb(), ((NetworkInterface)obj).toPb());
    }

    com.google.api.services.compute.model.NetworkInterface toPb() {
        com.google.api.services.compute.model.NetworkInterface interfacePb = new com.google.api.services.compute.model.NetworkInterface();
        interfacePb.setName(this.name);
        interfacePb.setNetwork(this.network.selfLink());
        if (this.subnetwork != null) {
            interfacePb.setSubnetwork(this.subnetwork.selfLink());
        }
        interfacePb.setNetworkIP(this.networkIp);
        if (this.accessConfigurations != null) {
            interfacePb.setAccessConfigs(Lists.transform(this.accessConfigurations, AccessConfig.TO_PB_FUNCTION));
        }
        return interfacePb;
    }

    NetworkInterface setProjectId(String projectId) {
        Builder builder = this.toBuilder();
        builder.network(this.network.setProjectId(projectId));
        if (this.subnetwork != null) {
            builder.subnetwork(this.subnetwork.setProjectId(projectId));
        }
        return builder.build();
    }

    public static Builder builder(NetworkId networkId) {
        return new Builder(networkId);
    }

    public static Builder builder(String network) {
        return NetworkInterface.builder(NetworkId.of(network));
    }

    public static NetworkInterface of(NetworkId networkId) {
        return NetworkInterface.builder(networkId).build();
    }

    public static NetworkInterface of(String network) {
        return NetworkInterface.builder(network).build();
    }

    static NetworkInterface fromPb(com.google.api.services.compute.model.NetworkInterface interfacePb) {
        Builder builder = NetworkInterface.builder(NetworkId.fromUrl(interfacePb.getNetwork())).name(interfacePb.getName());
        if (interfacePb.getSubnetwork() != null) {
            builder.subnetwork(SubnetworkId.fromUrl(interfacePb.getSubnetwork()));
        }
        builder.networkIp(interfacePb.getNetworkIP());
        builder.accessConfigurations(interfacePb.getAccessConfigs() != null ? Lists.transform((List)interfacePb.getAccessConfigs(), AccessConfig.FROM_PB_FUNCTION) : ImmutableList.of());
        return builder.build();
    }

    public static final class Builder {
        private String name;
        private NetworkId network;
        private String networkIp;
        private SubnetworkId subnetwork;
        private List<AccessConfig> accessConfigurations;

        private Builder(NetworkId network) {
            this.network = (NetworkId)Preconditions.checkNotNull((Object)network);
        }

        private Builder(NetworkInterface networkInterface) {
            this.name = networkInterface.name;
            this.network = networkInterface.network;
            this.networkIp = networkInterface.networkIp;
            this.subnetwork = networkInterface.subnetwork;
            this.accessConfigurations = networkInterface.accessConfigurations;
        }

        Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder network(NetworkId network) {
            this.network = (NetworkId)Preconditions.checkNotNull((Object)network);
            return this;
        }

        Builder networkIp(String networkIp) {
            this.networkIp = networkIp;
            return this;
        }

        public Builder subnetwork(SubnetworkId subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        public Builder accessConfigurations(List<AccessConfig> accessConfigurations) {
            this.accessConfigurations = ImmutableList.copyOf(accessConfigurations);
            return this;
        }

        public Builder accessConfigurations(AccessConfig ... accessConfigurations) {
            this.accessConfigurations(Arrays.asList(accessConfigurations));
            return this;
        }

        public NetworkInterface build() {
            return new NetworkInterface(this);
        }
    }

    public static final class AccessConfig
    implements Serializable {
        static final Function<com.google.api.services.compute.model.AccessConfig, AccessConfig> FROM_PB_FUNCTION = new Function<com.google.api.services.compute.model.AccessConfig, AccessConfig>(){

            public AccessConfig apply(com.google.api.services.compute.model.AccessConfig pb) {
                return AccessConfig.fromPb(pb);
            }
        };
        static final Function<AccessConfig, com.google.api.services.compute.model.AccessConfig> TO_PB_FUNCTION = new Function<AccessConfig, com.google.api.services.compute.model.AccessConfig>(){

            public com.google.api.services.compute.model.AccessConfig apply(AccessConfig instance) {
                return instance.toPb();
            }
        };
        private static final long serialVersionUID = -5438060668934041567L;
        private final String name;
        private final String natIp;
        private final Type type;

        AccessConfig(Builder builder) {
            this.name = builder.name;
            this.natIp = builder.natIp;
            this.type = builder.type;
        }

        public String name() {
            return this.name;
        }

        public String natIp() {
            return this.natIp;
        }

        public Type type() {
            return this.type;
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("natIp", (Object)this.natIp).add("type", (Object)this.type).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.natIp, this.type});
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof AccessConfig && Objects.equals(this.toPb(), ((AccessConfig)obj).toPb());
        }

        com.google.api.services.compute.model.AccessConfig toPb() {
            com.google.api.services.compute.model.AccessConfig accessConfigPb = new com.google.api.services.compute.model.AccessConfig();
            accessConfigPb.setName(this.name);
            accessConfigPb.setNatIP(this.natIp);
            if (this.type != null) {
                accessConfigPb.setType(this.type.name());
            }
            return accessConfigPb;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AccessConfig of(String natIp) {
            return AccessConfig.builder().natIp(natIp).build();
        }

        public static AccessConfig of() {
            return AccessConfig.builder().build();
        }

        static AccessConfig fromPb(com.google.api.services.compute.model.AccessConfig configPb) {
            Builder builder = AccessConfig.builder();
            builder.name(configPb.getName());
            if (configPb.getNatIP() != null) {
                builder.natIp(configPb.getNatIP());
            }
            if (configPb.getType() != null) {
                builder.type(Type.valueOf(configPb.getType()));
            }
            return builder.build();
        }

        public static final class Builder {
            private String name;
            private String natIp;
            private Type type;

            private Builder() {
            }

            private Builder(AccessConfig accessConfig) {
                this.name = accessConfig.name;
                this.natIp = accessConfig.natIp;
                this.type = accessConfig.type;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder natIp(String natIp) {
                this.natIp = natIp;
                return this;
            }

            public Builder type(Type type) {
                this.type = type;
                return this;
            }

            public AccessConfig build() {
                return new AccessConfig(this);
            }
        }

        public static enum Type {
            ONE_TO_ONE_NAT;

        }
    }
}

