/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.AddressId;
import com.google.cloud.compute.AddressInfo;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.Operation;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;

public class Address
extends AddressInfo {
    private static final long serialVersionUID = 3457542817554062712L;
    private final ComputeOptions options;
    private transient Compute compute;

    Address(Compute compute, AddressInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.compute = (Compute)Preconditions.checkNotNull((Object)compute);
        this.options = (ComputeOptions)compute.options();
    }

    public boolean exists() {
        return this.reload(Compute.AddressOption.fields(new Compute.AddressField[0])) != null;
    }

    public Address reload(Compute.AddressOption ... options) {
        return this.compute.getAddress((AddressId)this.addressId(), options);
    }

    public Operation delete(Compute.OperationOption ... options) {
        return this.compute.deleteAddress((AddressId)this.addressId(), options);
    }

    public Compute compute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Address.class)) {
            return false;
        }
        Address other = (Address)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.service();
    }

    static Address fromPb(Compute compute, com.google.api.services.compute.model.Address addressPb) {
        return new Address(compute, new AddressInfo.BuilderImpl(addressPb));
    }

    public static class Builder
    extends AddressInfo.Builder {
        private final Compute compute;
        private final AddressInfo.BuilderImpl infoBuilder;

        Builder(Compute compute, AddressId addressId) {
            this.compute = compute;
            this.infoBuilder = new AddressInfo.BuilderImpl();
            this.infoBuilder.addressId(addressId);
        }

        Builder(Address address) {
            this.compute = address.compute;
            this.infoBuilder = new AddressInfo.BuilderImpl(address);
        }

        @Override
        public Builder address(String address) {
            this.infoBuilder.address(address);
            return this;
        }

        @Override
        Builder creationTimestamp(Long creationTimestamp) {
            this.infoBuilder.creationTimestamp(creationTimestamp);
            return this;
        }

        @Override
        public Builder description(String description) {
            this.infoBuilder.description(description);
            return this;
        }

        @Override
        Builder generatedId(String generatedId) {
            this.infoBuilder.generatedId(generatedId);
            return this;
        }

        @Override
        public Builder addressId(AddressId addressId) {
            this.infoBuilder.addressId(addressId);
            return this;
        }

        @Override
        Builder status(AddressInfo.Status status) {
            this.infoBuilder.status(status);
            return this;
        }

        @Override
        Builder usage(AddressInfo.Usage usage) {
            this.infoBuilder.usage(usage);
            return this;
        }

        @Override
        public Address build() {
            return new Address(this.compute, this.infoBuilder);
        }
    }
}

