/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.Autoscaler;
import com.google.cloud.compute.v1.DeleteRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.GetRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.InsertRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.ListRegionAutoscalersHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.RegionAutoscalerClient;
import com.google.cloud.compute.v1.RegionAutoscalerList;
import com.google.cloud.compute.v1.UpdateRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionAutoscalerStub;
import com.google.cloud.compute.v1.stub.RegionAutoscalerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionAutoscalerStubSettings
extends StubSettings<RegionAutoscalerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteRegionAutoscalerHttpRequest, Operation> deleteRegionAutoscalerSettings;
    private final UnaryCallSettings<GetRegionAutoscalerHttpRequest, Autoscaler> getRegionAutoscalerSettings;
    private final UnaryCallSettings<InsertRegionAutoscalerHttpRequest, Operation> insertRegionAutoscalerSettings;
    private final PagedCallSettings<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, RegionAutoscalerClient.ListRegionAutoscalersPagedResponse> listRegionAutoscalersSettings;
    private final UnaryCallSettings<PatchRegionAutoscalerHttpRequest, Operation> patchRegionAutoscalerSettings;
    private final UnaryCallSettings<UpdateRegionAutoscalerHttpRequest, Operation> updateRegionAutoscalerSettings;
    private static final PagedListDescriptor<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, Autoscaler> LIST_REGION_AUTOSCALERS_PAGE_STR_DESC = new PagedListDescriptor<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, Autoscaler>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionAutoscalersHttpRequest injectToken(ListRegionAutoscalersHttpRequest payload, String token) {
            return ListRegionAutoscalersHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionAutoscalersHttpRequest injectPageSize(ListRegionAutoscalersHttpRequest payload, int pageSize) {
            return ListRegionAutoscalersHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionAutoscalersHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RegionAutoscalerList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Autoscaler> extractResources(RegionAutoscalerList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, RegionAutoscalerClient.ListRegionAutoscalersPagedResponse> LIST_REGION_AUTOSCALERS_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, RegionAutoscalerClient.ListRegionAutoscalersPagedResponse>(){

        public ApiFuture<RegionAutoscalerClient.ListRegionAutoscalersPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionAutoscalersHttpRequest, RegionAutoscalerList> callable, ListRegionAutoscalersHttpRequest request, ApiCallContext context, ApiFuture<RegionAutoscalerList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_AUTOSCALERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionAutoscalerClient.ListRegionAutoscalersPagedResponse.createAsync((PageContext<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, Autoscaler>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionAutoscalerHttpRequest, Operation> deleteRegionAutoscalerSettings() {
        return this.deleteRegionAutoscalerSettings;
    }

    public UnaryCallSettings<GetRegionAutoscalerHttpRequest, Autoscaler> getRegionAutoscalerSettings() {
        return this.getRegionAutoscalerSettings;
    }

    public UnaryCallSettings<InsertRegionAutoscalerHttpRequest, Operation> insertRegionAutoscalerSettings() {
        return this.insertRegionAutoscalerSettings;
    }

    public PagedCallSettings<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, RegionAutoscalerClient.ListRegionAutoscalersPagedResponse> listRegionAutoscalersSettings() {
        return this.listRegionAutoscalersSettings;
    }

    public UnaryCallSettings<PatchRegionAutoscalerHttpRequest, Operation> patchRegionAutoscalerSettings() {
        return this.patchRegionAutoscalerSettings;
    }

    public UnaryCallSettings<UpdateRegionAutoscalerHttpRequest, Operation> updateRegionAutoscalerSettings() {
        return this.updateRegionAutoscalerSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionAutoscalerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionAutoscalerStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionAutoscalerStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionAutoscalerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionAutoscalerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteRegionAutoscalerSettings = settingsBuilder.deleteRegionAutoscalerSettings().build();
        this.getRegionAutoscalerSettings = settingsBuilder.getRegionAutoscalerSettings().build();
        this.insertRegionAutoscalerSettings = settingsBuilder.insertRegionAutoscalerSettings().build();
        this.listRegionAutoscalersSettings = settingsBuilder.listRegionAutoscalersSettings().build();
        this.patchRegionAutoscalerSettings = settingsBuilder.patchRegionAutoscalerSettings().build();
        this.updateRegionAutoscalerSettings = settingsBuilder.updateRegionAutoscalerSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionAutoscalerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionAutoscalerHttpRequest, Operation> deleteRegionAutoscalerSettings;
        private final UnaryCallSettings.Builder<GetRegionAutoscalerHttpRequest, Autoscaler> getRegionAutoscalerSettings;
        private final UnaryCallSettings.Builder<InsertRegionAutoscalerHttpRequest, Operation> insertRegionAutoscalerSettings;
        private final PagedCallSettings.Builder<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, RegionAutoscalerClient.ListRegionAutoscalersPagedResponse> listRegionAutoscalersSettings;
        private final UnaryCallSettings.Builder<PatchRegionAutoscalerHttpRequest, Operation> patchRegionAutoscalerSettings;
        private final UnaryCallSettings.Builder<UpdateRegionAutoscalerHttpRequest, Operation> updateRegionAutoscalerSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteRegionAutoscalerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRegionAutoscalerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRegionAutoscalerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionAutoscalersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_AUTOSCALERS_PAGE_STR_FACT);
            this.patchRegionAutoscalerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRegionAutoscalerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionAutoscalerSettings, this.getRegionAutoscalerSettings, this.insertRegionAutoscalerSettings, this.listRegionAutoscalersSettings, this.patchRegionAutoscalerSettings, this.updateRegionAutoscalerSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionAutoscalerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionAutoscalerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionAutoscalerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionAutoscalerStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteRegionAutoscalerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionAutoscalerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRegionAutoscalerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionAutoscalersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchRegionAutoscalerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateRegionAutoscalerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionAutoscalerStubSettings settings) {
            super((StubSettings)settings);
            this.deleteRegionAutoscalerSettings = settings.deleteRegionAutoscalerSettings.toBuilder();
            this.getRegionAutoscalerSettings = settings.getRegionAutoscalerSettings.toBuilder();
            this.insertRegionAutoscalerSettings = settings.insertRegionAutoscalerSettings.toBuilder();
            this.listRegionAutoscalersSettings = settings.listRegionAutoscalersSettings.toBuilder();
            this.patchRegionAutoscalerSettings = settings.patchRegionAutoscalerSettings.toBuilder();
            this.updateRegionAutoscalerSettings = settings.updateRegionAutoscalerSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionAutoscalerSettings, this.getRegionAutoscalerSettings, this.insertRegionAutoscalerSettings, this.listRegionAutoscalersSettings, this.patchRegionAutoscalerSettings, this.updateRegionAutoscalerSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionAutoscalerHttpRequest, Operation> deleteRegionAutoscalerSettings() {
            return this.deleteRegionAutoscalerSettings;
        }

        public UnaryCallSettings.Builder<GetRegionAutoscalerHttpRequest, Autoscaler> getRegionAutoscalerSettings() {
            return this.getRegionAutoscalerSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionAutoscalerHttpRequest, Operation> insertRegionAutoscalerSettings() {
            return this.insertRegionAutoscalerSettings;
        }

        public PagedCallSettings.Builder<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, RegionAutoscalerClient.ListRegionAutoscalersPagedResponse> listRegionAutoscalersSettings() {
            return this.listRegionAutoscalersSettings;
        }

        public UnaryCallSettings.Builder<PatchRegionAutoscalerHttpRequest, Operation> patchRegionAutoscalerSettings() {
            return this.patchRegionAutoscalerSettings;
        }

        public UnaryCallSettings.Builder<UpdateRegionAutoscalerHttpRequest, Operation> updateRegionAutoscalerSettings() {
            return this.updateRegionAutoscalerSettings;
        }

        public RegionAutoscalerStubSettings build() throws IOException {
            return new RegionAutoscalerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

