/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo;
import com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class PacketMirroringMirroredResourceInfo
implements ApiMessage {
    private final List<PacketMirroringMirroredResourceInfoInstanceInfo> instances;
    private final List<PacketMirroringMirroredResourceInfoSubnetInfo> subnetworks;
    private final List<String> tags;
    private static final PacketMirroringMirroredResourceInfo DEFAULT_INSTANCE = new PacketMirroringMirroredResourceInfo();

    private PacketMirroringMirroredResourceInfo() {
        this.instances = null;
        this.subnetworks = null;
        this.tags = null;
    }

    private PacketMirroringMirroredResourceInfo(List<PacketMirroringMirroredResourceInfoInstanceInfo> instances, List<PacketMirroringMirroredResourceInfoSubnetInfo> subnetworks, List<String> tags) {
        this.instances = instances;
        this.subnetworks = subnetworks;
        this.tags = tags;
    }

    public Object getFieldValue(String fieldName) {
        if ("instances".equals(fieldName)) {
            return this.instances;
        }
        if ("subnetworks".equals(fieldName)) {
            return this.subnetworks;
        }
        if ("tags".equals(fieldName)) {
            return this.tags;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<PacketMirroringMirroredResourceInfoInstanceInfo> getInstancesList() {
        return this.instances;
    }

    public List<PacketMirroringMirroredResourceInfoSubnetInfo> getSubnetworksList() {
        return this.subnetworks;
    }

    public List<String> getTagsList() {
        return this.tags;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PacketMirroringMirroredResourceInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static PacketMirroringMirroredResourceInfo getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "PacketMirroringMirroredResourceInfo{instances=" + this.instances + ", subnetworks=" + this.subnetworks + ", tags=" + this.tags + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PacketMirroringMirroredResourceInfo) {
            PacketMirroringMirroredResourceInfo that = (PacketMirroringMirroredResourceInfo)o;
            return Objects.equals(this.instances, that.getInstancesList()) && Objects.equals(this.subnetworks, that.getSubnetworksList()) && Objects.equals(this.tags, that.getTagsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instances, this.subnetworks, this.tags);
    }

    public static class Builder {
        private List<PacketMirroringMirroredResourceInfoInstanceInfo> instances;
        private List<PacketMirroringMirroredResourceInfoSubnetInfo> subnetworks;
        private List<String> tags;

        Builder() {
        }

        public Builder mergeFrom(PacketMirroringMirroredResourceInfo other) {
            if (other == PacketMirroringMirroredResourceInfo.getDefaultInstance()) {
                return this;
            }
            if (other.getInstancesList() != null) {
                this.instances = other.instances;
            }
            if (other.getSubnetworksList() != null) {
                this.subnetworks = other.subnetworks;
            }
            if (other.getTagsList() != null) {
                this.tags = other.tags;
            }
            return this;
        }

        Builder(PacketMirroringMirroredResourceInfo source) {
            this.instances = source.instances;
            this.subnetworks = source.subnetworks;
            this.tags = source.tags;
        }

        public List<PacketMirroringMirroredResourceInfoInstanceInfo> getInstancesList() {
            return this.instances;
        }

        public Builder addAllInstances(List<PacketMirroringMirroredResourceInfoInstanceInfo> instances) {
            if (this.instances == null) {
                this.instances = new LinkedList<PacketMirroringMirroredResourceInfoInstanceInfo>();
            }
            this.instances.addAll(instances);
            return this;
        }

        public Builder addInstances(PacketMirroringMirroredResourceInfoInstanceInfo instances) {
            if (this.instances == null) {
                this.instances = new LinkedList<PacketMirroringMirroredResourceInfoInstanceInfo>();
            }
            this.instances.add(instances);
            return this;
        }

        public List<PacketMirroringMirroredResourceInfoSubnetInfo> getSubnetworksList() {
            return this.subnetworks;
        }

        public Builder addAllSubnetworks(List<PacketMirroringMirroredResourceInfoSubnetInfo> subnetworks) {
            if (this.subnetworks == null) {
                this.subnetworks = new LinkedList<PacketMirroringMirroredResourceInfoSubnetInfo>();
            }
            this.subnetworks.addAll(subnetworks);
            return this;
        }

        public Builder addSubnetworks(PacketMirroringMirroredResourceInfoSubnetInfo subnetworks) {
            if (this.subnetworks == null) {
                this.subnetworks = new LinkedList<PacketMirroringMirroredResourceInfoSubnetInfo>();
            }
            this.subnetworks.add(subnetworks);
            return this;
        }

        public List<String> getTagsList() {
            return this.tags;
        }

        public Builder addAllTags(List<String> tags) {
            if (this.tags == null) {
                this.tags = new LinkedList<String>();
            }
            this.tags.addAll(tags);
            return this;
        }

        public Builder addTags(String tags) {
            if (this.tags == null) {
                this.tags = new LinkedList<String>();
            }
            this.tags.add(tags);
            return this;
        }

        public PacketMirroringMirroredResourceInfo build() {
            return new PacketMirroringMirroredResourceInfo(this.instances, this.subnetworks, this.tags);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllInstances(this.instances);
            newBuilder.addAllSubnetworks(this.subnetworks);
            newBuilder.addAllTags(this.tags);
            return newBuilder;
        }
    }
}

