/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.AggregatedListRoutersHttpRequest;
import com.google.cloud.compute.v1.DeleteRouterHttpRequest;
import com.google.cloud.compute.v1.GetNatMappingInfoRoutersHttpRequest;
import com.google.cloud.compute.v1.GetRouterHttpRequest;
import com.google.cloud.compute.v1.GetRouterStatusRouterHttpRequest;
import com.google.cloud.compute.v1.InsertRouterHttpRequest;
import com.google.cloud.compute.v1.ListRoutersHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRouterHttpRequest;
import com.google.cloud.compute.v1.PreviewRouterHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionRouterName;
import com.google.cloud.compute.v1.Router;
import com.google.cloud.compute.v1.RouterAggregatedList;
import com.google.cloud.compute.v1.RouterClient;
import com.google.cloud.compute.v1.RouterList;
import com.google.cloud.compute.v1.RouterStatusResponse;
import com.google.cloud.compute.v1.RoutersPreviewResponse;
import com.google.cloud.compute.v1.UpdateRouterHttpRequest;
import com.google.cloud.compute.v1.VmEndpointNatMappingsList;
import com.google.cloud.compute.v1.stub.HttpJsonRouterCallableFactory;
import com.google.cloud.compute.v1.stub.RouterStub;
import com.google.cloud.compute.v1.stub.RouterStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonRouterStub
extends RouterStub {
    @InternalApi
    public static final ApiMethodDescriptor<AggregatedListRoutersHttpRequest, RouterAggregatedList> aggregatedListRoutersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routers.aggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/aggregated/routers")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "includeAllScopes", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)RouterAggregatedList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeleteRouterHttpRequest, Operation> deleteRouterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routers.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/routers/{router}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionRouterName.newFactory()).setResourceNameField("router").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetRouterHttpRequest, Router> getRouterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routers.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/routers/{router}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectRegionRouterName.newFactory()).setResourceNameField("router").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Router.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetNatMappingInfoRoutersHttpRequest, VmEndpointNatMappingsList> getNatMappingInfoRoutersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routers.getNatMappingInfo").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/routers/{router}/getNatMappingInfo")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectRegionRouterName.newFactory()).setResourceNameField("router").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)VmEndpointNatMappingsList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetRouterStatusRouterHttpRequest, RouterStatusResponse> getRouterStatusRouterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routers.getRouterStatus").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/routers/{router}/getRouterStatus")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectRegionRouterName.newFactory()).setResourceNameField("router").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)RouterStatusResponse.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertRouterHttpRequest, Operation> insertRouterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routers.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/routers")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListRoutersHttpRequest, RouterList> listRoutersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routers.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/routers")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)RouterList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchRouterHttpRequest, Operation> patchRouterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routers.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/routers/{router}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionRouterName.newFactory()).setResourceNameField("router").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PreviewRouterHttpRequest, RoutersPreviewResponse> previewRouterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routers.preview").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/routers/{router}/preview")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectRegionRouterName.newFactory()).setResourceNameField("router").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)RoutersPreviewResponse.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<UpdateRouterHttpRequest, Operation> updateRouterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routers.update").setHttpMethod("PUT").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/routers/{router}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionRouterName.newFactory()).setResourceNameField("router").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<AggregatedListRoutersHttpRequest, RouterAggregatedList> aggregatedListRoutersCallable;
    private final UnaryCallable<AggregatedListRoutersHttpRequest, RouterClient.AggregatedListRoutersPagedResponse> aggregatedListRoutersPagedCallable;
    private final UnaryCallable<DeleteRouterHttpRequest, Operation> deleteRouterCallable;
    private final UnaryCallable<GetRouterHttpRequest, Router> getRouterCallable;
    private final UnaryCallable<GetNatMappingInfoRoutersHttpRequest, VmEndpointNatMappingsList> getNatMappingInfoRoutersCallable;
    private final UnaryCallable<GetNatMappingInfoRoutersHttpRequest, RouterClient.GetNatMappingInfoRoutersPagedResponse> getNatMappingInfoRoutersPagedCallable;
    private final UnaryCallable<GetRouterStatusRouterHttpRequest, RouterStatusResponse> getRouterStatusRouterCallable;
    private final UnaryCallable<InsertRouterHttpRequest, Operation> insertRouterCallable;
    private final UnaryCallable<ListRoutersHttpRequest, RouterList> listRoutersCallable;
    private final UnaryCallable<ListRoutersHttpRequest, RouterClient.ListRoutersPagedResponse> listRoutersPagedCallable;
    private final UnaryCallable<PatchRouterHttpRequest, Operation> patchRouterCallable;
    private final UnaryCallable<PreviewRouterHttpRequest, RoutersPreviewResponse> previewRouterCallable;
    private final UnaryCallable<UpdateRouterHttpRequest, Operation> updateRouterCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRouterStub create(RouterStubSettings settings) throws IOException {
        return new HttpJsonRouterStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRouterStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRouterStub(RouterStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonRouterStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRouterStub(RouterStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRouterStub(RouterStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRouterCallableFactory());
    }

    protected HttpJsonRouterStub(RouterStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings aggregatedListRoutersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListRoutersMethodDescriptor).build();
        HttpJsonCallSettings deleteRouterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRouterMethodDescriptor).build();
        HttpJsonCallSettings getRouterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRouterMethodDescriptor).build();
        HttpJsonCallSettings getNatMappingInfoRoutersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getNatMappingInfoRoutersMethodDescriptor).build();
        HttpJsonCallSettings getRouterStatusRouterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRouterStatusRouterMethodDescriptor).build();
        HttpJsonCallSettings insertRouterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertRouterMethodDescriptor).build();
        HttpJsonCallSettings listRoutersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRoutersMethodDescriptor).build();
        HttpJsonCallSettings patchRouterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchRouterMethodDescriptor).build();
        HttpJsonCallSettings previewRouterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(previewRouterMethodDescriptor).build();
        HttpJsonCallSettings updateRouterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateRouterMethodDescriptor).build();
        this.aggregatedListRoutersCallable = callableFactory.createUnaryCallable(aggregatedListRoutersTransportSettings, settings.aggregatedListRoutersSettings(), clientContext);
        this.aggregatedListRoutersPagedCallable = callableFactory.createPagedCallable(aggregatedListRoutersTransportSettings, settings.aggregatedListRoutersSettings(), clientContext);
        this.deleteRouterCallable = callableFactory.createUnaryCallable(deleteRouterTransportSettings, settings.deleteRouterSettings(), clientContext);
        this.getRouterCallable = callableFactory.createUnaryCallable(getRouterTransportSettings, settings.getRouterSettings(), clientContext);
        this.getNatMappingInfoRoutersCallable = callableFactory.createUnaryCallable(getNatMappingInfoRoutersTransportSettings, settings.getNatMappingInfoRoutersSettings(), clientContext);
        this.getNatMappingInfoRoutersPagedCallable = callableFactory.createPagedCallable(getNatMappingInfoRoutersTransportSettings, settings.getNatMappingInfoRoutersSettings(), clientContext);
        this.getRouterStatusRouterCallable = callableFactory.createUnaryCallable(getRouterStatusRouterTransportSettings, settings.getRouterStatusRouterSettings(), clientContext);
        this.insertRouterCallable = callableFactory.createUnaryCallable(insertRouterTransportSettings, settings.insertRouterSettings(), clientContext);
        this.listRoutersCallable = callableFactory.createUnaryCallable(listRoutersTransportSettings, settings.listRoutersSettings(), clientContext);
        this.listRoutersPagedCallable = callableFactory.createPagedCallable(listRoutersTransportSettings, settings.listRoutersSettings(), clientContext);
        this.patchRouterCallable = callableFactory.createUnaryCallable(patchRouterTransportSettings, settings.patchRouterSettings(), clientContext);
        this.previewRouterCallable = callableFactory.createUnaryCallable(previewRouterTransportSettings, settings.previewRouterSettings(), clientContext);
        this.updateRouterCallable = callableFactory.createUnaryCallable(updateRouterTransportSettings, settings.updateRouterSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListRoutersHttpRequest, RouterClient.AggregatedListRoutersPagedResponse> aggregatedListRoutersPagedCallable() {
        return this.aggregatedListRoutersPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListRoutersHttpRequest, RouterAggregatedList> aggregatedListRoutersCallable() {
        return this.aggregatedListRoutersCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteRouterHttpRequest, Operation> deleteRouterCallable() {
        return this.deleteRouterCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetRouterHttpRequest, Router> getRouterCallable() {
        return this.getRouterCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetNatMappingInfoRoutersHttpRequest, RouterClient.GetNatMappingInfoRoutersPagedResponse> getNatMappingInfoRoutersPagedCallable() {
        return this.getNatMappingInfoRoutersPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetNatMappingInfoRoutersHttpRequest, VmEndpointNatMappingsList> getNatMappingInfoRoutersCallable() {
        return this.getNatMappingInfoRoutersCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetRouterStatusRouterHttpRequest, RouterStatusResponse> getRouterStatusRouterCallable() {
        return this.getRouterStatusRouterCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertRouterHttpRequest, Operation> insertRouterCallable() {
        return this.insertRouterCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListRoutersHttpRequest, RouterClient.ListRoutersPagedResponse> listRoutersPagedCallable() {
        return this.listRoutersPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListRoutersHttpRequest, RouterList> listRoutersCallable() {
        return this.listRoutersCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchRouterHttpRequest, Operation> patchRouterCallable() {
        return this.patchRouterCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PreviewRouterHttpRequest, RoutersPreviewResponse> previewRouterCallable() {
        return this.previewRouterCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<UpdateRouterHttpRequest, Operation> updateRouterCallable() {
        return this.updateRouterCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

