/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.Address;
import com.google.cloud.compute.v1.AddressAggregatedList;
import com.google.cloud.compute.v1.AddressList;
import com.google.cloud.compute.v1.AddressSettings;
import com.google.cloud.compute.v1.AddressesScopedList;
import com.google.cloud.compute.v1.AggregatedListAddressesHttpRequest;
import com.google.cloud.compute.v1.DeleteAddressHttpRequest;
import com.google.cloud.compute.v1.GetAddressHttpRequest;
import com.google.cloud.compute.v1.InsertAddressHttpRequest;
import com.google.cloud.compute.v1.ListAddressesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionAddressName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.stub.AddressStub;
import com.google.cloud.compute.v1.stub.AddressStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AddressClient
implements BackgroundResource {
    private final AddressSettings settings;
    private final AddressStub stub;

    public static final AddressClient create() throws IOException {
        return AddressClient.create(AddressSettings.newBuilder().build());
    }

    public static final AddressClient create(AddressSettings settings) throws IOException {
        return new AddressClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AddressClient create(AddressStub stub) {
        return new AddressClient(stub);
    }

    protected AddressClient(AddressSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AddressStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AddressClient(AddressStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AddressSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AddressStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListAddressesPagedResponse aggregatedListAddresses(Boolean includeAllScopes, ProjectName project) {
        AggregatedListAddressesHttpRequest request = AggregatedListAddressesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListAddresses(request);
    }

    @BetaApi
    public final AggregatedListAddressesPagedResponse aggregatedListAddresses(Boolean includeAllScopes, String project) {
        AggregatedListAddressesHttpRequest request = AggregatedListAddressesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project).build();
        return this.aggregatedListAddresses(request);
    }

    @BetaApi
    public final AggregatedListAddressesPagedResponse aggregatedListAddresses(AggregatedListAddressesHttpRequest request) {
        return (AggregatedListAddressesPagedResponse)((Object)this.aggregatedListAddressesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListAddressesHttpRequest, AggregatedListAddressesPagedResponse> aggregatedListAddressesPagedCallable() {
        return this.stub.aggregatedListAddressesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListAddressesHttpRequest, AddressAggregatedList> aggregatedListAddressesCallable() {
        return this.stub.aggregatedListAddressesCallable();
    }

    @BetaApi
    public final Operation deleteAddress(ProjectRegionAddressName address) {
        DeleteAddressHttpRequest request = DeleteAddressHttpRequest.newBuilder().setAddress(address == null ? null : address.toString()).build();
        return this.deleteAddress(request);
    }

    @BetaApi
    public final Operation deleteAddress(String address) {
        DeleteAddressHttpRequest request = DeleteAddressHttpRequest.newBuilder().setAddress(address).build();
        return this.deleteAddress(request);
    }

    @BetaApi
    public final Operation deleteAddress(DeleteAddressHttpRequest request) {
        return (Operation)this.deleteAddressCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteAddressHttpRequest, Operation> deleteAddressCallable() {
        return this.stub.deleteAddressCallable();
    }

    @BetaApi
    public final Address getAddress(ProjectRegionAddressName address) {
        GetAddressHttpRequest request = GetAddressHttpRequest.newBuilder().setAddress(address == null ? null : address.toString()).build();
        return this.getAddress(request);
    }

    @BetaApi
    public final Address getAddress(String address) {
        GetAddressHttpRequest request = GetAddressHttpRequest.newBuilder().setAddress(address).build();
        return this.getAddress(request);
    }

    @BetaApi
    public final Address getAddress(GetAddressHttpRequest request) {
        return (Address)this.getAddressCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetAddressHttpRequest, Address> getAddressCallable() {
        return this.stub.getAddressCallable();
    }

    @BetaApi
    public final Operation insertAddress(ProjectRegionName region, Address addressResource) {
        InsertAddressHttpRequest request = InsertAddressHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setAddressResource(addressResource).build();
        return this.insertAddress(request);
    }

    @BetaApi
    public final Operation insertAddress(String region, Address addressResource) {
        InsertAddressHttpRequest request = InsertAddressHttpRequest.newBuilder().setRegion(region).setAddressResource(addressResource).build();
        return this.insertAddress(request);
    }

    @BetaApi
    public final Operation insertAddress(InsertAddressHttpRequest request) {
        return (Operation)this.insertAddressCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertAddressHttpRequest, Operation> insertAddressCallable() {
        return this.stub.insertAddressCallable();
    }

    @BetaApi
    public final ListAddressesPagedResponse listAddresses(ProjectRegionName region) {
        ListAddressesHttpRequest request = ListAddressesHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listAddresses(request);
    }

    @BetaApi
    public final ListAddressesPagedResponse listAddresses(String region) {
        ListAddressesHttpRequest request = ListAddressesHttpRequest.newBuilder().setRegion(region).build();
        return this.listAddresses(request);
    }

    @BetaApi
    public final ListAddressesPagedResponse listAddresses(ListAddressesHttpRequest request) {
        return (ListAddressesPagedResponse)((Object)this.listAddressesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListAddressesHttpRequest, ListAddressesPagedResponse> listAddressesPagedCallable() {
        return this.stub.listAddressesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListAddressesHttpRequest, AddressList> listAddressesCallable() {
        return this.stub.listAddressesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAddressesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAddressesHttpRequest, AddressList, Address, ListAddressesPage, ListAddressesFixedSizeCollection> {
        private ListAddressesFixedSizeCollection(List<ListAddressesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAddressesFixedSizeCollection createEmptyCollection() {
            return new ListAddressesFixedSizeCollection(null, 0);
        }

        protected ListAddressesFixedSizeCollection createCollection(List<ListAddressesPage> pages, int collectionSize) {
            return new ListAddressesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAddressesPage
    extends AbstractPage<ListAddressesHttpRequest, AddressList, Address, ListAddressesPage> {
        private ListAddressesPage(PageContext<ListAddressesHttpRequest, AddressList, Address> context, AddressList response) {
            super(context, (Object)response);
        }

        private static ListAddressesPage createEmptyPage() {
            return new ListAddressesPage(null, null);
        }

        protected ListAddressesPage createPage(PageContext<ListAddressesHttpRequest, AddressList, Address> context, AddressList response) {
            return new ListAddressesPage(context, response);
        }

        public ApiFuture<ListAddressesPage> createPageAsync(PageContext<ListAddressesHttpRequest, AddressList, Address> context, ApiFuture<AddressList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAddressesPagedResponse
    extends AbstractPagedListResponse<ListAddressesHttpRequest, AddressList, Address, ListAddressesPage, ListAddressesFixedSizeCollection> {
        public static ApiFuture<ListAddressesPagedResponse> createAsync(PageContext<ListAddressesHttpRequest, AddressList, Address> context, ApiFuture<AddressList> futureResponse) {
            ApiFuture<ListAddressesPage> futurePage = ListAddressesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListAddressesPage, ListAddressesPagedResponse>(){

                public ListAddressesPagedResponse apply(ListAddressesPage input) {
                    return new ListAddressesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListAddressesPagedResponse(ListAddressesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAddressesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListAddressesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressesScopedList, AggregatedListAddressesPage, AggregatedListAddressesFixedSizeCollection> {
        private AggregatedListAddressesFixedSizeCollection(List<AggregatedListAddressesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListAddressesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListAddressesFixedSizeCollection(null, 0);
        }

        protected AggregatedListAddressesFixedSizeCollection createCollection(List<AggregatedListAddressesPage> pages, int collectionSize) {
            return new AggregatedListAddressesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListAddressesPage
    extends AbstractPage<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressesScopedList, AggregatedListAddressesPage> {
        private AggregatedListAddressesPage(PageContext<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressesScopedList> context, AddressAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListAddressesPage createEmptyPage() {
            return new AggregatedListAddressesPage(null, null);
        }

        protected AggregatedListAddressesPage createPage(PageContext<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressesScopedList> context, AddressAggregatedList response) {
            return new AggregatedListAddressesPage(context, response);
        }

        public ApiFuture<AggregatedListAddressesPage> createPageAsync(PageContext<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressesScopedList> context, ApiFuture<AddressAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListAddressesPagedResponse
    extends AbstractPagedListResponse<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressesScopedList, AggregatedListAddressesPage, AggregatedListAddressesFixedSizeCollection> {
        public static ApiFuture<AggregatedListAddressesPagedResponse> createAsync(PageContext<AggregatedListAddressesHttpRequest, AddressAggregatedList, AddressesScopedList> context, ApiFuture<AddressAggregatedList> futureResponse) {
            ApiFuture<AggregatedListAddressesPage> futurePage = AggregatedListAddressesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListAddressesPage, AggregatedListAddressesPagedResponse>(){

                public AggregatedListAddressesPagedResponse apply(AggregatedListAddressesPage input) {
                    return new AggregatedListAddressesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListAddressesPagedResponse(AggregatedListAddressesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListAddressesFixedSizeCollection.createEmptyCollection());
        }
    }
}

