/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcRawCallableFactory;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.api.gax.retrying.StreamingRetryAlgorithm;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.cloud.bigquery.storage.v1.BigQueryReadGrpc;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.Singletons;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1.stub.EnhancedBigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1.stub.GrpcBigQueryReadStub;
import com.google.cloud.bigquery.storage.v1.stub.readrows.ApiResultRetryAlgorithm;
import com.google.cloud.bigquery.storage.v1.stub.readrows.ReadRowsRetryingCallable;
import com.google.common.collect.ImmutableMap;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class EnhancedBigQueryReadStub
implements BackgroundResource {
    private static final String TRACING_OUTER_CLIENT_NAME = "BigQueryStorage";
    private final GrpcBigQueryReadStub stub;
    private final BigQueryReadStubSettings stubSettings;
    private final BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener;
    private final ClientContext context;
    private boolean enableOpenTelemetryTracing = false;
    private Tracer openTelemetryTracer = null;

    public static EnhancedBigQueryReadStub create(EnhancedBigQueryReadStubSettings settings) throws IOException {
        return EnhancedBigQueryReadStub.create(settings, null);
    }

    public static EnhancedBigQueryReadStub create(EnhancedBigQueryReadStubSettings settings, BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener) throws IOException {
        return EnhancedBigQueryReadStub.create(settings, readRowsRetryAttemptListener, false, null);
    }

    public static EnhancedBigQueryReadStub create(EnhancedBigQueryReadStubSettings settings, BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener, boolean enableOpenTelemetryTracing, TracerProvider openTelemetryTracerProvider) throws IOException {
        BigQueryReadStubSettings.Builder baseSettingsBuilder = (BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)BigQueryReadStubSettings.newBuilder().setUniverseDomain(settings.getUniverseDomain())).setTransportChannelProvider(settings.getTransportChannelProvider())).setEndpoint(settings.getEndpoint())).setHeaderProvider(settings.getHeaderProvider())).setCredentialsProvider(settings.getCredentialsProvider())).setStreamWatchdogCheckInterval(settings.getStreamWatchdogCheckInterval())).setStreamWatchdogProvider(settings.getStreamWatchdogProvider())).setBackgroundExecutorProvider(settings.getBackgroundExecutorProvider());
        baseSettingsBuilder.createReadSessionSettings().setRetryableCodes(settings.createReadSessionSettings().getRetryableCodes()).setRetrySettings(settings.createReadSessionSettings().getRetrySettings());
        baseSettingsBuilder.readRowsSettings().setRetryableCodes(settings.readRowsSettings().getRetryableCodes()).setRetrySettings(settings.readRowsSettings().getRetrySettings()).setResumptionStrategy(settings.readRowsSettings().getResumptionStrategy()).setIdleTimeout(settings.readRowsSettings().getIdleTimeout());
        baseSettingsBuilder.splitReadStreamSettings().setRetryableCodes(settings.splitReadStreamSettings().getRetryableCodes()).setRetrySettings(settings.splitReadStreamSettings().getRetrySettings());
        BigQueryReadStubSettings baseSettings = baseSettingsBuilder.build();
        ClientContext clientContext = ClientContext.create((StubSettings)baseSettings);
        GrpcBigQueryReadStub stub = new GrpcBigQueryReadStub(baseSettings, clientContext);
        return new EnhancedBigQueryReadStub(stub, baseSettings, readRowsRetryAttemptListener, clientContext, enableOpenTelemetryTracing, openTelemetryTracerProvider);
    }

    @InternalApi(value="Visible for testing")
    EnhancedBigQueryReadStub(GrpcBigQueryReadStub stub, BigQueryReadStubSettings stubSettings, BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener, ClientContext context, boolean enableOpenTelemetryTracing, TracerProvider openTelemetryTracerProvider) {
        this.stub = stub;
        this.stubSettings = stubSettings;
        this.readRowsRetryAttemptListener = readRowsRetryAttemptListener;
        this.context = context;
        this.enableOpenTelemetryTracing = enableOpenTelemetryTracing;
        if (enableOpenTelemetryTracing) {
            this.openTelemetryTracer = openTelemetryTracerProvider == null ? Singletons.getOpenTelemetry().getTracerProvider().tracerBuilder("com.google.cloud.bigquery.storage.v1.read.stub").build() : openTelemetryTracerProvider.tracerBuilder("com.google.cloud.bigquery.storage.v1.read.stub").build();
        }
    }

    public UnaryCallable<CreateReadSessionRequest, ReadSession> createReadSessionCallable() {
        Span createReadSessionCallable = null;
        if (this.enableOpenTelemetryTracing) {
            createReadSessionCallable = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.createReadSessionCallable").startSpan();
        }
        try {
            UnaryCallable<CreateReadSessionRequest, ReadSession> unaryCallable;
            block11: {
                Scope createReadSessionCallableScope = createReadSessionCallable != null ? createReadSessionCallable.makeCurrent() : null;
                try {
                    unaryCallable = this.stub.createReadSessionCallable();
                    if (createReadSessionCallableScope == null) break block11;
                }
                catch (Throwable throwable) {
                    if (createReadSessionCallableScope != null) {
                        try {
                            createReadSessionCallableScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                createReadSessionCallableScope.close();
            }
            return unaryCallable;
        }
        finally {
            if (createReadSessionCallable != null) {
                createReadSessionCallable.end();
            }
        }
    }

    public ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        Span readRowsCallable = null;
        if (this.enableOpenTelemetryTracing) {
            readRowsCallable = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.readRowsCallable").startSpan();
        }
        try {
            ServerStreamingCallable serverStreamingCallable;
            block12: {
                Scope readRowsCallableScope = readRowsCallable != null ? readRowsCallable.makeCurrent() : null;
                try {
                    ServerStreamingCallable innerCallable = GrpcRawCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigQueryReadGrpc.getReadRowsMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReadRowsRequest>(){

                        public Map<String, String> extract(ReadRowsRequest request) {
                            return ImmutableMap.of((Object)"read_stream", (Object)String.valueOf(request.getReadStream()));
                        }
                    }).build(), (Set)this.stubSettings.readRowsSettings().getRetryableCodes());
                    ServerStreamingCallSettings<ReadRowsRequest, ReadRowsResponse> callSettings = this.stubSettings.readRowsSettings();
                    StreamingRetryAlgorithm retryAlgorithm = new StreamingRetryAlgorithm(new ApiResultRetryAlgorithm(this.readRowsRetryAttemptListener), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(callSettings.getRetrySettings(), this.context.getClock()));
                    ScheduledRetryingExecutor retryingExecutor = new ScheduledRetryingExecutor((RetryAlgorithm)retryAlgorithm, this.context.getExecutor());
                    if (this.context.getStreamWatchdog() != null) {
                        innerCallable = Callables.watched((ServerStreamingCallable)innerCallable, callSettings, (ClientContext)this.context);
                    }
                    ReadRowsRetryingCallable outerCallable = new ReadRowsRetryingCallable(this.context.getDefaultCallContext(), (ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse>)innerCallable, (ScheduledRetryingExecutor<Void>)retryingExecutor, (StreamResumptionStrategy<ReadRowsRequest, ReadRowsResponse>)callSettings.getResumptionStrategy());
                    TracedServerStreamingCallable traced = new TracedServerStreamingCallable((ServerStreamingCallable)outerCallable, this.context.getTracerFactory(), SpanName.of((String)TRACING_OUTER_CLIENT_NAME, (String)"ReadRows"));
                    serverStreamingCallable = traced.withDefaultCallContext(this.context.getDefaultCallContext());
                    if (readRowsCallableScope == null) break block12;
                }
                catch (Throwable throwable) {
                    if (readRowsCallableScope != null) {
                        try {
                            readRowsCallableScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                readRowsCallableScope.close();
            }
            return serverStreamingCallable;
        }
        finally {
            if (readRowsCallable != null) {
                readRowsCallable.end();
            }
        }
    }

    public UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamCallable() {
        Span splitReadStreamCallable = null;
        if (this.enableOpenTelemetryTracing) {
            splitReadStreamCallable = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.splitReadStreamCallable").startSpan();
        }
        try {
            UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> unaryCallable;
            block11: {
                Scope readRowsCallableScope = splitReadStreamCallable != null ? splitReadStreamCallable.makeCurrent() : null;
                try {
                    unaryCallable = this.stub.splitReadStreamCallable();
                    if (readRowsCallableScope == null) break block11;
                }
                catch (Throwable throwable) {
                    if (readRowsCallableScope != null) {
                        try {
                            readRowsCallableScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                readRowsCallableScope.close();
            }
            return unaryCallable;
        }
        finally {
            if (splitReadStreamCallable != null) {
                splitReadStreamCallable.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Span close = null;
        if (this.enableOpenTelemetryTracing) {
            close = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.close").startSpan();
        }
        try (Scope closeScope = close != null ? close.makeCurrent() : null;){
            this.stub.close();
        }
        finally {
            if (close != null) {
                close.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Span shutdown = null;
        if (this.enableOpenTelemetryTracing) {
            shutdown = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.shutdown").startSpan();
        }
        try (Scope shutdownScope = shutdown != null ? shutdown.makeCurrent() : null;){
            this.stub.shutdown();
        }
        finally {
            if (shutdown != null) {
                shutdown.end();
            }
        }
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        Span shutdownNow = null;
        if (this.enableOpenTelemetryTracing) {
            shutdownNow = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.shutdownNow").startSpan();
        }
        try (Scope shutdownNowScope = shutdownNow != null ? shutdownNow.makeCurrent() : null;){
            this.stub.shutdownNow();
        }
        finally {
            if (shutdownNow != null) {
                shutdownNow.end();
            }
        }
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        Span awaitTermination = null;
        if (this.enableOpenTelemetryTracing) {
            awaitTermination = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.awaitTermination").setAttribute("duration", duration).setAttribute("unit", unit.toString()).startSpan();
        }
        try {
            boolean bl;
            block11: {
                Scope awaitTerminationScope = awaitTermination != null ? awaitTermination.makeCurrent() : null;
                try {
                    bl = this.stub.awaitTermination(duration, unit);
                    if (awaitTerminationScope == null) break block11;
                }
                catch (Throwable throwable) {
                    if (awaitTerminationScope != null) {
                        try {
                            awaitTerminationScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                awaitTerminationScope.close();
            }
            return bl;
        }
        finally {
            if (awaitTermination != null) {
                awaitTermination.end();
            }
        }
    }

    public BigQueryReadStubSettings getStubSettings() {
        return this.stubSettings;
    }
}

