/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * The column metadata index pruning statistics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PruningStats extends com.google.api.client.json.GenericJson {

  /**
   * The number of parallel inputs matched.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long postCmetaPruningParallelInputCount;

  /**
   * The number of partitions matched.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long postCmetaPruningPartitionCount;

  /**
   * The number of parallel inputs scanned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long preCmetaPruningParallelInputCount;

  /**
   * The number of parallel inputs matched.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPostCmetaPruningParallelInputCount() {
    return postCmetaPruningParallelInputCount;
  }

  /**
   * The number of parallel inputs matched.
   * @param postCmetaPruningParallelInputCount postCmetaPruningParallelInputCount or {@code null} for none
   */
  public PruningStats setPostCmetaPruningParallelInputCount(java.lang.Long postCmetaPruningParallelInputCount) {
    this.postCmetaPruningParallelInputCount = postCmetaPruningParallelInputCount;
    return this;
  }

  /**
   * The number of partitions matched.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPostCmetaPruningPartitionCount() {
    return postCmetaPruningPartitionCount;
  }

  /**
   * The number of partitions matched.
   * @param postCmetaPruningPartitionCount postCmetaPruningPartitionCount or {@code null} for none
   */
  public PruningStats setPostCmetaPruningPartitionCount(java.lang.Long postCmetaPruningPartitionCount) {
    this.postCmetaPruningPartitionCount = postCmetaPruningPartitionCount;
    return this;
  }

  /**
   * The number of parallel inputs scanned.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPreCmetaPruningParallelInputCount() {
    return preCmetaPruningParallelInputCount;
  }

  /**
   * The number of parallel inputs scanned.
   * @param preCmetaPruningParallelInputCount preCmetaPruningParallelInputCount or {@code null} for none
   */
  public PruningStats setPreCmetaPruningParallelInputCount(java.lang.Long preCmetaPruningParallelInputCount) {
    this.preCmetaPruningParallelInputCount = preCmetaPruningParallelInputCount;
    return this;
  }

  @Override
  public PruningStats set(String fieldName, Object value) {
    return (PruningStats) super.set(fieldName, value);
  }

  @Override
  public PruningStats clone() {
    return (PruningStats) super.clone();
  }

}
