/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Hyperparameter search spaces. These should be a subset of training_options.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HparamSearchSpaces extends com.google.api.client.json.GenericJson {

  /**
   * Activation functions of neural network models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StringHparamSearchSpace activationFn;

  /**
   * Mini batch sample size.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IntHparamSearchSpace batchSize;

  /**
   * Booster type for boosted tree models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StringHparamSearchSpace boosterType;

  /**
   * Subsample ratio of columns for each level for boosted tree models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DoubleHparamSearchSpace colsampleBylevel;

  /**
   * Subsample ratio of columns for each node(split) for boosted tree models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DoubleHparamSearchSpace colsampleBynode;

  /**
   * Subsample ratio of columns when constructing each tree for boosted tree models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DoubleHparamSearchSpace colsampleBytree;

  /**
   * Dart normalization type for boosted tree models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StringHparamSearchSpace dartNormalizeType;

  /**
   * Dropout probability for dnn model training and boosted tree models using dart booster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DoubleHparamSearchSpace dropout;

  /**
   * Hidden units for neural network models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IntArrayHparamSearchSpace hiddenUnits;

  /**
   * L1 regularization coefficient.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DoubleHparamSearchSpace l1Reg;

  /**
   * L2 regularization coefficient.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DoubleHparamSearchSpace l2Reg;

  /**
   * Learning rate of training jobs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DoubleHparamSearchSpace learnRate;

  /**
   * Maximum depth of a tree for boosted tree models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IntHparamSearchSpace maxTreeDepth;

  /**
   * Minimum split loss for boosted tree models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DoubleHparamSearchSpace minSplitLoss;

  /**
   * Minimum sum of instance weight needed in a child for boosted tree models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IntHparamSearchSpace minTreeChildWeight;

  /**
   * Number of clusters for k-means.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IntHparamSearchSpace numClusters;

  /**
   * Number of latent factors to train on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IntHparamSearchSpace numFactors;

  /**
   * Number of parallel trees for boosted tree models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IntHparamSearchSpace numParallelTree;

  /**
   * Optimizer of TF models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StringHparamSearchSpace optimizer;

  /**
   * Subsample the training data to grow tree to prevent overfitting for boosted tree models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DoubleHparamSearchSpace subsample;

  /**
   * Tree construction algorithm for boosted tree models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StringHparamSearchSpace treeMethod;

  /**
   * Hyperparameter for matrix factoration when implicit feedback type is specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DoubleHparamSearchSpace walsAlpha;

  /**
   * Activation functions of neural network models.
   * @return value or {@code null} for none
   */
  public StringHparamSearchSpace getActivationFn() {
    return activationFn;
  }

  /**
   * Activation functions of neural network models.
   * @param activationFn activationFn or {@code null} for none
   */
  public HparamSearchSpaces setActivationFn(StringHparamSearchSpace activationFn) {
    this.activationFn = activationFn;
    return this;
  }

  /**
   * Mini batch sample size.
   * @return value or {@code null} for none
   */
  public IntHparamSearchSpace getBatchSize() {
    return batchSize;
  }

  /**
   * Mini batch sample size.
   * @param batchSize batchSize or {@code null} for none
   */
  public HparamSearchSpaces setBatchSize(IntHparamSearchSpace batchSize) {
    this.batchSize = batchSize;
    return this;
  }

  /**
   * Booster type for boosted tree models.
   * @return value or {@code null} for none
   */
  public StringHparamSearchSpace getBoosterType() {
    return boosterType;
  }

  /**
   * Booster type for boosted tree models.
   * @param boosterType boosterType or {@code null} for none
   */
  public HparamSearchSpaces setBoosterType(StringHparamSearchSpace boosterType) {
    this.boosterType = boosterType;
    return this;
  }

  /**
   * Subsample ratio of columns for each level for boosted tree models.
   * @return value or {@code null} for none
   */
  public DoubleHparamSearchSpace getColsampleBylevel() {
    return colsampleBylevel;
  }

  /**
   * Subsample ratio of columns for each level for boosted tree models.
   * @param colsampleBylevel colsampleBylevel or {@code null} for none
   */
  public HparamSearchSpaces setColsampleBylevel(DoubleHparamSearchSpace colsampleBylevel) {
    this.colsampleBylevel = colsampleBylevel;
    return this;
  }

  /**
   * Subsample ratio of columns for each node(split) for boosted tree models.
   * @return value or {@code null} for none
   */
  public DoubleHparamSearchSpace getColsampleBynode() {
    return colsampleBynode;
  }

  /**
   * Subsample ratio of columns for each node(split) for boosted tree models.
   * @param colsampleBynode colsampleBynode or {@code null} for none
   */
  public HparamSearchSpaces setColsampleBynode(DoubleHparamSearchSpace colsampleBynode) {
    this.colsampleBynode = colsampleBynode;
    return this;
  }

  /**
   * Subsample ratio of columns when constructing each tree for boosted tree models.
   * @return value or {@code null} for none
   */
  public DoubleHparamSearchSpace getColsampleBytree() {
    return colsampleBytree;
  }

  /**
   * Subsample ratio of columns when constructing each tree for boosted tree models.
   * @param colsampleBytree colsampleBytree or {@code null} for none
   */
  public HparamSearchSpaces setColsampleBytree(DoubleHparamSearchSpace colsampleBytree) {
    this.colsampleBytree = colsampleBytree;
    return this;
  }

  /**
   * Dart normalization type for boosted tree models.
   * @return value or {@code null} for none
   */
  public StringHparamSearchSpace getDartNormalizeType() {
    return dartNormalizeType;
  }

  /**
   * Dart normalization type for boosted tree models.
   * @param dartNormalizeType dartNormalizeType or {@code null} for none
   */
  public HparamSearchSpaces setDartNormalizeType(StringHparamSearchSpace dartNormalizeType) {
    this.dartNormalizeType = dartNormalizeType;
    return this;
  }

  /**
   * Dropout probability for dnn model training and boosted tree models using dart booster.
   * @return value or {@code null} for none
   */
  public DoubleHparamSearchSpace getDropout() {
    return dropout;
  }

  /**
   * Dropout probability for dnn model training and boosted tree models using dart booster.
   * @param dropout dropout or {@code null} for none
   */
  public HparamSearchSpaces setDropout(DoubleHparamSearchSpace dropout) {
    this.dropout = dropout;
    return this;
  }

  /**
   * Hidden units for neural network models.
   * @return value or {@code null} for none
   */
  public IntArrayHparamSearchSpace getHiddenUnits() {
    return hiddenUnits;
  }

  /**
   * Hidden units for neural network models.
   * @param hiddenUnits hiddenUnits or {@code null} for none
   */
  public HparamSearchSpaces setHiddenUnits(IntArrayHparamSearchSpace hiddenUnits) {
    this.hiddenUnits = hiddenUnits;
    return this;
  }

  /**
   * L1 regularization coefficient.
   * @return value or {@code null} for none
   */
  public DoubleHparamSearchSpace getL1Reg() {
    return l1Reg;
  }

  /**
   * L1 regularization coefficient.
   * @param l1Reg l1Reg or {@code null} for none
   */
  public HparamSearchSpaces setL1Reg(DoubleHparamSearchSpace l1Reg) {
    this.l1Reg = l1Reg;
    return this;
  }

  /**
   * L2 regularization coefficient.
   * @return value or {@code null} for none
   */
  public DoubleHparamSearchSpace getL2Reg() {
    return l2Reg;
  }

  /**
   * L2 regularization coefficient.
   * @param l2Reg l2Reg or {@code null} for none
   */
  public HparamSearchSpaces setL2Reg(DoubleHparamSearchSpace l2Reg) {
    this.l2Reg = l2Reg;
    return this;
  }

  /**
   * Learning rate of training jobs.
   * @return value or {@code null} for none
   */
  public DoubleHparamSearchSpace getLearnRate() {
    return learnRate;
  }

  /**
   * Learning rate of training jobs.
   * @param learnRate learnRate or {@code null} for none
   */
  public HparamSearchSpaces setLearnRate(DoubleHparamSearchSpace learnRate) {
    this.learnRate = learnRate;
    return this;
  }

  /**
   * Maximum depth of a tree for boosted tree models.
   * @return value or {@code null} for none
   */
  public IntHparamSearchSpace getMaxTreeDepth() {
    return maxTreeDepth;
  }

  /**
   * Maximum depth of a tree for boosted tree models.
   * @param maxTreeDepth maxTreeDepth or {@code null} for none
   */
  public HparamSearchSpaces setMaxTreeDepth(IntHparamSearchSpace maxTreeDepth) {
    this.maxTreeDepth = maxTreeDepth;
    return this;
  }

  /**
   * Minimum split loss for boosted tree models.
   * @return value or {@code null} for none
   */
  public DoubleHparamSearchSpace getMinSplitLoss() {
    return minSplitLoss;
  }

  /**
   * Minimum split loss for boosted tree models.
   * @param minSplitLoss minSplitLoss or {@code null} for none
   */
  public HparamSearchSpaces setMinSplitLoss(DoubleHparamSearchSpace minSplitLoss) {
    this.minSplitLoss = minSplitLoss;
    return this;
  }

  /**
   * Minimum sum of instance weight needed in a child for boosted tree models.
   * @return value or {@code null} for none
   */
  public IntHparamSearchSpace getMinTreeChildWeight() {
    return minTreeChildWeight;
  }

  /**
   * Minimum sum of instance weight needed in a child for boosted tree models.
   * @param minTreeChildWeight minTreeChildWeight or {@code null} for none
   */
  public HparamSearchSpaces setMinTreeChildWeight(IntHparamSearchSpace minTreeChildWeight) {
    this.minTreeChildWeight = minTreeChildWeight;
    return this;
  }

  /**
   * Number of clusters for k-means.
   * @return value or {@code null} for none
   */
  public IntHparamSearchSpace getNumClusters() {
    return numClusters;
  }

  /**
   * Number of clusters for k-means.
   * @param numClusters numClusters or {@code null} for none
   */
  public HparamSearchSpaces setNumClusters(IntHparamSearchSpace numClusters) {
    this.numClusters = numClusters;
    return this;
  }

  /**
   * Number of latent factors to train on.
   * @return value or {@code null} for none
   */
  public IntHparamSearchSpace getNumFactors() {
    return numFactors;
  }

  /**
   * Number of latent factors to train on.
   * @param numFactors numFactors or {@code null} for none
   */
  public HparamSearchSpaces setNumFactors(IntHparamSearchSpace numFactors) {
    this.numFactors = numFactors;
    return this;
  }

  /**
   * Number of parallel trees for boosted tree models.
   * @return value or {@code null} for none
   */
  public IntHparamSearchSpace getNumParallelTree() {
    return numParallelTree;
  }

  /**
   * Number of parallel trees for boosted tree models.
   * @param numParallelTree numParallelTree or {@code null} for none
   */
  public HparamSearchSpaces setNumParallelTree(IntHparamSearchSpace numParallelTree) {
    this.numParallelTree = numParallelTree;
    return this;
  }

  /**
   * Optimizer of TF models.
   * @return value or {@code null} for none
   */
  public StringHparamSearchSpace getOptimizer() {
    return optimizer;
  }

  /**
   * Optimizer of TF models.
   * @param optimizer optimizer or {@code null} for none
   */
  public HparamSearchSpaces setOptimizer(StringHparamSearchSpace optimizer) {
    this.optimizer = optimizer;
    return this;
  }

  /**
   * Subsample the training data to grow tree to prevent overfitting for boosted tree models.
   * @return value or {@code null} for none
   */
  public DoubleHparamSearchSpace getSubsample() {
    return subsample;
  }

  /**
   * Subsample the training data to grow tree to prevent overfitting for boosted tree models.
   * @param subsample subsample or {@code null} for none
   */
  public HparamSearchSpaces setSubsample(DoubleHparamSearchSpace subsample) {
    this.subsample = subsample;
    return this;
  }

  /**
   * Tree construction algorithm for boosted tree models.
   * @return value or {@code null} for none
   */
  public StringHparamSearchSpace getTreeMethod() {
    return treeMethod;
  }

  /**
   * Tree construction algorithm for boosted tree models.
   * @param treeMethod treeMethod or {@code null} for none
   */
  public HparamSearchSpaces setTreeMethod(StringHparamSearchSpace treeMethod) {
    this.treeMethod = treeMethod;
    return this;
  }

  /**
   * Hyperparameter for matrix factoration when implicit feedback type is specified.
   * @return value or {@code null} for none
   */
  public DoubleHparamSearchSpace getWalsAlpha() {
    return walsAlpha;
  }

  /**
   * Hyperparameter for matrix factoration when implicit feedback type is specified.
   * @param walsAlpha walsAlpha or {@code null} for none
   */
  public HparamSearchSpaces setWalsAlpha(DoubleHparamSearchSpace walsAlpha) {
    this.walsAlpha = walsAlpha;
    return this;
  }

  @Override
  public HparamSearchSpaces set(String fieldName, Object value) {
    return (HparamSearchSpaces) super.set(fieldName, value);
  }

  @Override
  public HparamSearchSpaces clone() {
    return (HparamSearchSpaces) super.clone();
  }

}
