/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Data policy option. For more information, see [Mask data by applying data policies to a
 * column](https://cloud.google.com/bigquery/docs/column-data-masking#data-policies-on-column/).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataPolicyOption extends com.google.api.client.json.GenericJson {

  /**
   * Data policy resource name in the form of
   * projects/project_id/locations/location_id/dataPolicies/data_policy_id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Data policy resource name in the form of
   * projects/project_id/locations/location_id/dataPolicies/data_policy_id.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Data policy resource name in the form of
   * projects/project_id/locations/location_id/dataPolicies/data_policy_id.
   * @param name name or {@code null} for none
   */
  public DataPolicyOption setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public DataPolicyOption set(String fieldName, Object value) {
    return (DataPolicyOption) super.set(fieldName, value);
  }

  @Override
  public DataPolicyOption clone() {
    return (DataPolicyOption) super.clone();
  }

}
